/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class CircularBuffer<T> {
    private final T[] buffer;
    private int bufferIdx;

    public CircularBuffer(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than 0.");
        }
        this.buffer = new Object[size];
    }

    public void add(T value) {
        if (Objects.isNull(value)) {
            throw new IllegalArgumentException("Value cannot be null.");
        }
        this.buffer[this.bufferIdx++ % this.buffer.length] = value;
    }

    public List<T> values() {
        ArrayList<T> values = new ArrayList<T>();
        for (int i = 0; i < this.buffer.length; ++i) {
            T value = this.buffer[(this.bufferIdx + i) % this.buffer.length];
            if (Objects.isNull(value)) continue;
            values.add(value);
        }
        return values;
    }
}

