/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import io.confluent.kafka.replication.push.metrics.HdrHistogram;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaugeHdrHistogram {
    private final Class<?> klass;
    private final String metricName;
    private final GeneralSBCMetricsRegistry metricsRegistry;
    private final long highestTrackableValue;
    private final HdrHistogram histogram;
    private final Map<Percentile, AtomicInteger> percentiles;
    private static final Logger LOG = LoggerFactory.getLogger(GaugeHdrHistogram.class);

    public GaugeHdrHistogram(Class<?> klass, String metricName, long maxSnapshotAgeMs, long highestTrackableValue, int numberOfSignificantValueDigits, GeneralSBCMetricsRegistry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
        this.highestTrackableValue = highestTrackableValue;
        this.histogram = new HdrHistogram(maxSnapshotAgeMs, HdrHistogram.ThreadSafetyMode.CONCURRENT_READS, highestTrackableValue, numberOfSignificantValueDigits);
        this.klass = klass;
        this.metricName = metricName;
        this.percentiles = new HashMap<Percentile, AtomicInteger>();
    }

    public void record(long durationInSeconds) {
        if (durationInSeconds < 0L) {
            LOG.warn("Negative duration recorded for {}: {}", (Object)this.metricName, (Object)durationInSeconds);
            return;
        }
        this.histogram.record(Math.min(this.highestTrackableValue, durationInSeconds));
    }

    public void update(long now) {
        if (this.percentiles.isEmpty()) {
            this.registerPercentiles();
        }
        for (Percentile p : this.percentiles.keySet()) {
            try {
                this.percentiles.get((Object)p).set((int)this.histogram.measurePercentile(now, p.percentile));
            }
            catch (Exception e) {
                LOG.warn("Failed to measure percentile {} for {}: {}", new Object[]{p.label, this.metricName, e.getMessage()});
            }
        }
    }

    public Map<Percentile, AtomicInteger> percentiles() {
        return this.percentiles;
    }

    private void registerPercentiles() {
        for (Percentile p : Percentile.values()) {
            AtomicInteger percentileValue = new AtomicInteger(0);
            this.percentiles.put(p, percentileValue);
            this.metricsRegistry.newGauge(this.klass, this.metricName + "-" + p.label, percentileValue::get);
        }
    }

    public static enum Percentile {
        P50("p50", 50.0),
        P90("p90", 90.0),
        P99("p99", 99.0);

        public final String label;
        public final double percentile;

        private Percentile(String label, double percentile) {
            this.label = label;
            this.percentile = percentile;
        }
    }
}

