/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.common;

import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RetryUtils.class);

    public static <T> T executeWithRetry(Callable<T> action, Predicate<Exception> shouldRetry, int maxAttempts, long backoffMs) throws Exception {
        if (action == null || shouldRetry == null) {
            throw new IllegalArgumentException("Action and shouldRetry must not be null");
        }
        if (maxAttempts <= 0) {
            throw new IllegalArgumentException("maxAttempts must be at least 1");
        }
        int attempt = 0;
        while (true) {
            try {
                return action.call();
            }
            catch (Exception e) {
                LOG.error("Attempt {} failed with exception: {}", (Object)(++attempt), (Object)e.getMessage());
                if (attempt >= maxAttempts || !shouldRetry.test(e)) {
                    LOG.error("Reached maximum attempts ({}) or encountered a non-retryable exception. Giving up.", (Object)maxAttempts);
                    throw e;
                }
                try {
                    Thread.sleep(backoffMs);
                }
                catch (InterruptedException ie) {
                    LOG.error("Interrupted while waiting for retry", (Throwable)ie);
                    throw ie;
                }
            }
        }
    }
}

