/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.cruisecontrol.common.CruiseControlConfigurable;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import com.linkedin.kafka.cruisecontrol.config.ClusterBrokerCapacityConfigResolver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface BrokerCapacityConfigResolver
extends CruiseControlConfigurable,
ClusterBrokerCapacityConfigResolver {
    public BrokerCapacityInfo capacityForBroker(String var1, String var2, int var3);

    default public void updateDiskCapacityForBroker(String rack, String host, int brokerId, double diskCapacity) {
    }

    @Override
    default public void mergeCapacitiesForBrokers(Map<ClusterBrokerCapacityConfigResolver.Broker, Map<Resource, Double>> brokerCapacities) {
        for (Map.Entry<ClusterBrokerCapacityConfigResolver.Broker, Map<Resource, Double>> entry : brokerCapacities.entrySet()) {
            this.updateDiskCapacityForBroker(entry.getKey().rack(), entry.getKey().host(), entry.getKey().brokerId(), brokerCapacities.get(entry.getKey()).get((Object)Resource.DISK));
        }
    }

    @Override
    default public Map<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> capacitiesForBrokers(List<ClusterBrokerCapacityConfigResolver.Broker> brokers) {
        HashMap<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> result = new HashMap<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo>(brokers.size());
        brokers.forEach(broker -> result.put((ClusterBrokerCapacityConfigResolver.Broker)broker, this.capacityForBroker(broker.rack(), broker.host(), broker.brokerId())));
        return result;
    }
}

