/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.config;

import com.linkedin.kafka.cruisecontrol.analyzer.goals.Goal;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class GoalsConfig {
    private final ModelCompletenessRequirements requirements;
    private final List<Goal> goals;
    private final boolean executeOptimizationsOverHardProposals;

    public GoalsConfig(List<Goal> goals) {
        this(goals, true);
    }

    public GoalsConfig(List<Goal> goals, boolean executeOptimizationsOverHardProposals) {
        this.requirements = GoalsConfig.combineLoadRequirementOptions(goals);
        this.goals = Collections.unmodifiableList(goals);
        this.executeOptimizationsOverHardProposals = executeOptimizationsOverHardProposals;
    }

    public boolean executeOptimizationsOverHardProposals() {
        return this.executeOptimizationsOverHardProposals;
    }

    public ModelCompletenessRequirements requirements() {
        return this.requirements;
    }

    public List<Goal> goals() {
        return this.goals;
    }

    private static ModelCompletenessRequirements combineLoadRequirementOptions(Collection<Goal> goals) {
        ModelCompletenessRequirements requirements = null;
        for (Goal goal : goals) {
            requirements = goal.clusterModelCompletenessRequirements().stronger(requirements);
        }
        return requirements;
    }

    public String toString() {
        return "GoalsConfig{requirements=" + String.valueOf(this.requirements) + ", goals=" + String.valueOf(this.goals) + "}";
    }
}

