/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.Anomaly;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControl;
import com.linkedin.kafka.cruisecontrol.detector.BrokerFailures;
import com.linkedin.kafka.cruisecontrol.detector.CellOverload;
import com.linkedin.kafka.cruisecontrol.detector.GoalViolations;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnomalyDetectorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AnomalyDetectorUtils.class);
    public static final int MAX_METADATA_WAIT_MS = 60000;

    private AnomalyDetectorUtils() {
    }

    static AnomalyType getAnomalyType(Anomaly anomaly) {
        if (anomaly instanceof GoalViolations) {
            return AnomalyType.GOAL_VIOLATION;
        }
        if (anomaly instanceof BrokerFailures) {
            return AnomalyType.BROKER_FAILURE;
        }
        if (anomaly instanceof CellOverload) {
            return AnomalyType.CELL_OVERLOAD;
        }
        throw new IllegalStateException("Unrecognized type for anomaly " + String.valueOf(anomaly));
    }

    public static boolean shouldSkipAnomalyDetection(KafkaCruiseControl kafkaCruiseControl, AnomalyType anomalyType) {
        ExecutorState.State executionState = kafkaCruiseControl.executionState();
        if (executionState != ExecutorState.State.NO_TASK_IN_PROGRESS) {
            LOG.info("Skipping the detection of {} because the executor is in {} state.", (Object)anomalyType, (Object)executionState);
            return true;
        }
        if (kafkaCruiseControl.executorIsReserved()) {
            LOG.info("Skipping the detection of {} because the executor is reserved.", (Object)anomalyType);
            return true;
        }
        return false;
    }
}

