/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.cruisecontrol.detector.Anomaly;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class AnomalyState {
    private final Anomaly anomaly;
    private final long detectionMs;
    private long statusUpdateMs;
    private Status status;

    public AnomalyState(Anomaly anomaly) {
        this.anomaly = anomaly;
        this.statusUpdateMs = this.detectionMs = System.currentTimeMillis();
        this.status = Status.DETECTED;
    }

    public Status status() {
        return this.status;
    }

    public String anomalyId() {
        return this.anomaly.anomalyId();
    }

    public Anomaly anomaly() {
        return this.anomaly;
    }

    public long detectionMs() {
        return this.detectionMs;
    }

    public long statusUpdateMs() {
        return this.statusUpdateMs;
    }

    public void setStatus(Status status) {
        this.status = status;
        this.statusUpdateMs = System.currentTimeMillis();
    }

    public static enum Status {
        DETECTED,
        IGNORED,
        ATTEMPTING_FIX,
        FIX_STARTED,
        FIX_FAILED_TO_START,
        CHECK_WITH_DELAY,
        LOAD_MONITOR_NOT_READY,
        COMPLETENESS_NOT_READY;

        private static final List<Status> CACHED_VALUES;

        public static List<Status> cachedValues() {
            return CACHED_VALUES;
        }

        static {
            CACHED_VALUES = Collections.unmodifiableList(Arrays.asList(Status.values()));
        }
    }
}

