/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilisationDetectorType;
import com.linkedin.kafka.cruisecontrol.detector.ResourceUtilizationDetector;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.ResourceDetectorSharedState;
import com.linkedin.kafka.cruisecontrol.monitor.ModelCompletenessRequirements;
import io.confluent.databalancer.metrics.CommonMetrics;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtilizationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtilizationHandler.class);
    private final Map<ResourceUtilisationDetectorType, ResourceUtilizationDetector> detectors;
    private final ModelCompletenessRequirements modelCompletenessRequirements;
    ResourceDetectorSharedState detectorSharedState;

    public ResourceUtilizationHandler(KafkaCruiseControlConfig kccConfig, Map<ResourceUtilisationDetectorType, ResourceUtilizationDetector> detectors) {
        double minMonitoredPartitionPercentage = kccConfig.getDouble("min.valid.partition.ratio");
        this.modelCompletenessRequirements = new ModelCompletenessRequirements(1, minMonitoredPartitionPercentage, true);
        this.detectors = detectors;
        this.detectorSharedState = new ResourceDetectorSharedState();
    }

    public ModelCompletenessRequirements requirements() {
        return this.modelCompletenessRequirements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean detect(ClusterModel clusterModel) {
        boolean stateChanged = false;
        try {
            LOG.info("Running resource utilization detector.");
            this.detectors.values().forEach(detector -> detector.detectResourceUtilization(clusterModel, this.detectorSharedState));
        }
        catch (Exception e) {
            LOG.error("Resetting all resource detectors because of an unexpected exception", (Throwable)e);
            CommonMetrics.recordFatalError(ResourceUtilizationHandler.class);
        }
        finally {
            stateChanged = this.detectorSharedState.stateChanged();
            this.detectorSharedState.clearState();
            LOG.info("Resource utilization detection finished.");
        }
        return stateChanged;
    }

    public void close() {
        this.detectors.values().forEach(detector -> KafkaCruiseControlUtils.executeSilently(detector, ResourceUtilizationDetector::close, () -> String.format("Failed to shutdown %s during the shutdown of ResourceUtilizationHandler.", detector.name())));
    }

    public void updateTenantsBeingReassigned(Set<String> activeTenantReassignments) {
        this.detectors.get((Object)ResourceUtilisationDetectorType.TENANT_AUTO_SCALER).updateTenantReassignmentState(activeTenantReassignments);
    }
}

