/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.notifier;

public class AnomalyNotificationResult {
    private final Action action;
    private final long delay;

    public static AnomalyNotificationResult ignore() {
        return new AnomalyNotificationResult(Action.IGNORE, -1L);
    }

    public static AnomalyNotificationResult fix() {
        return new AnomalyNotificationResult(Action.FIX, -1L);
    }

    public static AnomalyNotificationResult check(long delay) {
        return new AnomalyNotificationResult(Action.CHECK, delay);
    }

    private AnomalyNotificationResult(Action action, long delay) {
        if (action == Action.IGNORE && delay > 0L) {
            throw new IllegalArgumentException("The ignore action should not have a delay.");
        }
        this.action = action;
        this.delay = delay;
    }

    public Action action() {
        return this.action;
    }

    public long delay() {
        return this.delay;
    }

    public String toString() {
        return "{" + String.valueOf((Object)this.action) + "," + this.delay + "}";
    }

    public static enum Action {
        IGNORE,
        FIX,
        CHECK;

    }
}

