/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.tenantstriping;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.TenantResource;
import com.linkedin.kafka.cruisecontrol.model.TenantResourceUsageMappings;
import java.util.Locale;
import java.util.Map;

public class DesiredStripeFactorCalculator {
    private final TenantResourceUsageMappings desiredStripeUsage = new TenantResourceUsageMappings();

    DesiredStripeFactorCalculator(KafkaCruiseControlConfig kccConfig) {
        for (TenantResource tenantResource : TenantResource.cachedValues()) {
            Double desiredStripeUsageValue = kccConfig.getDouble("tenant.striping.desired.stripe.usage." + tenantResource.name().toLowerCase(Locale.ROOT));
            this.desiredStripeUsage.addResourceMapping(tenantResource, desiredStripeUsageValue);
        }
    }

    public Double desiredStripeUsage(TenantResource resource) {
        return this.desiredStripeUsage.resourceValue(resource);
    }

    int calculateMaxDesiredStripeFactor(TenantResourceUsageMappings resourceUsages, StringBuilder tenantStripeSummary) {
        int maxDesiredStripeFactor = 0;
        for (Map.Entry<TenantResource, Double> mapping : resourceUsages.resourceEntries()) {
            int resourceStripeFactor = (int)Math.ceil(mapping.getValue() / this.desiredStripeUsage.resourceValue(mapping.getKey()));
            maxDesiredStripeFactor = Math.max(maxDesiredStripeFactor, resourceStripeFactor);
            tenantStripeSummary.append((Object)mapping.getKey()).append(" =>  desiredStripeFactor: ").append(resourceStripeFactor).append(", ");
        }
        tenantStripeSummary.append("\n");
        return maxDesiredStripeFactor;
    }
}

