/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.tenantstriping;

import com.linkedin.kafka.cruisecontrol.analyzer.AnalyzerUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.tenantstriping.DesiredStripeFactorCalculator;
import com.linkedin.kafka.cruisecontrol.detector.tenantstriping.TenantUsageTracker;
import com.linkedin.kafka.cruisecontrol.model.TenantResource;
import com.linkedin.kafka.cruisecontrol.model.TenantResourceUsage;
import com.linkedin.kafka.cruisecontrol.model.TenantResourceUsageMappings;
import com.linkedin.kafka.cruisecontrol.model.TenantStripingInfo;
import com.linkedin.kafka.cruisecontrol.model.view.ClusterModelCellView;
import io.confluent.databalancer.metrics.TenantStripingMetrics;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TenantOverloadDetector {
    private static final Logger LOG = LoggerFactory.getLogger(TenantOverloadDetector.class);
    private final TenantUsageTracker tenantUsageTracker;
    private final Map<String, TenantResourceUsageMappings> tenantsToStripeUp;
    private final Time time;
    private final DesiredStripeFactorCalculator desiredStripeFactorCalculator;
    private final TenantStripingMetrics tenantStripingMetrics;

    public TenantOverloadDetector(KafkaCruiseControlConfig kccConfig, Time time, DesiredStripeFactorCalculator desiredStripeFactorCalculator, TenantStripingMetrics tenantStripingMetrics) {
        this.time = time;
        this.tenantUsageTracker = new TenantUsageTracker(kccConfig, time, tenantStripingMetrics);
        this.tenantsToStripeUp = new HashMap<String, TenantResourceUsageMappings>();
        this.desiredStripeFactorCalculator = desiredStripeFactorCalculator;
        this.tenantStripingMetrics = tenantStripingMetrics;
    }

    public Map<String, TenantResourceUsageMappings> getTenantsToStripeUp(ClusterModelCellView cellView, Map<String, TenantStripingInfo> stripingInfoMap, Set<String> excludedTenantIds) {
        excludedTenantIds.forEach(this::removeFromCandidates);
        cellView.tenantsById().values().forEach(tenant -> {
            if (excludedTenantIds.contains(tenant.tenantId())) {
                LOG.debug("Skipping tenant {} as it is excluded from striping", (Object)tenant.tenantId());
                return;
            }
            for (TenantResource tenantResource : TenantResource.cachedValues()) {
                Double resourceUsage = tenant.getResourceUsage(tenantResource.resource());
                if (!this.isResourceUsageAboveThreshold(resourceUsage, ((TenantStripingInfo)stripingInfoMap.get(tenant.tenantId())).stripeCount(), tenantResource)) continue;
                this.tenantUsageTracker.record(tenant.tenantId(), tenantResource, this.time.milliseconds(), resourceUsage);
                if (!this.tenantUsageTracker.hasTenantSpikedConsistently(tenant.tenantId(), tenantResource)) continue;
                this.maybeAddUsage(this.tenantUsageTracker.calculateAverageResourceUsage(tenant.tenantId(), tenantResource), this.tenantUsageTracker.getTenantSpikeDetectionTimeSec(tenant.tenantId(), tenantResource));
            }
        });
        return this.tenantsToStripeUp;
    }

    boolean isResourceUsageAboveThreshold(Double resourceUsage, Integer stripeCount, TenantResource tenantResource) {
        Double desiredStripeUsage = this.desiredStripeFactorCalculator.desiredStripeUsage(tenantResource);
        return AnalyzerUtils.isSmaller((double)stripeCount.intValue() * desiredStripeUsage, resourceUsage);
    }

    void maybeAddUsage(TenantResourceUsage usage, long spikeDetectionTimeSec) {
        TenantResourceUsageMappings resourceUsageMap = this.tenantsToStripeUp.get(usage.tenantId());
        if (resourceUsageMap == null) {
            this.addUsage(usage, spikeDetectionTimeSec);
        } else if (resourceUsageMap.containsResource(usage.tenantResource())) {
            Double existingAvg = resourceUsageMap.resourceValue(usage.tenantResource());
            if (AnalyzerUtils.isSmaller(existingAvg, usage.value())) {
                resourceUsageMap.addResourceMapping(usage.tenantResource(), usage.value());
            }
        } else {
            resourceUsageMap.addResourceMapping(usage.tenantResource(), usage.value());
        }
    }

    private void addUsage(TenantResourceUsage usage, long spikeDetectionTimeSec) {
        TenantResourceUsageMappings resourceMap = new TenantResourceUsageMappings();
        resourceMap.addResourceMapping(usage.tenantResource(), usage.value());
        this.tenantsToStripeUp.put(usage.tenantId(), resourceMap);
        this.tenantStripingMetrics.recordTenantLoadSpikeDetectionTime(usage.tenantId(), spikeDetectionTimeSec);
        this.tenantStripingMetrics.recordTenantPending(usage.tenantId());
    }

    void removeFromCandidates(String tenantId) {
        this.tenantsToStripeUp.remove(tenantId);
        this.tenantStripingMetrics.clearTenantPending(tenantId);
        this.tenantStripingMetrics.clearTenantMetadataUpdateFailure(tenantId);
        this.tenantStripingMetrics.clearInsufficientCellsAvailableMetric(tenantId);
        this.tenantStripingMetrics.clearTenantLoadSpikeDetectionTime(tenantId);
    }

    void close() {
        this.tenantsToStripeUp.clear();
        this.tenantUsageTracker.close();
    }
}

