/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.tenantstriping;

import com.linkedin.cruisecontrol.metricdef.ValueComputingStrategy;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.model.TenantResource;
import com.linkedin.kafka.cruisecontrol.model.TenantResourceUsage;
import com.linkedin.kafka.cruisecontrol.model.UsageRecord;
import io.confluent.databalancer.metrics.TenantStripingMetrics;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Queue;
import org.apache.kafka.common.utils.Time;

public class TenantUsageTracker {
    private final EnumMap<TenantResource, Integer> counterThresholdByResource;
    private final Map<String, EnumMap<TenantResource, Queue<UsageRecord>>> spikedResourceUsages;
    private final long tenantResourceUsageExpiryMs;
    private final Time time;
    private final Map<String, Integer> tenantsSkippedByExpiry;
    private final int tenantsExpiryCounterThreshold;
    private final TenantStripingMetrics tenantStripingMetrics;

    public TenantUsageTracker(KafkaCruiseControlConfig kccConfig, Time time, TenantStripingMetrics tenantStripingMetrics) {
        this.tenantResourceUsageExpiryMs = kccConfig.getInt("tenant.striping.resource.usage.expiry.ms").intValue();
        this.tenantsExpiryCounterThreshold = kccConfig.getInt("tenant.striping.expiry.counter.threshold");
        this.tenantStripingMetrics = tenantStripingMetrics;
        this.time = time;
        this.spikedResourceUsages = new HashMap<String, EnumMap<TenantResource, Queue<UsageRecord>>>();
        this.counterThresholdByResource = new EnumMap(TenantResource.class);
        this.tenantsSkippedByExpiry = new HashMap<String, Integer>();
        for (TenantResource tenantResource : TenantResource.cachedValues()) {
            String resourceName = tenantResource.name();
            String resourceThresholdConfig = "tenant.striping.counter.threshold." + resourceName.toLowerCase(Locale.ROOT);
            this.counterThresholdByResource.put(tenantResource, kccConfig.getInt(resourceThresholdConfig));
        }
    }

    private int getCounterThreshold(TenantResource resource) {
        return this.counterThresholdByResource.get((Object)resource);
    }

    public Optional<TenantResourceUsage> record(String tenantId, TenantResource resource, Long timestamp, Double value) {
        this.recordUsage(tenantId, resource, timestamp, value);
        this.expire(tenantId, resource);
        Queue<UsageRecord> usagesForTenantResource = this.spikedResourceUsages.get(tenantId).get((Object)resource);
        while (usagesForTenantResource.size() > this.getCounterThreshold(resource)) {
            usagesForTenantResource.remove();
        }
        if (usagesForTenantResource.size() == this.getCounterThreshold(resource)) {
            this.tenantStripingMetrics.clearTenantSkippedByExpiry(tenantId);
            return Optional.of(this.calculateAggregateResourceUsage(tenantId, resource));
        }
        return Optional.empty();
    }

    public boolean hasTenantSpikedConsistently(String tenantId, TenantResource resource) {
        return this.spikedResourceUsages.get(tenantId).get((Object)resource).size() == this.getCounterThreshold(resource);
    }

    public long getTenantSpikeDetectionTimeSec(String tenantId, TenantResource resource) {
        if (!this.spikedResourceUsages.containsKey(tenantId) || !this.spikedResourceUsages.get(tenantId).containsKey((Object)resource)) {
            throw new IllegalStateException("Tenant " + tenantId + " has no recorded spike usage for resource " + String.valueOf((Object)resource));
        }
        Long minTime = this.spikedResourceUsages.get(tenantId).get((Object)resource).peek().timestamp();
        Long maxTime = this.spikedResourceUsages.get(tenantId).get((Object)resource).peek().timestamp();
        for (UsageRecord usageRecord : this.spikedResourceUsages.get(tenantId).get((Object)resource)) {
            minTime = Math.min(minTime, usageRecord.timestamp());
            maxTime = Math.max(maxTime, usageRecord.timestamp());
        }
        return (maxTime - minTime) / 1000L;
    }

    private void recordUsage(String tenantId, TenantResource resource, Long timestamp, Double value) {
        this.spikedResourceUsages.putIfAbsent(tenantId, new EnumMap(TenantResource.class));
        this.spikedResourceUsages.get(tenantId).putIfAbsent(resource, new PriorityQueue(1));
        this.spikedResourceUsages.get(tenantId).get((Object)resource).add(new UsageRecord(value, timestamp));
    }

    private void expire(String tenantId, TenantResource resource) {
        int spikedRecords = this.spikedResourceUsages.get(tenantId).get((Object)resource).size();
        long nowMs = this.time.milliseconds();
        this.spikedResourceUsages.get(tenantId).get((Object)resource).removeIf(usageRecord -> usageRecord.timestamp() < nowMs - this.getResourceBasedExpiry(resource));
        int spikedRecordsPostExpiry = this.spikedResourceUsages.get(tenantId).get((Object)resource).size();
        this.markConsistentlyExpiredTenants(tenantId, resource, spikedRecordsPostExpiry, spikedRecords);
    }

    private void markConsistentlyExpiredTenants(String tenantId, TenantResource resource, int spikedRecordsPostExpiry, int spikedRecords) {
        if (spikedRecordsPostExpiry < spikedRecords && spikedRecords <= this.getCounterThreshold(resource)) {
            this.tenantsSkippedByExpiry.putIfAbsent(tenantId, 0);
            this.tenantsSkippedByExpiry.put(tenantId, this.tenantsSkippedByExpiry.get(tenantId) + 1);
            if (this.tenantsSkippedByExpiry.get(tenantId) >= this.tenantsExpiryCounterThreshold) {
                this.tenantStripingMetrics.recordTenantsSkippedByExpiry(tenantId);
            }
        }
    }

    private TenantResourceUsage calculateAggregateResourceUsage(String tenantId, TenantResource resource) {
        switch (this.getResourceComputationStrategy(resource)) {
            case AVG: {
                return this.calculateAverageResourceUsage(tenantId, resource);
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.getResourceComputationStrategy(resource)));
    }

    private ValueComputingStrategy getResourceComputationStrategy(TenantResource resource) {
        return ValueComputingStrategy.AVG;
    }

    private long getResourceBasedExpiry(TenantResource resource) {
        return this.tenantResourceUsageExpiryMs;
    }

    TenantResourceUsage calculateAverageResourceUsage(String tenantId, TenantResource resource) {
        double sum = this.spikedResourceUsages.get(tenantId).get((Object)resource).stream().mapToDouble(UsageRecord::usage).sum();
        double avg = sum / (double)this.spikedResourceUsages.get(tenantId).get((Object)resource).size();
        return new TenantResourceUsage(tenantId, resource, avg);
    }

    public void close() {
        this.spikedResourceUsages.clear();
    }
}

