/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.utils;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlContext;
import io.confluent.databalancer.metrics.CellOverloadMetrics;
import io.confluent.databalancer.record.CellOverloadOccurrenceDelta;
import io.confluent.databalancer.record.Cells;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;
import kafka.server.KafkaConfig;
import org.apache.kafka.common.config.AbstractConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CellOverloadOccurrence {
    private static final Logger LOG = LoggerFactory.getLogger(CellOverloadOccurrence.class);
    private static final String CELL_OVERLOAD_MAX_OCCURRENCE_METRIC_NAME = "cell-overload-max-occurrence";
    private static final String CELL_OVERLOAD_OCCURRENCE_METRIC_NAME = "cell-overload-occurrence";
    private final Map<Integer, Integer> cellOverloadOccurrences;
    private final long maxCellOverloadOccurrences;
    private final CellOverloadMetrics cellOverloadMetrics;
    private KafkaCruiseControlContext kafkaCruiseControlContext;

    public CellOverloadOccurrence(KafkaConfig config, CellOverloadMetrics cellOverloadMetrics) {
        this.maxCellOverloadOccurrences = this.maxCellOverloadOccurrences((AbstractConfig)config, "confluent.balancer.cell.overload.duration.ms", "confluent.balancer.cell.overload.detection.interval.ms");
        this.cellOverloadOccurrences = new ConcurrentHashMap<Integer, Integer>();
        this.cellOverloadMetrics = cellOverloadMetrics;
        this.cellOverloadMetrics.newGauge(CELL_OVERLOAD_MAX_OCCURRENCE_METRIC_NAME, this::dynamicallyComputedMaxCellOverloadOccurrences);
    }

    private long maxCellOverloadOccurrences(AbstractConfig config, String cellOverloadDurationMsConfig, String cellOverloadIntervalMsConfig) {
        long cellOverloadDurationMs = config.getLong(cellOverloadDurationMsConfig);
        long cellOverloadDetectionIntervalMs = config.getLong(cellOverloadIntervalMsConfig);
        if (cellOverloadDetectionIntervalMs == 0L) {
            LOG.warn("Cell overload detection interval is set to 0. Cell overload detection will be disabled.");
            return 1L;
        }
        return Math.max(1L, cellOverloadDurationMs / cellOverloadDetectionIntervalMs);
    }

    private long dynamicallyComputedMaxCellOverloadOccurrences() {
        if (this.kafkaCruiseControlContext != null) {
            return this.maxCellOverloadOccurrences(this.kafkaCruiseControlContext.config(), "cell.overload.duration.ms", "cell.overload.detection.interval.ms");
        }
        return this.maxCellOverloadOccurrences;
    }

    public boolean isOverloaded(int cellId) {
        return this.occurrences(cellId) >= this.dynamicallyComputedMaxCellOverloadOccurrences();
    }

    public void kafkaCruiseControlContext(KafkaCruiseControlContext kccContext) {
        this.kafkaCruiseControlContext = kccContext;
    }

    public long occurrences(int cellId) {
        return this.cellOverloadOccurrences.getOrDefault(cellId, 0).intValue();
    }

    public void replay(CellOverloadOccurrenceDelta.CellOverloadOccurrenceDeltaProto cellOverloadOccurrenceDelta) {
        int version = cellOverloadOccurrenceDelta.getVersion();
        if (version == 1) {
            CellOverloadOccurrenceDelta.Operation op = cellOverloadOccurrenceDelta.getOp();
            int cellId = cellOverloadOccurrenceDelta.getCellId();
            switch (op) {
                case record_once: {
                    this.recordOnce(cellId);
                    break;
                }
                case delete_once: {
                    this.deleteOnce(cellId);
                    break;
                }
                case clear: {
                    this.clear(cellId);
                }
            }
        } else {
            LOG.warn("Invalid version {} is found for the CellOverloadOccurrenceDelta, ignoring the record...", (Object)version);
        }
    }

    public void replay(Cells.CellsProto cells) {
        int version = cells.getVersion();
        if (version == 1) {
            this.clearDeletedCells(new HashSet<Integer>(cells.getCellIdList()));
        } else {
            LOG.warn("Invalid version {} is found for the Cells, ignoring the record...", (Object)version);
        }
    }

    void recordOnce(int cellId) {
        if (this.cellOverloadOccurrences.merge(cellId, 1, Integer::sum) == 1) {
            this.cellOverloadMetrics.newCellGauge(cellId, CELL_OVERLOAD_OCCURRENCE_METRIC_NAME, () -> this.cellOverloadOccurrences.getOrDefault(cellId, 0));
        }
    }

    void deleteOnce(int cellId) {
        this.cellOverloadOccurrences.compute(cellId, (id, occurrences) -> {
            if (occurrences == null) {
                return -1;
            }
            if (occurrences == 1) {
                return null;
            }
            return occurrences - 1;
        });
    }

    void clear(int cellId) {
        this.cellOverloadOccurrences.remove(cellId);
    }

    void clearDeletedCells(Set<Integer> cellIds) {
        Set cellIdsToRemove = this.cellOverloadOccurrences.keySet().stream().filter(cellId -> !cellIds.contains(cellId)).collect(Collectors.toSet());
        Iterator iterator = cellIdsToRemove.iterator();
        while (iterator.hasNext()) {
            int cellId2 = (Integer)iterator.next();
            this.clear(cellId2);
            this.cellOverloadMetrics.removeMetrics(cellId2);
        }
    }
}

