/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.detector.utils;

import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.view.ClusterModelCellView;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CellUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CellUtils.class);

    public static Optional<ClusterModelCellView> clusterModelCellView(ClusterModel clusterModel, String handlerName) {
        if (clusterModel.hasReassigningPartitions()) {
            LOG.debug("{} is skipping creating cluster model because there are ongoing partition reassignments.", (Object)handlerName);
            return Optional.empty();
        }
        if (clusterModel.replicasAreInExpectedCell()) {
            return Optional.of(new ClusterModelCellView(clusterModel));
        }
        LOG.warn("{} detected replicas of some tenants not in their designated cell and will skip creating cluster model.", (Object)handlerName);
        return Optional.empty();
    }
}

