/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.common.GaugeHdrHistogram;
import com.linkedin.kafka.cruisecontrol.executor.Executor;
import com.linkedin.kafka.cruisecontrol.executor.PartitionProposal;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ExecutionMetricsReporter {
    private static final String HISTOGRAM_PROPOSALS_PER_BROKER = "proposals-per-broker";
    private static final String HISTOGRAM_PROPOSAL_SIZE = "proposal-size-per-partition-mb";
    private static final String HISTOGRAM_PROPOSALS_SIZE_PER_BROKER = "proposals-size-per-broker-mb";
    private static final String HISTOGRAM_EXECUTION_TIME = "execution-time-ms";
    private static final String GAUGE_EXECUTION_STARTED = "execution-started";
    private static final String GAUGE_EXECUTION_STOPPED = "execution-stopped";
    private static final String GAUGE_CANCELLED_REASSIGNMENTS = "cancelled-reassignments";
    private static final String GAUGE_REPLICA_REASSIGNMENT = "replica-reassignment";
    private static final String GAUGE_FAILED_REASSIGNMENT_CANCELLATIONS = "failed-reassignment-cancellations";
    private static final String GAUGE_AVG_INTER_BROKER_REPLICA_REASSIGNMENTS_SPEED_PER_MINUTE = "avg-inter-broker-replica-reassignments-speed-per-minute";
    private final GeneralSBCMetricsRegistry metricRegistry;
    private final Map<SizeBucket, GaugeHdrHistogram> interBrokerReassignmentHistograms;
    private final Set<SizeBucket> bucketsToUpdate;

    public ExecutionMetricsReporter(GeneralSBCMetricsRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        this.interBrokerReassignmentHistograms = new HashMap<SizeBucket, GaugeHdrHistogram>();
        this.bucketsToUpdate = new HashSet<SizeBucket>();
    }

    public void reportExecutionTime(long timeMs) {
        this.metricRegistry.newHistogram(Executor.class, HISTOGRAM_EXECUTION_TIME).update(timeMs);
    }

    public void mayBeRegisterAndRecordReassignmentTime(long durationInSeconds, long partitionSizeInMB) {
        SizeBucket sizeBucket = SizeBucket.fromSizeMB(partitionSizeInMB);
        if (!this.interBrokerReassignmentHistograms.containsKey((Object)sizeBucket)) {
            this.interBrokerReassignmentHistograms.put(sizeBucket, new GaugeHdrHistogram(Executor.class, "replica-reassignment-" + sizeBucket.metricName(), TimeUnit.HOURS.toMillis(1L), TimeUnit.DAYS.toSeconds(1L), 2, this.metricRegistry));
        }
        GaugeHdrHistogram histogram = this.interBrokerReassignmentHistograms.get((Object)sizeBucket);
        histogram.record(durationInSeconds);
        this.bucketsToUpdate.add(sizeBucket);
    }

    public void updateReassignmentTimeMetrics(long nowInMs) {
        for (SizeBucket sizeBucket : this.bucketsToUpdate) {
            GaugeHdrHistogram histogram = this.interBrokerReassignmentHistograms.get((Object)sizeBucket);
            if (histogram == null) continue;
            histogram.update(nowInMs);
        }
        this.bucketsToUpdate.clear();
    }

    public Map<SizeBucket, GaugeHdrHistogram> interBrokerReassignmentHistograms() {
        return this.interBrokerReassignmentHistograms;
    }

    public void registerExecutionStartedGauge(Supplier<Integer> startedExecutions) {
        this.metricRegistry.newGauge(Executor.class, GAUGE_EXECUTION_STARTED, startedExecutions);
    }

    public void registerExecutionStoppedGauge(Supplier<Integer> stoppedExecutions) {
        this.metricRegistry.newGauge(Executor.class, GAUGE_EXECUTION_STOPPED, stoppedExecutions);
    }

    public void registerCancelledReassignmentsGauge(Supplier<Integer> cancelledExecutions) {
        this.metricRegistry.newGauge(Executor.class, GAUGE_CANCELLED_REASSIGNMENTS, cancelledExecutions);
    }

    public void registerFailedReassignmentCancellationsGauge(Supplier<Integer> failedReassignmentCancellations) {
        this.metricRegistry.newGauge(Executor.class, GAUGE_FAILED_REASSIGNMENT_CANCELLATIONS, failedReassignmentCancellations);
    }

    public void registerAvgReplicaReassignmentSpeedPerMinute(Supplier<Integer> reassignmentSpeedPerMin) {
        this.metricRegistry.newGauge(Executor.class, GAUGE_AVG_INTER_BROKER_REPLICA_REASSIGNMENTS_SPEED_PER_MINUTE, reassignmentSpeedPerMin);
    }

    public void reportProposals(Collection<PartitionProposal> proposals) {
        Map<Integer, List<PartitionProposal>> perBrokerProposals = this.perBrokerProposals(proposals);
        this.reportPerBrokerProposalsMetrics(perBrokerProposals);
        this.reportProposalsDataMovement(proposals);
    }

    private void reportPerBrokerProposalsMetrics(Map<Integer, List<PartitionProposal>> perBrokerProposals) {
        perBrokerProposals.forEach((key, value) -> {
            this.metricRegistry.newHistogram(Executor.class, HISTOGRAM_PROPOSALS_PER_BROKER).update(value.size());
            long proposalsSize = value.stream().mapToLong(PartitionProposal::dataToMoveInMB).sum();
            this.metricRegistry.newHistogram(Executor.class, HISTOGRAM_PROPOSALS_SIZE_PER_BROKER).update(proposalsSize);
        });
    }

    private void reportProposalsDataMovement(Collection<PartitionProposal> proposals) {
        for (PartitionProposal proposal : proposals) {
            if (Objects.equals(proposal.newLeader().brokerId(), proposal.oldLeader().brokerId())) continue;
            this.metricRegistry.newHistogram(Executor.class, HISTOGRAM_PROPOSAL_SIZE).update(proposal.dataToMoveInMB());
        }
    }

    private Map<Integer, List<PartitionProposal>> perBrokerProposals(Collection<PartitionProposal> proposals) {
        HashMap<Integer, List<PartitionProposal>> proposalsPerBroker = new HashMap<Integer, List<PartitionProposal>>();
        for (PartitionProposal proposal : proposals) {
            if (proposal.dataToMoveInMB() <= 0L) continue;
            List outboundPartitionProposals = proposalsPerBroker.computeIfAbsent(proposal.oldLeader().brokerId(), x -> new ArrayList());
            outboundPartitionProposals.add(proposal);
            List inboundPartitionProposals = proposalsPerBroker.computeIfAbsent(proposal.newLeader().brokerId(), x -> new ArrayList());
            inboundPartitionProposals.add(proposal);
        }
        return proposalsPerBroker;
    }

    public static enum SizeBucket {
        SIZE_0_1MB("0-1mb"),
        SIZE_1_10MB("1-10mb"),
        SIZE_10_100MB("10-100mb"),
        SIZE_100_1000MB("100-1000mb"),
        SIZE_OVER_1000MB("over-1000mb");

        private final String metricName;

        private SizeBucket(String metricName) {
            this.metricName = metricName;
        }

        public String metricName() {
            return this.metricName;
        }

        public static SizeBucket fromSizeMB(long sizeMB) {
            if (sizeMB <= 1L) {
                return SIZE_0_1MB;
            }
            if (sizeMB <= 10L) {
                return SIZE_1_10MB;
            }
            if (sizeMB <= 100L) {
                return SIZE_10_100MB;
            }
            if (sizeMB <= 1000L) {
                return SIZE_100_1000MB;
            }
            return SIZE_OVER_1000MB;
        }
    }
}

