/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskGenerationIdUtils;
import com.linkedin.kafka.cruisecontrol.executor.PartitionProposal;
import com.linkedin.kafka.cruisecontrol.executor.TenantProposal;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

class ExecutionTaskGenerator {
    private final ExecutionTaskGenerationIdUtils generatorUtils = new ExecutionTaskGenerationIdUtils();

    public ExecutionTaskGenerator(KafkaCruiseControlConfig config) {
    }

    public Set<ExecutionTask> generateInterBrokerReplicaMovementTasks(Collection<PartitionProposal> proposals, Cluster cluster) {
        Predicate<PartitionProposal> shouldCreateInterBrokerTask = proposal -> {
            TopicPartition tp = proposal.topicPartition();
            PartitionInfo partitionInfo = cluster.partition(tp);
            return partitionInfo != null && !proposal.isInterBrokerMovementCompleted(partitionInfo.replicas(), partitionInfo.observers());
        };
        Function<PartitionProposal, ExecutionTask> generateInterBrokerTask = proposal -> ExecutionTask.interBrokerReplicaAction(this.generatorUtils.allocateExecutionId(), proposal);
        return proposals.stream().filter(shouldCreateInterBrokerTask).map(generateInterBrokerTask).collect(Collectors.toSet());
    }

    public Set<ExecutionTask> generateLeaderChangeTasks(Collection<PartitionProposal> proposals, Cluster cluster) {
        Predicate<PartitionProposal> proposalChangesCurrentLeaderPredicate = proposal -> {
            Node currentLeader = cluster.leaderFor(proposal.topicPartition());
            return currentLeader != null && currentLeader.id() != proposal.newLeader().brokerId().intValue();
        };
        Function<PartitionProposal, ExecutionTask> generateLeaderTask = proposal -> ExecutionTask.leaderAction(this.generatorUtils.allocateExecutionId(), proposal);
        return proposals.stream().filter(PartitionProposal::hasLeaderAction).filter(proposalChangesCurrentLeaderPredicate).map(generateLeaderTask).collect(Collectors.toSet());
    }

    public Set<ExecutionTask> generateTenantTasks(Collection<TenantProposal> proposals) {
        Function<TenantProposal, ExecutionTask> generateTenantTask = proposal -> ExecutionTask.tenantAction(this.generatorUtils.allocateExecutionId(), proposal);
        return proposals.stream().map(generateTenantTask).collect(Collectors.toSet());
    }
}

