/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.executor;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.analyzer.ActionType;
import com.linkedin.kafka.cruisecontrol.analyzer.TopicPartitionMovement;
import com.linkedin.kafka.cruisecontrol.analyzer.TopicPartitionMovementTracker;
import com.linkedin.kafka.cruisecontrol.common.KafkaCruiseControlThreadFactory;
import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.common.NumberCircularBuffer;
import com.linkedin.kafka.cruisecontrol.common.RetryUtils;
import com.linkedin.kafka.cruisecontrol.common.SbkAdminUtils;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.detector.AnomalyDetector;
import com.linkedin.kafka.cruisecontrol.detector.notifier.AnomalyType;
import com.linkedin.kafka.cruisecontrol.executor.AbstractExecutorReplicaMovement;
import com.linkedin.kafka.cruisecontrol.executor.DeadExecutionTaskException;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionMetricsReporter;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTask;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskManager;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTaskTracker;
import com.linkedin.kafka.cruisecontrol.executor.ExecutionTracker;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorInsightsChecker;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorInterBrokerReplicaMovement;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorLeadershipReplicaMovement;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorMetricsHandle;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorNotification;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorNotifier;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorReservationHandle;
import com.linkedin.kafka.cruisecontrol.executor.ExecutorState;
import com.linkedin.kafka.cruisecontrol.executor.PartitionProposal;
import com.linkedin.kafka.cruisecontrol.executor.ReplicationThrottleHelper;
import com.linkedin.kafka.cruisecontrol.monitor.SamplerStateHandle;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import io.confluent.databalancer.operation.BalanceOpExecutionCompletionCallback;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Executor
implements ExecutorInsightsChecker {
    private static final Logger LOG = LoggerFactory.getLogger(Executor.class);
    private static final long EXECUTION_HISTORY_SCANNER_PERIOD_SECONDS = 5L;
    private static final long EXECUTION_HISTORY_SCANNER_INITIAL_DELAY_SECONDS = 0L;
    private static final int REPLICA_REASSIGNMENT_EXECUTION_TIMES_CAPACITY = 10;
    private static final int REPLICA_REASSIGNMENT_DEFAULT_REASSIGNMENTS_PER_MIN = 50;
    private final ExecutionTaskManager executionTaskManager;
    private final MetadataClient metadataClient;
    private final long statusCheckingIntervalMs;
    private final long invalidReplicaAssignmentRetryMs;
    private final Duration executorRefreshTime;
    private final ExecutorService proposalExecutor;
    private final ConfluentAdmin adminClient;
    private final SbkAdminUtils adminUtils;
    private final ExecutionTracker executionTracker;
    private final AtomicBoolean stopRequested;
    private final Time time;
    private final TopicPartitionMovementTracker movementsTracker;
    private volatile boolean hasOngoingExecution;
    private final ExecutorReservation reservation = new ExecutorReservation();
    private volatile ExecutorState executorState;
    private volatile String uuid;
    private volatile MetadataClient.ClusterAndGeneration clusterMetadataAtProposalInitialization;
    private final ExecutorNotifier executorNotifier;
    private final AtomicInteger numExecutionsStarted;
    private final AtomicInteger numExecutionStopped;
    private final AtomicBoolean executionStoppedByUser;
    private final AtomicBoolean executionStopShouldInvalidateMetrics;
    private final AtomicInteger numCancelledReassignments;
    private final AtomicInteger numFailedReassignmentCancellations;
    private final AtomicInteger avgReplicaReassignmentSpeedPerMinute;
    private final ExecutionMetricsReporter executionMetricsReporter;
    private final long removalHistoryRetentionTimeMs;
    private final ConcurrentMap<Integer, Long> latestRemoveStartTimeMsByBrokerId;
    private final ScheduledExecutorService executionHistoryScannerExecutor;
    private final NumberCircularBuffer<Integer> replicaReassignmentExecutionTimes;
    private final AnomalyDetector anomalyDetector;
    private final ReplicationThrottleHelper throttleHelper;
    private final boolean isV2ExecutorEnabled;
    private final int maxAttempts;
    private final long retryDelayMs;

    public Executor(TopicPartitionMovementTracker movementTracker, KafkaCruiseControlConfig config, Time time, GeneralSBCMetricsRegistry metricRegistry, MetadataClient metadataClient, long removalHistoryRetentionTimeMs, long deadTaskCheckTimeoutMs, ExecutorNotifier executorNotifier, AnomalyDetector anomalyDetector, ConfluentAdmin adminClient, ReplicationThrottleHelper throttleHelper) throws ExecutionException, InterruptedException {
        this(movementTracker, config, time, metricRegistry, metadataClient, removalHistoryRetentionTimeMs, deadTaskCheckTimeoutMs, executorNotifier, anomalyDetector, adminClient, throttleHelper, null);
    }

    Executor(TopicPartitionMovementTracker movementTracker, KafkaCruiseControlConfig config, Time time, GeneralSBCMetricsRegistry metricRegistry, MetadataClient metadataClient, long removalHistoryRetentionTimeMs, long deadTaskCheckTimeoutMs, ExecutorNotifier executorNotifier, AnomalyDetector anomalyDetector, ConfluentAdmin adminClient, ReplicationThrottleHelper throttleHelper, ExecutorService proposalExecutorService) throws ExecutionException, InterruptedException {
        this.movementsTracker = movementTracker;
        this.numExecutionStopped = new AtomicInteger(0);
        this.numExecutionsStarted = new AtomicInteger(0);
        this.executionStoppedByUser = new AtomicBoolean(false);
        this.executionStopShouldInvalidateMetrics = new AtomicBoolean(true);
        this.numCancelledReassignments = new AtomicInteger(0);
        this.numFailedReassignmentCancellations = new AtomicInteger(0);
        this.avgReplicaReassignmentSpeedPerMinute = new AtomicInteger(50);
        this.time = time;
        this.metadataClient = Objects.requireNonNull(metadataClient, "The provided MetadataClient was null");
        this.executorNotifier = executorNotifier != null ? executorNotifier : config.getConfiguredInstance("executor.notifier.class", ExecutorNotifier.class);
        this.adminClient = adminClient;
        this.throttleHelper = throttleHelper != null ? throttleHelper : new ReplicationThrottleHelper((Admin)adminClient, config, time);
        this.statusCheckingIntervalMs = config.getLong("execution.progress.check.interval.ms");
        this.invalidReplicaAssignmentRetryMs = config.getLong("invalid.replica.assignment.retry.timeout.ms");
        this.executorRefreshTime = Duration.ofMillis(config.getLong("executor.reservation.refresh.time.ms"));
        this.proposalExecutor = proposalExecutorService != null ? proposalExecutorService : Executors.newSingleThreadExecutor(new KafkaCruiseControlThreadFactory("ProposalExecutor", false, LOG));
        this.latestRemoveStartTimeMsByBrokerId = new ConcurrentHashMap<Integer, Long>();
        this.stopRequested = new AtomicBoolean(false);
        this.hasOngoingExecution = false;
        this.uuid = null;
        this.anomalyDetector = anomalyDetector;
        this.removalHistoryRetentionTimeMs = removalHistoryRetentionTimeMs;
        this.executionMetricsReporter = new ExecutionMetricsReporter(metricRegistry);
        this.isV2ExecutorEnabled = config.getBoolean("v2.executor.enabled");
        this.adminUtils = new SbkAdminUtils(adminClient, config);
        this.executionTaskManager = new ExecutionTaskManager(config.getInt("num.concurrent.partition.movements.per.broker"), config.getInt("num.concurrent.leader.movements"), config.getList("default.replica.movement.strategies"), metricRegistry, time, config);
        this.executorState = ExecutorState.noTaskInProgress(new HashSet<Integer>());
        this.executionHistoryScannerExecutor = Executors.newSingleThreadScheduledExecutor(new KafkaCruiseControlThreadFactory("ExecutionHistoryScanner", true, null));
        this.executionHistoryScannerExecutor.scheduleAtFixedRate(new ExecutionHistoryScanner(), 0L, 5L, TimeUnit.SECONDS);
        this.replicaReassignmentExecutionTimes = new NumberCircularBuffer(10);
        long leaderActionTimeoutMs = config.getLong("executor.leader.action.timeout.ms");
        this.executionTracker = new ExecutionTracker(this.executionTaskManager, metadataClient, this.stopRequested, time, leaderActionTimeoutMs, deadTaskCheckTimeoutMs, this.statusCheckingIntervalMs, this.adminUtils, this.isV2ExecutorEnabled);
        this.executionMetricsReporter.registerExecutionStartedGauge(this::numExecutionsStarted);
        this.executionMetricsReporter.registerExecutionStoppedGauge(this::numExecutionStopped);
        this.executionMetricsReporter.registerCancelledReassignmentsGauge(this::numCancelledReassignments);
        this.executionMetricsReporter.registerFailedReassignmentCancellationsGauge(this::numFailedReassignmentCancellations);
        this.executionMetricsReporter.registerAvgReplicaReassignmentSpeedPerMinute(this::avgReplicaReassignmentSpeedPerMinute);
        this.maxAttempts = config.getInt("broker.removal.subtasks.max.attempts");
        this.retryDelayMs = config.getLong("broker.removal.subtasks.retry.interval.ms");
    }

    List<ExecutionTask> deadExecutionTasks() {
        return this.executionTaskManager.deadExecutionTasks();
    }

    public void startUp() throws ExecutionException, InterruptedException {
        if (!((Map)this.adminClient.listPartitionReassignments().reassignments().get()).isEmpty()) {
            this.hasOngoingExecution = true;
            LOG.info("Detected ongoing reassignment while starting up. Monitoring it to remove throttles once it completes.");
            Thread thread = new Thread(() -> {
                while (true) {
                    try {
                        while (!((Map)this.adminClient.listPartitionReassignments().reassignments().get()).isEmpty()) {
                            LOG.debug("Sleeping {} ms while waiting for ongoing reassignment to complete", (Object)this.statusCheckingIntervalMs);
                            Thread.sleep(this.statusCheckingIntervalMs);
                        }
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        continue;
                    }
                    break;
                }
                this.removeThrottles();
                LOG.info("Ongoing reassignment that was detected while starting up has finished.");
                this.hasOngoingExecution = false;
            });
            thread.start();
        } else {
            this.removeThrottles();
        }
    }

    public ExecutorReservationHandle reserveAndAbortOngoingExecutions(Duration executionAbortTimeout, String reason) throws TimeoutException {
        return this.reserveAndAbortOngoingExecutions(executionAbortTimeout, true, reason);
    }

    public ExecutorReservationHandle reserveAndAbortOngoingExecutions(Duration executionAbortTimeout, boolean shouldInvalidateMetrics, String reason) throws TimeoutException {
        try {
            return RetryUtils.executeWithRetry(() -> ExecutorReservationHandle.reserveAndAbortOngoingExecutions(this, this.time, executionAbortTimeout, this.executorRefreshTime, shouldInvalidateMetrics, reason), ex -> ex instanceof TimeoutException, this.maxAttempts, this.retryDelayMs);
        }
        catch (TimeoutException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Unexpected failure during reservation and abort", e);
        }
    }

    ExecutorReservation reservation() {
        return this.reservation;
    }

    public synchronized void triggerStopExecution(String reason) {
        this.triggerStopExecution(true, reason);
    }

    public synchronized void triggerStopExecution(boolean shouldInvalidateMetrics, String reason) {
        if (this.stopExecution()) {
            LOG.info("The executor was requested to stop the ongoing proposal execution and cancel the existing reassignments. Reason: {}", (Object)reason);
            this.executionStoppedByUser.set(true);
            this.executionStopShouldInvalidateMetrics.set(shouldInvalidateMetrics);
        }
    }

    public void dropRecentlyRemovedBrokers(Set<Integer> brokersToDrop) {
        this.latestRemoveStartTimeMsByBrokerId.keySet().removeAll(brokersToDrop);
    }

    public synchronized void shutdown() {
        LOG.info("Shutting down executor.");
        if (this.hasOngoingExecution) {
            LOG.warn("Shutdown executor may take long because execution is still in progress.");
        }
        KafkaCruiseControlUtils.executeSilently(this.proposalExecutor, ExecutorService::shutdown);
        try {
            this.proposalExecutor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while waiting for anomaly detector to shutdown.");
        }
        KafkaCruiseControlUtils.executeSilently(this.executionHistoryScannerExecutor, ExecutorService::shutdownNow);
        LOG.info("Executor shutdown completed.");
    }

    public boolean hasOngoingExecution() {
        return this.hasOngoingExecution;
    }

    public boolean isReservedByOther() {
        return this.reservation.isReserved() && !this.reservation.isReservedByMe();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateThrottle(long newThrottle) {
        int updatedBrokers;
        if (newThrottle < 0L) {
            throw new IllegalArgumentException("Cannot set a negative throttle");
        }
        ReplicationThrottleHelper replicationThrottleHelper = this.throttleHelper;
        synchronized (replicationThrottleHelper) {
            this.throttleHelper.setThrottleRate(newThrottle);
            updatedBrokers = this.throttleHelper.updateOrRemoveBrokerThrottleRate(newThrottle);
        }
        if (updatedBrokers == 0) {
            LOG.info("No brokers had throttling rate updated");
        } else {
            LOG.info("Updated throttle rate config on {} brokers to {}", (Object)updatedBrokers, (Object)newThrottle);
        }
        return updatedBrokers != 0;
    }

    public boolean hasOngoingPartitionReassignments() {
        return !Executor.partitionsBeingReassigned(this.adminUtils).isEmpty();
    }

    public Set<Integer> recentlyRemovedBrokers() {
        return Collections.unmodifiableSet(this.latestRemoveStartTimeMsByBrokerId.keySet());
    }

    public ExecutorState state() {
        return this.executorState;
    }

    boolean checkTaskTrackingIsClear() {
        return this.executionTaskManager.isBrokerExecutionTaskTrackerClear() && this.executionTaskManager.inExecutionTasks().isEmpty() && this.executionTaskManager.numPendingLeadershipMovements() == 0 && this.executionTaskManager.numFinishedInterBrokerPartitionMovements() == 0 && this.executionTaskManager.numPendingInterBrokerPartitionMovements() == 0;
    }

    public synchronized Future<?> executeProposals(Collection<PartitionProposal> proposals, Set<Integer> unthrottledBrokers, Set<Integer> removedBrokers, SamplerStateHandle samplerStateHandle, String uuid, BalanceOpExecutionCompletionCallback completionCallback) {
        try {
            LOG.info("executeProposals with UUID {} and completionCallback {}", (Object)uuid, (Object)completionCallback);
            return this.doExecuteProposals(proposals, unthrottledBrokers, samplerStateHandle, uuid, new ProposalExecutionRunnable(samplerStateHandle, removedBrokers, completionCallback, this.executionMetricsReporter));
        }
        catch (Exception e) {
            this.clearExecutionState();
            throw e;
        }
    }

    private synchronized Future<?> doExecuteProposals(Collection<PartitionProposal> proposals, Set<Integer> unthrottledBrokers, SamplerStateHandle samplerStateHandle, String uuid, ProposalExecutionRunnable executionRunnable) {
        if (this.hasOngoingExecution) {
            throw new IllegalStateException("Cannot execute new proposals while there is an ongoing execution.");
        }
        if (this.isReservedByOther()) {
            throw new IllegalStateException("Cannot execute new proposals because the Executor is reserved by another thread.");
        }
        if (samplerStateHandle == null) {
            throw new IllegalArgumentException("Load monitor cannot be null.");
        }
        if (uuid == null) {
            throw new IllegalStateException("UUID of the execution cannot be null.");
        }
        this.clearExecutionState();
        this.executionMetricsReporter.reportProposals(proposals);
        this.initProposalExecution(proposals, uuid);
        return this.startExecution(executionRunnable);
    }

    void initProposalExecution(Collection<PartitionProposal> proposals, String uuid) {
        this.clusterMetadataAtProposalInitialization = this.metadataClient.forceRefreshMetadata();
        this.executionTaskManager.addPartitionProposals(proposals, this.clusterMetadataAtProposalInitialization.cluster());
        this.uuid = uuid;
    }

    Future<?> startExecution(ProposalExecutionRunnable runnable) {
        this.numExecutionsStarted.incrementAndGet();
        this.sanityCheckOngoingReplicaMovement();
        this.hasOngoingExecution = true;
        this.anomalyDetector.maybeClearOngoingAnomalyDetectionTimeMs();
        return this.proposalExecutor.submit(runnable);
    }

    synchronized boolean stopExecution() {
        if (this.stopRequested.compareAndSet(false, true)) {
            this.numExecutionStopped.incrementAndGet();
            this.executionTaskManager.setStopRequested();
            return true;
        }
        return false;
    }

    final int numCancelledReassignments() {
        return this.numCancelledReassignments.get();
    }

    boolean executionStopShouldInvalidateMetrics() {
        return this.executionStopShouldInvalidateMetrics.get();
    }

    private void sanityCheckOngoingReplicaMovement() {
        if (this.hasOngoingPartitionReassignments()) {
            this.executionTaskManager.clear();
            this.uuid = null;
            throw new IllegalStateException("There are ongoing inter-broker partition movements.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeThrottles() {
        ReplicationThrottleHelper replicationThrottleHelper = this.throttleHelper;
        synchronized (replicationThrottleHelper) {
            this.throttleHelper.removeAllThrottles();
        }
    }

    private void removeExpiredRemovalHistory() {
        LOG.debug("Remove expired broker removal history");
        this.latestRemoveStartTimeMsByBrokerId.entrySet().removeIf(entry -> (Long)entry.getValue() + this.removalHistoryRetentionTimeMs < this.time.milliseconds());
    }

    final int lastRetriedTasksCount() {
        return this.executionTaskManager.retriedTasks();
    }

    final int numExecutionsStarted() {
        return this.numExecutionsStarted.get();
    }

    final int numExecutionStopped() {
        return this.numExecutionStopped.get();
    }

    private int numFailedReassignmentCancellations() {
        return this.numFailedReassignmentCancellations.get();
    }

    @Override
    public int avgReplicaReassignmentSpeedPerMinute() {
        return this.avgReplicaReassignmentSpeedPerMinute.get();
    }

    private void clearExecutionState() {
        this.executionTaskManager.clear();
        this.uuid = null;
        this.hasOngoingExecution = false;
        this.stopRequested.set(false);
        this.executionStoppedByUser.set(false);
        this.executionStopShouldInvalidateMetrics.set(true);
    }

    public static Set<TopicPartition> partitionsBeingReassigned(SbkAdminUtils adminUtils) {
        return adminUtils.listTargetReplicasBeingReassigned(Optional.empty()).keySet();
    }

    static final class ExecutorReservation {
        private final ReentrantLock lock = new ReentrantLock();

        boolean attemptReservation() {
            if (this.lock.isHeldByCurrentThread()) {
                throw new IllegalStateException("Cannot reserve the Executor again while already holding a reservation.");
            }
            return this.lock.tryLock();
        }

        void cancelReservation() {
            this.lock.unlock();
        }

        boolean isReservedByMe() {
            return this.lock.isHeldByCurrentThread();
        }

        boolean isReserved() {
            return this.lock.isLocked();
        }
    }

    private class ExecutionHistoryScanner
    implements Runnable {
        private ExecutionHistoryScanner() {
        }

        @Override
        public void run() {
            try {
                Executor.this.removeExpiredRemovalHistory();
            }
            catch (Throwable t) {
                LOG.warn("Received exception when trying to expire execution history.", t);
            }
        }
    }

    class ProposalExecutionRunnable
    implements Runnable {
        private final SamplerStateHandle samplerStateHandle;
        private final BalanceOpExecutionCompletionCallback completionCallback;
        private final ExecutionMetricsReporter executionMetricsReporter;
        private ExecutorState.State state;
        private final Set<Integer> recentlyRemovedBrokers;
        private final Set<Integer> removedBrokers;
        protected Throwable executionException;

        ProposalExecutionRunnable(SamplerStateHandle samplerStateHandle, Collection<Integer> removedBrokers, BalanceOpExecutionCompletionCallback completionCallback, ExecutionMetricsReporter executionMetricsReporter) {
            this.samplerStateHandle = samplerStateHandle;
            this.state = ExecutorState.State.NO_TASK_IN_PROGRESS;
            this.executionException = null;
            this.completionCallback = completionCallback;
            this.executionMetricsReporter = executionMetricsReporter;
            if (Executor.this.anomalyDetector == null) {
                throw new IllegalStateException("AnomalyDetector is not specified in Executor.");
            }
            if (removedBrokers != null) {
                removedBrokers.forEach(id -> this$0.latestRemoveStartTimeMsByBrokerId.put((Integer)id, this$0.time.milliseconds()));
                this.removedBrokers = new HashSet<Integer>(removedBrokers);
            } else {
                this.removedBrokers = Collections.emptySet();
            }
            this.recentlyRemovedBrokers = Executor.this.recentlyRemovedBrokers();
        }

        @Override
        public void run() {
            try (ProposalExecutionAutoCloseable ignored = new ProposalExecutionAutoCloseable(Executor.this.uuid, this.recentlyRemovedBrokers);){
                long executionStartMs = Executor.this.time.milliseconds();
                long highPrecisionStartMs = Executor.this.time.hiResClockMs();
                LOG.info("Starting execution of balancing proposals.");
                this.execute(executionStartMs);
                long executionTimeMs = Executor.this.time.hiResClockMs() - highPrecisionStartMs;
                this.executionMetricsReporter.reportExecutionTime(executionTimeMs);
                LOG.info("Execution finished. Elapsed time: {} ms", (Object)executionTimeMs);
            }
            catch (Exception e) {
                LOG.error("Exception during execution of ProposalExecutionRunnable", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void execute(long executionStartMs) {
            long startTime;
            ExecutorMetricsHandle metricsHandler;
            boolean isAnomaly;
            block12: {
                List<ExecutionTask> deadExecutionTasks;
                block10: {
                    block11: {
                        isAnomaly = AnomalyType.cachedValues().stream().anyMatch(type -> Executor.this.uuid.startsWith(type.toString()));
                        metricsHandler = new ExecutorMetricsHandle(this.samplerStateHandle, Executor.this.uuid);
                        startTime = Executor.this.time.hiResClockMs();
                        metricsHandler.handle();
                        boolean shouldStopExecution = this.interBrokerMove();
                        if (!shouldStopExecution) break block10;
                        LOG.info("Stopping execution {} after inter-broker movements - stopRequested: {}", (Object)Executor.this.uuid, (Object)Executor.this.stopRequested.get());
                        List<ExecutionTask> deadExecutionTasks2 = Executor.this.deadExecutionTasks();
                        if (this.executionException != null || deadExecutionTasks2.isEmpty()) break block11;
                        this.executionException = new DeadExecutionTaskException(String.format("Dead tasks encountered: %s", deadExecutionTasks2));
                    }
                    String operationSuffix = String.format("for operation %s", Executor.this.uuid);
                    LOG.info("Cleaning up execution {}", (Object)operationSuffix);
                    metricsHandler.close(Executor.this.executionStopShouldInvalidateMetrics.get());
                    this.tryRun(this.samplerStateHandle::forceRefreshClusterAndGeneration, "Unable to refresh cluster metadata after execution of " + operationSuffix);
                    if (isAnomaly) {
                        this.tryRun(() -> Executor.this.anomalyDetector.markSelfHealingFinished(Executor.this.uuid), "Caught exception while marking self healing finished " + operationSuffix);
                    }
                    boolean executionSucceeded = Executor.this.executorState.state() != ExecutorState.State.STOPPING_EXECUTION && this.executionException == null;
                    long executionTimeMin = Duration.ofMillis(Executor.this.time.hiResClockMs() - startTime).toMinutes();
                    LOG.info("ProposalExecutionRunnable finished after {} minutes with success state {} {} and exception: ", new Object[]{executionTimeMin, executionSucceeded, operationSuffix, this.executionException});
                    ExecutorNotification notification = new ExecutorNotification(executionStartMs, Executor.this.time.milliseconds(), Executor.this.uuid, Executor.this.stopRequested.get(), Executor.this.executionStoppedByUser.get(), this.executionException, executionSucceeded);
                    this.tryRun(() -> Executor.this.executorNotifier.sendNotification(notification), String.format("Caught exception while sending a notification (notification: %s) ", notification) + operationSuffix);
                    int retriedTasks = Executor.this.executionTaskManager.retriedTasks();
                    LOG.info("Task [{}] execution finished {}", (Object)Executor.this.uuid, retriedTasks == 0 ? "" : "with " + retriedTasks + " tasks retried");
                    if (this.completionCallback == null) return;
                    LOG.info("executionRunnable invoking completion callback");
                    this.tryRun(() -> this.completionCallback.accept(executionSucceeded, this.executionException), String.format("Caught exception while invoking completion callback (succeeded: %s, exception: %s) ", executionSucceeded, this.executionException) + operationSuffix);
                    return;
                }
                try {
                    ExecutorLeadershipReplicaMovement leadershipMove = new ExecutorLeadershipReplicaMovement(Executor.this.uuid, Executor.this.executionTaskManager, this.recentlyRemovedBrokers, Executor.this.throttleHelper, Executor.this.adminClient, Executor.this.adminUtils, Executor.this.stopRequested);
                    this.state = leadershipMove.state();
                    Executor.this.executorState = leadershipMove.executorState();
                    leadershipMove.move(this::waitForAnyExecutionTaskToFinish);
                    this.checkStopRequested();
                    this.updateOngoingExecutionState();
                    deadExecutionTasks = Executor.this.deadExecutionTasks();
                    if (this.executionException != null || deadExecutionTasks.isEmpty()) break block12;
                }
                catch (Throwable t) {
                    block13: {
                        List<ExecutionTask> deadExecutionTasks3;
                        try {
                            LOG.error("Executor got exception during execution", t);
                            this.executionException = t;
                            deadExecutionTasks3 = Executor.this.deadExecutionTasks();
                            if (this.executionException != null || deadExecutionTasks3.isEmpty()) break block13;
                        }
                        catch (Throwable throwable) {
                            List<ExecutionTask> deadExecutionTasks4 = Executor.this.deadExecutionTasks();
                            if (this.executionException == null && !deadExecutionTasks4.isEmpty()) {
                                this.executionException = new DeadExecutionTaskException(String.format("Dead tasks encountered: %s", deadExecutionTasks4));
                            }
                            String operationSuffix = String.format("for operation %s", Executor.this.uuid);
                            LOG.info("Cleaning up execution {}", (Object)operationSuffix);
                            metricsHandler.close(Executor.this.executionStopShouldInvalidateMetrics.get());
                            this.tryRun(this.samplerStateHandle::forceRefreshClusterAndGeneration, "Unable to refresh cluster metadata after execution of " + operationSuffix);
                            if (isAnomaly) {
                                this.tryRun(() -> Executor.this.anomalyDetector.markSelfHealingFinished(Executor.this.uuid), "Caught exception while marking self healing finished " + operationSuffix);
                            }
                            boolean executionSucceeded = Executor.this.executorState.state() != ExecutorState.State.STOPPING_EXECUTION && this.executionException == null;
                            long executionTimeMin = Duration.ofMillis(Executor.this.time.hiResClockMs() - startTime).toMinutes();
                            LOG.info("ProposalExecutionRunnable finished after {} minutes with success state {} {} and exception: ", new Object[]{executionTimeMin, executionSucceeded, operationSuffix, this.executionException});
                            ExecutorNotification notification = new ExecutorNotification(executionStartMs, Executor.this.time.milliseconds(), Executor.this.uuid, Executor.this.stopRequested.get(), Executor.this.executionStoppedByUser.get(), this.executionException, executionSucceeded);
                            this.tryRun(() -> Executor.this.executorNotifier.sendNotification(notification), String.format("Caught exception while sending a notification (notification: %s) ", notification) + operationSuffix);
                            int retriedTasks = Executor.this.executionTaskManager.retriedTasks();
                            LOG.info("Task [{}] execution finished {}", (Object)Executor.this.uuid, retriedTasks == 0 ? "" : "with " + retriedTasks + " tasks retried");
                            if (this.completionCallback == null) throw throwable;
                            LOG.info("executionRunnable invoking completion callback");
                            this.tryRun(() -> this.completionCallback.accept(executionSucceeded, this.executionException), String.format("Caught exception while invoking completion callback (succeeded: %s, exception: %s) ", executionSucceeded, this.executionException) + operationSuffix);
                            throw throwable;
                        }
                        this.executionException = new DeadExecutionTaskException(String.format("Dead tasks encountered: %s", deadExecutionTasks3));
                    }
                    String operationSuffix = String.format("for operation %s", Executor.this.uuid);
                    LOG.info("Cleaning up execution {}", (Object)operationSuffix);
                    metricsHandler.close(Executor.this.executionStopShouldInvalidateMetrics.get());
                    this.tryRun(this.samplerStateHandle::forceRefreshClusterAndGeneration, "Unable to refresh cluster metadata after execution of " + operationSuffix);
                    if (isAnomaly) {
                        this.tryRun(() -> Executor.this.anomalyDetector.markSelfHealingFinished(Executor.this.uuid), "Caught exception while marking self healing finished " + operationSuffix);
                    }
                    boolean executionSucceeded = Executor.this.executorState.state() != ExecutorState.State.STOPPING_EXECUTION && this.executionException == null;
                    long executionTimeMin = Duration.ofMillis(Executor.this.time.hiResClockMs() - startTime).toMinutes();
                    LOG.info("ProposalExecutionRunnable finished after {} minutes with success state {} {} and exception: ", new Object[]{executionTimeMin, executionSucceeded, operationSuffix, this.executionException});
                    ExecutorNotification notification = new ExecutorNotification(executionStartMs, Executor.this.time.milliseconds(), Executor.this.uuid, Executor.this.stopRequested.get(), Executor.this.executionStoppedByUser.get(), this.executionException, executionSucceeded);
                    this.tryRun(() -> Executor.this.executorNotifier.sendNotification(notification), String.format("Caught exception while sending a notification (notification: %s) ", notification) + operationSuffix);
                    int retriedTasks = Executor.this.executionTaskManager.retriedTasks();
                    LOG.info("Task [{}] execution finished {}", (Object)Executor.this.uuid, retriedTasks == 0 ? "" : "with " + retriedTasks + " tasks retried");
                    if (this.completionCallback == null) return;
                    LOG.info("executionRunnable invoking completion callback");
                    this.tryRun(() -> this.completionCallback.accept(executionSucceeded, this.executionException), String.format("Caught exception while invoking completion callback (succeeded: %s, exception: %s) ", executionSucceeded, this.executionException) + operationSuffix);
                    return;
                }
                this.executionException = new DeadExecutionTaskException(String.format("Dead tasks encountered: %s", deadExecutionTasks));
            }
            String operationSuffix = String.format("for operation %s", Executor.this.uuid);
            LOG.info("Cleaning up execution {}", (Object)operationSuffix);
            metricsHandler.close(Executor.this.executionStopShouldInvalidateMetrics.get());
            this.tryRun(this.samplerStateHandle::forceRefreshClusterAndGeneration, "Unable to refresh cluster metadata after execution of " + operationSuffix);
            if (isAnomaly) {
                this.tryRun(() -> Executor.this.anomalyDetector.markSelfHealingFinished(Executor.this.uuid), "Caught exception while marking self healing finished " + operationSuffix);
            }
            boolean executionSucceeded = Executor.this.executorState.state() != ExecutorState.State.STOPPING_EXECUTION && this.executionException == null;
            long executionTimeMin = Duration.ofMillis(Executor.this.time.hiResClockMs() - startTime).toMinutes();
            LOG.info("ProposalExecutionRunnable finished after {} minutes with success state {} {} and exception: ", new Object[]{executionTimeMin, executionSucceeded, operationSuffix, this.executionException});
            ExecutorNotification notification = new ExecutorNotification(executionStartMs, Executor.this.time.milliseconds(), Executor.this.uuid, Executor.this.stopRequested.get(), Executor.this.executionStoppedByUser.get(), this.executionException, executionSucceeded);
            this.tryRun(() -> Executor.this.executorNotifier.sendNotification(notification), String.format("Caught exception while sending a notification (notification: %s) ", notification) + operationSuffix);
            int retriedTasks = Executor.this.executionTaskManager.retriedTasks();
            LOG.info("Task [{}] execution finished {}", (Object)Executor.this.uuid, retriedTasks == 0 ? "" : "with " + retriedTasks + " tasks retried");
            if (this.completionCallback == null) return;
            LOG.info("executionRunnable invoking completion callback");
            this.tryRun(() -> this.completionCallback.accept(executionSucceeded, this.executionException), String.format("Caught exception while invoking completion callback (succeeded: %s, exception: %s) ", executionSucceeded, this.executionException) + operationSuffix);
            return;
        }

        private boolean interBrokerMove() throws InterruptedException {
            ExecutorInterBrokerReplicaMovement interBroker = new ExecutorInterBrokerReplicaMovement(Executor.this.uuid, Executor.this.executionTaskManager, this.recentlyRemovedBrokers, Executor.this.throttleHelper, Executor.this.adminClient, Executor.this.adminUtils, Executor.this.stopRequested, this.removedBrokers, this.samplerStateHandle, Executor.this.clusterMetadataAtProposalInitialization.cluster(), Executor.this.time, Executor.this.invalidReplicaAssignmentRetryMs, Executor.this.isV2ExecutorEnabled);
            this.state = interBroker.state();
            Executor.this.executorState = interBroker.executorState();
            int numPendingMovementsPriorExecution = Executor.this.executionTaskManager.numPendingInterBrokerPartitionMovements();
            int numPendingReplicaMovementsPriorExecution = Executor.this.executionTaskManager.numPendingReplicaMovements();
            long executionStartTimeMs = Executor.this.time.hiResClockMs();
            interBroker.move(this::waitForAnyExecutionTaskToFinish);
            boolean shouldStopExecution = this.checkStopRequested();
            this.updateOngoingExecutionState();
            int numPendingMovementsPostExecution = Executor.this.executionTaskManager.numPendingInterBrokerPartitionMovements();
            int numPendingReplicaMovementsPostExecution = Executor.this.executionTaskManager.numPendingReplicaMovements();
            int numTasksInExecution = Executor.this.executionTaskManager.inExecutionTasks().size();
            long executionTotalTimeMs = Executor.this.time.hiResClockMs() - executionStartTimeMs;
            int numExecutedReassignments = numPendingMovementsPriorExecution - (numPendingMovementsPostExecution + numTasksInExecution);
            int reassignmentsPerMinute = (int)((double)numExecutedReassignments / ((double)executionTotalTimeMs / 60000.0));
            int numExecutedReplicaMoves = numPendingReplicaMovementsPriorExecution - numPendingReplicaMovementsPostExecution;
            int replicaMovesPerMinute = (int)((double)reassignmentsPerMinute / ((double)executionTotalTimeMs / 60000.0));
            Executor.this.replicaReassignmentExecutionTimes.add(reassignmentsPerMinute);
            Executor.this.avgReplicaReassignmentSpeedPerMinute.set((int)Executor.this.replicaReassignmentExecutionTimes.recencyBiasedAverage().orElse(reassignmentsPerMinute));
            LOG.info("Inter-broker partition movements finished in {} ms using {} executor. {} reassignments and {} replica-moves executed at the speed of {} reassignments/minute and {} replica-moves/minute, while the rolling average speed of reassignments/minute over the last {} runs was {}", new Object[]{executionTotalTimeMs, Executor.this.isV2ExecutorEnabled ? "multishot" : "singleshot", numExecutedReassignments, numExecutedReplicaMoves, reassignmentsPerMinute, replicaMovesPerMinute, Executor.this.avgReplicaReassignmentSpeedPerMinute, Executor.this.replicaReassignmentExecutionTimes.size()});
            if (shouldStopExecution) {
                ExecutionTaskTracker.ExecutionTasksSummary executionTasksSummary = Executor.this.executionTaskManager.getExecutionTasksSummary(Collections.emptySet());
                LOG.info("Stopping execution {} after {} inter-broker movements - stopRequested: {}. {}, {} remaining data to move;for leadership movements {} task cancelled.", new Object[]{Executor.this.uuid, numPendingMovementsPriorExecution - numPendingMovementsPostExecution, Executor.this.stopRequested.get(), executionTasksSummary.summarize(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION), executionTasksSummary.remainingInterBrokerDataToMoveInMB(), executionTasksSummary.taskStat().get((Object)ExecutionTask.TaskType.LEADER_ACTION).get((Object)ExecutionTask.State.PENDING)});
                return true;
            }
            if (numPendingMovementsPostExecution == 0 && numTasksInExecution == 0) {
                LOG.info("Inter-broker partition movements finished successfully.");
            } else {
                LOG.info("Inter-broker partition movements finished with leftover tasks to execute - {} remaining partitions to move, {} tasks remaining in execution", (Object)numPendingMovementsPostExecution, (Object)numTasksInExecution);
            }
            return false;
        }

        private void tryRun(Runnable runnable, String errorMessage) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                LOG.error(errorMessage, (Throwable)exception);
            }
        }

        private void updateOngoingExecutionState() {
            switch (this.state) {
                case LEADER_MOVEMENT_TASK_IN_PROGRESS: {
                    Executor.this.executorState = ExecutorState.operationInProgress(ExecutorState.State.LEADER_MOVEMENT_TASK_IN_PROGRESS, Executor.this.executionTaskManager.getExecutionTasksSummary(Collections.singleton(ExecutionTask.TaskType.LEADER_ACTION)), Executor.this.executionTaskManager.interBrokerPartitionMovementConcurrency(), Executor.this.executionTaskManager.leadershipMovementConcurrency(), Executor.this.uuid, this.recentlyRemovedBrokers);
                    break;
                }
                case INTER_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS: {
                    Executor.this.executorState = ExecutorState.operationInProgress(ExecutorState.State.INTER_BROKER_REPLICA_MOVEMENT_TASK_IN_PROGRESS, Executor.this.executionTaskManager.getExecutionTasksSummary(Collections.singleton(ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION)), Executor.this.executionTaskManager.interBrokerPartitionMovementConcurrency(), Executor.this.executionTaskManager.leadershipMovementConcurrency(), Executor.this.uuid, this.recentlyRemovedBrokers);
                    break;
                }
                case STOPPING_EXECUTION: {
                    Executor.this.executorState = ExecutorState.operationInProgress(ExecutorState.State.STOPPING_EXECUTION, Executor.this.executionTaskManager.getExecutionTasksSummary(new HashSet<ExecutionTask.TaskType>(ExecutionTask.TaskType.cachedValues())), Executor.this.executionTaskManager.interBrokerPartitionMovementConcurrency(), Executor.this.executionTaskManager.leadershipMovementConcurrency(), Executor.this.uuid, this.recentlyRemovedBrokers);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected ongoing execution state " + String.valueOf((Object)this.state));
                }
            }
        }

        private boolean checkStopRequested() {
            boolean stopRequested = Executor.this.stopRequested.get();
            if (stopRequested) {
                this.state = ExecutorState.State.STOPPING_EXECUTION;
            }
            return stopRequested;
        }

        private List<ExecutionTask> waitForAnyExecutionTaskToFinish(AbstractExecutorReplicaMovement movement) {
            List<ExecutionTask> finishedTasks = Executor.this.executionTracker.waitForAnyExecutionTaskToFinish();
            this.trackExecutedTasksInTheMovementTracker(finishedTasks);
            this.emitExecutionTasksMetrics(finishedTasks);
            this.handleDeadTasksAndReassignmentsCancellation(finishedTasks);
            this.checkStopRequested();
            this.updateOngoingExecutionState();
            LOG.info("Completed tasks: {}", finishedTasks);
            return finishedTasks;
        }

        private void trackExecutedTasksInTheMovementTracker(List<ExecutionTask> finishedTasks) {
            for (ExecutionTask task : finishedTasks) {
                if (task.state() != ExecutionTask.State.COMPLETED) continue;
                if (task.type() == ExecutionTask.TaskType.LEADER_ACTION) {
                    Executor.this.movementsTracker.trackMovement(new TopicPartitionMovement(task.partitionProposal().topicPartition(), ActionType.LEADERSHIP_MOVEMENT));
                    continue;
                }
                if (task.type() != ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION) continue;
                Executor.this.movementsTracker.trackMovement(new TopicPartitionMovement(task.partitionProposal().topicPartition(), ActionType.INTER_BROKER_REPLICA_MOVEMENT));
            }
        }

        private void emitExecutionTasksMetrics(List<ExecutionTask> finishedTasks) {
            if (finishedTasks == null || finishedTasks.isEmpty()) {
                return;
            }
            for (ExecutionTask task : finishedTasks) {
                if (task.state() != ExecutionTask.State.COMPLETED || task.type() != ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION) continue;
                long executionTimeInSeconds = TimeUnit.MILLISECONDS.toSeconds(task.endTime() - task.startTime());
                long partitionSizeInMB = task.partitionProposal().singleDestinationBrokerDataToReceiveInMB();
                this.executionMetricsReporter.mayBeRegisterAndRecordReassignmentTime(executionTimeInSeconds, partitionSizeInMB);
            }
            this.executionMetricsReporter.updateReassignmentTimeMetrics(Executor.this.time.hiResClockMs());
        }

        private void handleDeadTasksAndReassignmentsCancellation(List<ExecutionTask> finishedTasks) {
            List deadInterBrokerReplicaTasks = finishedTasks.stream().filter(t -> t.state() == ExecutionTask.State.DEAD).filter(t -> t.type() == ExecutionTask.TaskType.INTER_BROKER_REPLICA_ACTION).collect(Collectors.toList());
            List<TopicPartition> partitionReassignmentsToCancel = deadInterBrokerReplicaTasks.stream().map(d -> d.partitionProposal().topicPartition()).collect(Collectors.toList());
            int numReassignmentsToCancel = partitionReassignmentsToCancel.size();
            if (numReassignmentsToCancel > 0) {
                LOG.info("Cancelling {} partition reassignments", (Object)numReassignmentsToCancel);
                int numCancelled = Executor.this.adminUtils.cancelInterBrokerReplicaMovements(partitionReassignmentsToCancel);
                int numFailedCancellations = numReassignmentsToCancel - numCancelled;
                LOG.info("Successfully cancelled {}/{} partition reassignments", (Object)numCancelled, (Object)numReassignmentsToCancel);
                Executor.this.numCancelledReassignments.addAndGet(numCancelled);
                if (numFailedCancellations > 0) {
                    LOG.warn("Failed to cancel {}/{} partition reassignments", (Object)numFailedCancellations, (Object)numReassignmentsToCancel);
                    Executor.this.numFailedReassignmentCancellations.addAndGet(numFailedCancellations);
                }
            }
            if (!deadInterBrokerReplicaTasks.isEmpty() && !Executor.this.stopRequested.get()) {
                LOG.info("Cancelling execution because {} tasks have failed. Failed partitions: {}", (Object)deadInterBrokerReplicaTasks.size(), deadInterBrokerReplicaTasks.stream().map(d -> d.partitionProposal().topicPartition()));
                Executor.this.stopExecution();
            }
        }

        private class ProposalExecutionAutoCloseable
        implements AutoCloseable {
            public ProposalExecutionAutoCloseable(String uuid, Set<Integer> recentlyRemovedBrokers) {
                ProposalExecutionRunnable.this.state = ExecutorState.State.STARTING_EXECUTION;
                Executor.this.executorState = ExecutorState.executionStarted(uuid, recentlyRemovedBrokers);
                LOG.info("Task [{}] execution starts.", (Object)uuid);
            }

            @Override
            public void close() {
                ProposalExecutionRunnable.this.state = ExecutorState.State.NO_TASK_IN_PROGRESS;
                Executor.this.executorState = ExecutorState.noTaskInProgress(ProposalExecutionRunnable.this.recentlyRemovedBrokers);
                Executor.this.clearExecutionState();
            }
        }
    }

    public static class PartitionReplicas {
        private final List<Integer> replicas;
        private final List<Integer> observers;

        public PartitionReplicas(List<Integer> replicas, List<Integer> observers) {
            this.replicas = replicas;
            this.observers = observers;
        }

        public List<Integer> replicas() {
            return Collections.unmodifiableList(this.replicas);
        }

        public List<Integer> observers() {
            return Collections.unmodifiableList(this.observers);
        }
    }

    public static interface ExecutionTaskWaiter {
        public List<ExecutionTask> waitForAnyTaskToFinish(AbstractExecutorReplicaMovement var1);
    }
}

