/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.metricsreporter.metric;

import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import java.nio.ByteBuffer;

public abstract class CruiseControlMetric {
    static final byte METRIC_VERSION = 0;
    private final RawMetricType rawMetricType;
    private final long time;
    private final int brokerId;
    private final float value;

    protected CruiseControlMetric(RawMetricType rawMetricType, long time, int brokerId, float value) {
        this.rawMetricType = rawMetricType;
        this.time = time;
        this.brokerId = brokerId;
        this.value = value;
    }

    public abstract MetricClassId metricClassId();

    public RawMetricType rawMetricType() {
        return this.rawMetricType;
    }

    public long time() {
        return this.time;
    }

    public int brokerId() {
        return this.brokerId;
    }

    public double value() {
        return this.value;
    }

    abstract ByteBuffer toBuffer(int var1);

    public String toString() {
        return String.format("[RawMetricType=%s,Time=%d,BrokerId=%d,Value=%.4f]", new Object[]{this.rawMetricType, this.time, this.brokerId, Float.valueOf(this.value)});
    }

    public static enum MetricClassId {
        BROKER_METRIC(0),
        TOPIC_METRIC(1),
        PARTITION_METRIC(2);

        private final byte id;

        private MetricClassId(byte id) {
            this.id = id;
        }

        byte id() {
            return this.id;
        }

        static MetricClassId forId(byte id) {
            if (id < MetricClassId.values().length) {
                return MetricClassId.values()[id];
            }
            throw new IllegalArgumentException("MetricClassId " + id + " does not exist.");
        }
    }
}

