/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.common.CellResource;
import com.linkedin.kafka.cruisecontrol.model.CellResourceLoad;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class CellResourceUsage {
    private final Map<CellResource, CellResourceLoad> resourceToLoadMap;

    public CellResourceUsage() {
        this.resourceToLoadMap = new HashMap<CellResource, CellResourceLoad>();
    }

    public CellResourceUsage(Map<CellResource, CellResourceLoad> resourceToLoadMap) {
        this.resourceToLoadMap = new HashMap<CellResource, CellResourceLoad>(Objects.requireNonNull(resourceToLoadMap, "Resource to load map cannot be null."));
    }

    public CellResourceUsage(CellResourceUsage other) {
        this.resourceToLoadMap = new HashMap<CellResource, CellResourceLoad>(other.resourceToLoadMap);
    }

    public CellResourceLoad load(CellResource cellResource) {
        return this.resourceToLoadMap.get((Object)cellResource);
    }

    public CellResourceLoad addOrUpdateLoad(CellResourceLoad cellResourceLoad) {
        return this.resourceToLoadMap.put(cellResourceLoad.cellResource(), cellResourceLoad);
    }

    public Map<CellResource, CellResourceLoad> resourceToLoadMap() {
        return Collections.unmodifiableMap(this.resourceToLoadMap);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CellResourceUsage that = (CellResourceUsage)o;
        return Objects.equals(this.resourceToLoadMap, that.resourceToLoadMap);
    }

    public int hashCode() {
        return Objects.hash(this.resourceToLoadMap);
    }

    public String toString() {
        return "CellResourceUsage{resourceToLoadMap=" + String.valueOf(this.resourceToLoadMap) + "}";
    }
}

