/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.model.CellResourceLoad;
import com.linkedin.kafka.cruisecontrol.model.view.CellTenantView;
import java.util.SortedSet;
import java.util.TreeSet;

public class OverloadedCell {
    private final CellTenantView cell;
    private final SortedSet<CellResourceLoad> overloadedResources;

    private OverloadedCell(Builder builder) {
        this.cell = builder.cell;
        this.overloadedResources = builder.overloadedResources;
    }

    public static Builder builder(CellTenantView cell) {
        return new Builder(cell);
    }

    public CellTenantView cell() {
        return this.cell;
    }

    public boolean isOverloaded() {
        return !this.overloadedResources.isEmpty();
    }

    public SortedSet<CellResourceLoad> overloadedResources() {
        return this.overloadedResources;
    }

    public String toString() {
        return "OverloadedCell{cell=" + this.cell.id() + ", cellResourceLoads=" + String.valueOf(this.overloadedResources) + "}";
    }

    public static class Builder {
        private final CellTenantView cell;
        private final SortedSet<CellResourceLoad> overloadedResources;

        public Builder(CellTenantView cell) {
            this.cell = cell;
            this.overloadedResources = new TreeSet<CellResourceLoad>();
        }

        public Builder addOverloadedResource(CellResourceLoad cellResourceLoad) {
            this.overloadedResources.add(cellResourceLoad);
            return this;
        }

        public OverloadedCell build() {
            return new OverloadedCell(this);
        }
    }
}

