/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ResourceDetectorSharedState {
    private final Set<Integer> cellsExcludedForCODDestination;
    private final Set<Integer> cellsExcludedForCODSource = new HashSet<Integer>();

    public ResourceDetectorSharedState() {
        this.cellsExcludedForCODDestination = new HashSet<Integer>();
    }

    public void addCellExclusion(List<Integer> destinationExclusions, List<Integer> sourceExclusions) {
        this.cellsExcludedForCODDestination.addAll(destinationExclusions);
        this.cellsExcludedForCODSource.addAll(sourceExclusions);
    }

    public Set<Integer> cellsExcludedForCODDestination() {
        return this.cellsExcludedForCODDestination;
    }

    public Set<Integer> cellsExcludedForCODSource() {
        return this.cellsExcludedForCODSource;
    }

    public void clearState() {
        this.cellsExcludedForCODDestination.clear();
        this.cellsExcludedForCODSource.clear();
    }

    public boolean stateChanged() {
        return !this.cellsExcludedForCODSource().isEmpty();
    }
}

