/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model;

import com.linkedin.kafka.cruisecontrol.model.ResourceDetectorSharedState;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TenantStripingSharedState {
    private final Set<String> ongoingTenantAssignments = new HashSet<String>();
    private ResourceDetectorSharedState resourceDetectorSharedState;

    public void resourceDetectorSharedState(ResourceDetectorSharedState resourceDetectorSharedState) {
        this.resourceDetectorSharedState = resourceDetectorSharedState;
    }

    public void addOngoingTenants(String tenantId) {
        this.ongoingTenantAssignments.add(tenantId);
    }

    public void removeOngoingTenantAssignments(Set<String> tenants) {
        this.ongoingTenantAssignments.removeAll(tenants);
    }

    public Set<String> pendingTenantsExecutions() {
        return this.ongoingTenantAssignments;
    }

    public void addExcludedCells(List<Integer> selectedCells, List<Integer> existingStripesForTenant) {
        ArrayList<Integer> allStripesForTenant = new ArrayList<Integer>(existingStripesForTenant);
        allStripesForTenant.addAll(selectedCells);
        this.resourceDetectorSharedState.addCellExclusion(selectedCells, allStripesForTenant);
    }

    public void clearSharedState() {
        this.ongoingTenantAssignments.clear();
        this.clearCellExclusions();
    }

    public void clearCellExclusions() {
        this.resourceDetectorSharedState.clearState();
    }
}

