/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.model.view;

import com.linkedin.kafka.cruisecontrol.common.CellResource;
import com.linkedin.kafka.cruisecontrol.executor.TenantProposal;
import com.linkedin.kafka.cruisecontrol.model.Cell;
import com.linkedin.kafka.cruisecontrol.model.CellResourceLoad;
import com.linkedin.kafka.cruisecontrol.model.CellResourceUsage;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.model.Tenant;
import com.linkedin.kafka.cruisecontrol.model.view.CellTenantView;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.common.CellLoad;

public class ClusterModelCellView {
    private final Map<Integer, CellTenantView> cellIdToCell;
    private final Map<String, Tenant> tenantsById;

    public ClusterModelCellView(ClusterModel clusterModel) {
        HashMap<Integer, CellTenantView> cellIdToCell = new HashMap<Integer, CellTenantView>();
        for (Cell cell : clusterModel.cells()) {
            cellIdToCell.put(cell.id(), new CellTenantView(cell));
        }
        this.cellIdToCell = cellIdToCell;
        HashMap<String, Tenant> tenantsById = new HashMap<String, Tenant>();
        for (CellTenantView cell : cellIdToCell.values()) {
            for (Tenant tenant : cell.tenants()) {
                tenantsById.put(tenant.tenantId(), tenant);
            }
        }
        this.tenantsById = tenantsById;
    }

    public ClusterModelCellView(ClusterModelCellView other) {
        this.cellIdToCell = new HashMap<Integer, CellTenantView>();
        for (Map.Entry<Integer, CellTenantView> entry : other.cellIdToCell.entrySet()) {
            this.cellIdToCell.put(entry.getKey(), new CellTenantView(entry.getValue()));
        }
        this.tenantsById = new HashMap<String, Tenant>();
        for (Map.Entry<Object, Object> entry : other.tenantsById.entrySet()) {
            this.tenantsById.put((String)entry.getKey(), new Tenant((Tenant)entry.getValue()));
        }
    }

    public Collection<CellTenantView> cells() {
        return this.cellIdToCell.values();
    }

    public Map<String, Tenant> tenantsById() {
        return this.tenantsById;
    }

    public Collection<CellTenantView> cells(Predicate<CellTenantView> predicate) {
        return this.cellIdToCell.values().stream().filter(predicate).collect(Collectors.toList());
    }

    public CellTenantView cell(int id) {
        return this.cellIdToCell.get(id);
    }

    public void relocateTenant(String tenantId, int sourceCellId, int destinationCellId) {
        Tenant tenant = this.tenantsById.get(tenantId);
        CellTenantView sourceCell = this.cellIdToCell.get(sourceCellId);
        CellTenantView destinationCell = this.cellIdToCell.get(destinationCellId);
        if (tenant == null) {
            throw new IllegalArgumentException(String.format("Tenant %s is not in the cluster.", tenantId));
        }
        if (sourceCell == null) {
            throw new IllegalArgumentException(String.format("Source cell %d is not in the cluster.", sourceCellId));
        }
        if (destinationCell == null) {
            throw new IllegalArgumentException(String.format("Destination cell %d is not in the cluster.", destinationCellId));
        }
        if (sourceCellId != destinationCellId) {
            sourceCell.removeTenant(tenant);
            destinationCell.addTenant(tenant, sourceCellId);
            tenant.relocate(sourceCellId, destinationCellId);
        }
    }

    public void apply(TenantProposal tenantProposal) {
        this.relocateTenant(tenantProposal.tenant().tenantId(), tenantProposal.oldCellId(), tenantProposal.newCellId());
    }

    public void unapply(TenantProposal tenantProposal) {
        this.relocateTenant(tenantProposal.tenant().tenantId(), tenantProposal.newCellId(), tenantProposal.oldCellId());
    }

    public List<CellLoad> cellLoadStats(Long maxReplicasPerBroker, List<Integer> cellIds) {
        List<Integer> cellIdsToUse = cellIds.isEmpty() ? this.cellIdToCell.keySet() : cellIds;
        return cellIdsToUse.stream().map(this.cellIdToCell::get).map(cell -> new CellLoad(cell.id(), cell.cellUtilRatio(maxReplicasPerBroker))).collect(Collectors.toList());
    }

    public List<CellLoad> cellLoadStats(Long maxReplicasPerBroker) {
        return this.cellLoadStats(maxReplicasPerBroker, Collections.emptyList());
    }

    public Map<Integer, CellResourceUsage> cellResourceLoadStats(long maxReplicasPerBroker, List<Integer> cellIds) {
        List<Integer> cellIdsToUse = cellIds.isEmpty() ? this.cellIdToCell.keySet() : cellIds;
        HashMap<Integer, CellResourceUsage> cellResourceLoadStats = new HashMap<Integer, CellResourceUsage>();
        Iterator iterator = cellIdsToUse.iterator();
        while (iterator.hasNext()) {
            int cellId = (Integer)iterator.next();
            CellTenantView cell = this.cellIdToCell.get(cellId);
            CellResourceUsage resourceUsage = new CellResourceUsage();
            for (CellResource resource : CellResource.cachedValues()) {
                CellResourceLoad loadForResource = cell.loadForResource(resource, maxReplicasPerBroker);
                resourceUsage.addOrUpdateLoad(loadForResource);
            }
            cellResourceLoadStats.put(cellId, resourceUsage);
        }
        return cellResourceLoadStats;
    }

    public Map<Integer, CellResourceUsage> cellResourceLoadStats(Long maxReplicasPerBroker) {
        return this.cellResourceLoadStats(maxReplicasPerBroker, Collections.emptyList());
    }
}

