/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor;

import com.linkedin.cruisecontrol.common.utils.Utils;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.AggregatedMetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.Extrapolation;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricValues;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.ValuesAndExtrapolations;
import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import com.linkedin.kafka.cruisecontrol.config.ClusterBrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.model.Broker;
import com.linkedin.kafka.cruisecontrol.model.ClusterModel;
import com.linkedin.kafka.cruisecontrol.monitor.metricdefinition.KafkaMetricDef;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.SampleExtrapolation;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.PartitionEntity;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ReplicaEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.CellState;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DescribeCellsResponseData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorUtils {
    public static final double UNIT_INTERVAL_TO_PERCENTAGE = 100.0;
    private static final Logger LOG = LoggerFactory.getLogger(MonitorUtils.class);
    private static final Set<Short> FOLLOWER_METRIC_DEF_IDS = new HashSet<Short>(Arrays.asList(KafkaMetricDef.commonMetricDefId(KafkaMetricDef.REPLICATION_BYTES_IN_RATE), KafkaMetricDef.commonMetricDefId(KafkaMetricDef.FETCH_FROM_FOLLOWER_BYTES_OUT_RATE), KafkaMetricDef.commonMetricDefId(KafkaMetricDef.FOLLOWER_FETCH_REQUEST_RATE), KafkaMetricDef.commonMetricDefId(KafkaMetricDef.FETCH_FROM_FOLLOWER_REQUEST_RATE), KafkaMetricDef.commonMetricDefId(KafkaMetricDef.REPLICATION_BYTES_IN_RATE)));

    private MonitorUtils() {
    }

    private static AggregatedMetricValues toFollowerMetricValues(AggregatedMetricValues aggregatedMetricValues) {
        AggregatedMetricValues followerLoad = new AggregatedMetricValues();
        for (short metricId : aggregatedMetricValues.metricIds()) {
            Resource metricResource = KafkaMetricDef.commonMetricDef().metricInfo(metricId).resource();
            if (Resource.CPU == metricResource || Resource.DISK == metricResource || Resource.RACK_BASED_CONSUME_OUT == metricResource || FOLLOWER_METRIC_DEF_IDS.contains(metricId)) {
                followerLoad.add(metricId, aggregatedMetricValues.valuesFor(metricId));
                continue;
            }
            followerLoad.add(metricId, new MetricValues(aggregatedMetricValues.length()));
        }
        return followerLoad;
    }

    private static AggregatedMetricValues toLeaderMetricValues(AggregatedMetricValues aggregatedMetricValues) {
        AggregatedMetricValues leaderLoad = new AggregatedMetricValues();
        for (short metricId : aggregatedMetricValues.metricIds()) {
            if (FOLLOWER_METRIC_DEF_IDS.contains(metricId)) {
                leaderLoad.add(metricId, new MetricValues(aggregatedMetricValues.length()));
                continue;
            }
            leaderLoad.add(metricId, aggregatedMetricValues.valuesFor(metricId));
        }
        return leaderLoad;
    }

    public static boolean metadataChanged(MetadataClient.ClusterMetadata prev, MetadataClient.ClusterMetadata curr) {
        Cluster prevCluster = prev.cluster();
        Cluster currCluster = curr.cluster();
        HashSet prevNodeSet = new HashSet(prevCluster.nodes());
        if (prevNodeSet.size() != currCluster.nodes().size()) {
            LOG.debug("detected cluster size changes.");
            return true;
        }
        prevNodeSet.removeAll(currCluster.nodes());
        if (!prevNodeSet.isEmpty()) {
            LOG.debug("detected new nodes.");
            return true;
        }
        if (!prevCluster.topics().equals(currCluster.topics())) {
            LOG.debug("detected new topics.");
            return true;
        }
        for (String topic : prevCluster.topics()) {
            if (!prevCluster.partitionCountForTopic(topic).equals(currCluster.partitionCountForTopic(topic))) {
                LOG.debug("detected partition counts changed for topic: {}.", (Object)topic);
                return true;
            }
            for (PartitionInfo prevPartInfo : prevCluster.partitionsForTopic(topic)) {
                PartitionInfo currPartInfo;
                if (!MonitorUtils.leaderChanged(prevPartInfo, currPartInfo = currCluster.partition(new TopicPartition(prevPartInfo.topic(), prevPartInfo.partition()))) && !MonitorUtils.replicaListChanged(prevPartInfo, currPartInfo)) continue;
                LOG.debug("detected  leadership changed for topic: {} ", (Object)topic);
                return true;
            }
        }
        if (!prev.topicPlacements().equals(curr.topicPlacements())) {
            LOG.debug("detected Topic Placement changed for topic.");
            return true;
        }
        if (!prev.replicaExclusions().equals(curr.replicaExclusions())) {
            LOG.debug("detected Broker Replica exclusions changes.");
            return true;
        }
        if (!prev.reassigningPartitions().equals(curr.reassigningPartitions())) {
            LOG.debug("detected Reassigning partitions changes.");
            return true;
        }
        if (!prev.tenants().equals(curr.tenants())) {
            LOG.debug("detected Tenant mapping changes.");
            return true;
        }
        if (!prev.brokerIdToCellDescription().equals(curr.brokerIdToCellDescription())) {
            LOG.debug("detected brokerid to cell description changes.");
            return true;
        }
        if (!prev.degradedBrokers().equals(curr.degradedBrokers())) {
            LOG.debug("detected demoted brokers changes.");
            return true;
        }
        return false;
    }

    private static boolean leaderChanged(PartitionInfo prevPartInfo, PartitionInfo currPartInfo) {
        Node prevLeader = prevPartInfo.leader();
        Node currLeader = currPartInfo.leader();
        return !(prevLeader == null && currLeader == null || prevLeader != null && currLeader != null && prevLeader.id() == currLeader.id());
    }

    private static boolean replicaListChanged(PartitionInfo prevPartInfo, PartitionInfo currPartInfo) {
        int i;
        if (prevPartInfo.replicas().length != currPartInfo.replicas().length || prevPartInfo.observers().length != currPartInfo.observers().length) {
            return true;
        }
        for (i = 0; i < prevPartInfo.replicas().length; ++i) {
            if (prevPartInfo.replicas()[i].id() == currPartInfo.replicas()[i].id()) continue;
            return true;
        }
        for (i = 0; i < prevPartInfo.observers().length; ++i) {
            if (prevPartInfo.observers()[i].id() == currPartInfo.observers()[i].id()) continue;
            return true;
        }
        return false;
    }

    public static int totalNumPartitions(Cluster cluster) {
        int totalNumPartitions = 0;
        for (String topic : cluster.topics()) {
            totalNumPartitions += cluster.partitionCountForTopic(topic).intValue();
        }
        return totalNumPartitions;
    }

    static ModifiedAggregatedMetricValues getAggregatedMetricValues(ValuesAndExtrapolations partitionValuesAndExtrapolations, ValuesAndExtrapolations replicaValuesAndExtrapolations, ReplicaEntity replicaEntity) {
        AggregatedMetricValues partitionMetricValues = partitionValuesAndExtrapolations.metricValues();
        AggregatedMetricValues replicaMetricValues = replicaValuesAndExtrapolations.metricValues();
        ModifiedAggregatedMetricValues replicaLoad = MonitorUtils.mergeMetricValues(partitionMetricValues, replicaMetricValues, replicaEntity);
        replicaLoad.updateMetricValues(replicaEntity.isLeader() ? MonitorUtils.toLeaderMetricValues(replicaLoad.metricValues()) : MonitorUtils.toFollowerMetricValues(replicaLoad.metricValues()));
        return replicaLoad;
    }

    static ModifiedAggregatedMetricValues mergeMetricValues(AggregatedMetricValues partitionMetricValues, AggregatedMetricValues replicaMetricValues, ReplicaEntity replicaEntity) {
        AggregatedMetricValues mergedValues = new AggregatedMetricValues();
        for (short metricId : partitionMetricValues.metricIds()) {
            KafkaMetricDef metricDef = KafkaMetricDef.partitionMetricDef().metricInfo(metricId).kafkaMetricDef();
            short commonMetricDefId = KafkaMetricDef.commonMetricDefId(metricDef);
            mergedValues.add(commonMetricDefId, partitionMetricValues.valuesFor(metricId));
        }
        boolean replicaIsMissingMetrics = false;
        for (short metricId : replicaMetricValues.metricIds()) {
            KafkaMetricDef metricDef = KafkaMetricDef.replicaMetricDef().metricInfo(metricId).kafkaMetricDef();
            short commonMetricDefId = KafkaMetricDef.commonMetricDefId(metricDef);
            MetricValues currentMetricValues = replicaMetricValues.valuesFor(metricId);
            if (currentMetricValues.length() < mergedValues.length()) {
                double[] currentMetricValuesArr = currentMetricValues.doubleArray();
                double[] extendedArray = Utils.expandArrayFromTheBeginning(currentMetricValuesArr, mergedValues.length());
                currentMetricValues = new MetricValues(extendedArray.length);
                currentMetricValues.add(extendedArray);
                replicaIsMissingMetrics = true;
            } else if (currentMetricValues.length() > mergedValues.length()) {
                String message = "Replica metrics have more windows than partition metrics and this is not supposed to happen.";
                LOG.error(message);
                throw new IllegalStateException(message);
            }
            mergedValues.add(commonMetricDefId, currentMetricValues);
        }
        if (replicaIsMissingMetrics && LOG.isDebugEnabled()) {
            LOG.debug("Replica has fewer metric windows than its partition, filling replica metric windows with 0 values. Replica is: {}", (Object)replicaEntity);
        }
        return new ModifiedAggregatedMetricValues(mergedValues, replicaIsMissingMetrics);
    }

    public static String getRackHandleNull(Node node) {
        return node.rack() == null || node.rack().isEmpty() ? node.host() : node.rack();
    }

    public static ClusterBrokerCapacityConfigResolver.Broker getBroker(Node node) {
        return new ClusterBrokerCapacityConfigResolver.Broker(MonitorUtils.getRackHandleNull(node), node.host(), node.id());
    }

    static Set<Integer> brokersWithReplicas(Cluster cluster) {
        return MonitorUtils.nodesWithReplicas(cluster).stream().map(Node::id).collect(Collectors.toSet());
    }

    static Set<Node> nodesWithReplicas(Cluster cluster) {
        HashSet<Node> allBrokers = new HashSet<Node>();
        for (String topic : cluster.topics()) {
            for (PartitionInfo partition : cluster.partitionsForTopic(topic)) {
                allBrokers.addAll(Arrays.asList(partition.replicas()));
            }
        }
        return allBrokers;
    }

    static Set<Integer> deadBrokersWithReplicas(Cluster cluster) {
        Set<Integer> brokersWithReplicas = MonitorUtils.brokersWithReplicas(cluster);
        cluster.nodes().forEach(node -> brokersWithReplicas.remove(node.id()));
        return brokersWithReplicas;
    }

    static Set<Integer> brokersWithOfflineReplicas(Cluster cluster) {
        HashSet<Integer> brokersWithOfflineReplicas = new HashSet<Integer>();
        for (String topic : cluster.topics()) {
            for (PartitionInfo partition : cluster.partitionsForTopic(topic)) {
                if (partition.leader() == null) continue;
                brokersWithOfflineReplicas.addAll(Arrays.stream(partition.offlineReplicas()).map(Node::id).collect(Collectors.toSet()));
            }
        }
        return brokersWithOfflineReplicas;
    }

    static Map<Integer, Broker.Strategy> consolidateBrokerStrategies(Cluster cluster, Map<Integer, DescribeCellsResponseData.Cell> brokerIdToCell, Set<Integer> ignoredBrokerIds, Map<Integer, Broker.Strategy> preExistingBrokerStatesById) {
        Map<Integer, Broker.Strategy> brokerStatesById = cluster.nodes().stream().collect(Collectors.toMap(Node::id, node -> {
            CellState cellState;
            Broker.Strategy strategy = Broker.Strategy.ALIVE;
            DescribeCellsResponseData.Cell brokerCell = (DescribeCellsResponseData.Cell)brokerIdToCell.get(node.id());
            if (brokerCell != null && (cellState = CellState.toEnum((byte)brokerCell.state())).equals((Object)CellState.EXCLUDED)) {
                strategy = Broker.Strategy.IGNORE;
            }
            return strategy;
        }));
        ignoredBrokerIds.forEach(ignoredBrokerId -> brokerStatesById.put((Integer)ignoredBrokerId, Broker.Strategy.IGNORE));
        MonitorUtils.deadBrokersWithReplicas(cluster).forEach(brokerId -> brokerStatesById.put((Integer)brokerId, Broker.Strategy.DEAD));
        for (Integer brokerId2 : MonitorUtils.brokersWithOfflineReplicas(cluster)) {
            if (brokerStatesById.get(brokerId2) == Broker.Strategy.DEAD) continue;
            brokerStatesById.put(brokerId2, Broker.Strategy.BAD_DISKS);
        }
        brokerStatesById.putAll(preExistingBrokerStatesById);
        return brokerStatesById;
    }

    static Map<TopicPartition, List<SampleExtrapolation>> partitionSampleExtrapolations(Map<PartitionEntity, ValuesAndExtrapolations> valuesAndExtrapolations) {
        HashMap<TopicPartition, List<SampleExtrapolation>> sampleExtrapolations = new HashMap<TopicPartition, List<SampleExtrapolation>>();
        for (Map.Entry<PartitionEntity, ValuesAndExtrapolations> entry : valuesAndExtrapolations.entrySet()) {
            TopicPartition tp = entry.getKey().tp();
            boolean haveExtrapolations = entry.getValue().haveExtrapolations();
            if (!haveExtrapolations) continue;
            Map<Integer, Extrapolation> extrapolations = entry.getValue().extrapolations();
            List extrapolationForPartition = sampleExtrapolations.computeIfAbsent(tp, p -> new ArrayList());
            extrapolations.forEach((t, extrapolation) -> extrapolationForPartition.add(new SampleExtrapolation(t.intValue(), (Extrapolation)((Object)extrapolation))));
        }
        return sampleExtrapolations;
    }

    public static Map<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> getBrokerCapacitiesMap(Cluster cluster, ClusterBrokerCapacityConfigResolver resolver) {
        Set allBrokers = cluster.nodes().stream().map(MonitorUtils::getBroker).collect(Collectors.toSet());
        MonitorUtils.nodesWithReplicas(cluster).forEach(node -> allBrokers.add(MonitorUtils.getBroker(node)));
        return resolver.capacitiesForBrokers(new ArrayList<ClusterBrokerCapacityConfigResolver.Broker>(allBrokers));
    }

    static List<ReplicaEntity> populatePartitionLoad(PartitionInfo partitionInfo, ClusterModel clusterModel, TopicPartition tp, ValuesAndExtrapolations partitionValues, Map<ReplicaEntity, ValuesAndExtrapolations> replicaValuesAndExtrapolations, Map<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> brokerCapacitiesMap) {
        ArrayList<ReplicaEntity> mismatchWindowsForPartitionAndReplica = new ArrayList<ReplicaEntity>();
        for (int index = 0; index < partitionInfo.replicas().length; ++index) {
            Node replica = partitionInfo.replicas()[index];
            ClusterBrokerCapacityConfigResolver.Broker broker = MonitorUtils.getBroker(replica);
            BrokerCapacityInfo brokerCapacity = brokerCapacitiesMap.get(broker);
            clusterModel.handleDeadBroker(broker.rack(), replica.id(), brokerCapacity);
            if (partitionInfo.leader() == null) {
                LOG.warn("Detected offline partition {}-{}, skipping", (Object)partitionInfo.topic(), (Object)partitionInfo.partition());
                continue;
            }
            boolean isLeader = replica.id() == partitionInfo.leader().id();
            boolean isObserver = Arrays.stream(partitionInfo.observers()).anyMatch(observer -> observer.id() == replica.id());
            boolean isOffline = Arrays.stream(partitionInfo.offlineReplicas()).anyMatch(offlineReplica -> offlineReplica.id() == replica.id());
            ReplicaEntity replicaEntity = new ReplicaEntity(partitionInfo, replica.id(), isLeader);
            ValuesAndExtrapolations replicaValues = replicaValuesAndExtrapolations.get(replicaEntity);
            if (replicaValues == null) {
                LOG.debug("skipping replica {} creation in the cluster model", (Object)replicaEntity);
                continue;
            }
            ModifiedAggregatedMetricValues mergedMetricValues = MonitorUtils.getAggregatedMetricValues(partitionValues, replicaValues, replicaEntity);
            if (mergedMetricValues.areModified()) {
                mismatchWindowsForPartitionAndReplica.add(replicaEntity);
            }
            clusterModel.createReplica(broker.rack(), replica.id(), tp, index, isLeader, isOffline, false, isObserver);
            clusterModel.setReplicaLoad(broker.rack(), replica.id(), tp, mergedMetricValues.metricValues(), partitionValues.windows());
        }
        return mismatchWindowsForPartitionAndReplica;
    }

    static final class ModifiedAggregatedMetricValues {
        private AggregatedMetricValues metricValues;
        private final boolean modified;

        public AggregatedMetricValues metricValues() {
            return this.metricValues;
        }

        public ModifiedAggregatedMetricValues(AggregatedMetricValues metricValues, boolean modified) {
            this.metricValues = metricValues;
            this.modified = modified;
        }

        public boolean areModified() {
            return this.modified;
        }

        public void updateMetricValues(AggregatedMetricValues metricValues) {
            this.metricValues = metricValues;
        }
    }
}

