/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling;

import com.linkedin.kafka.cruisecontrol.common.Resource;
import com.linkedin.kafka.cruisecontrol.config.BrokerCapacityInfo;
import com.linkedin.kafka.cruisecontrol.config.ClusterBrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import com.linkedin.kafka.cruisecontrol.monitor.MonitorUtils;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.TrailingFanoutTotalCapacityProcessor;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.BrokerLoad;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerCapacitiesUpdater {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerCapacitiesUpdater.class);
    private final ClusterBrokerCapacityConfigResolver brokerCapacityConfigResolver;
    private final double minimumReportedBrokerWithCapacityMetricsPercentage;
    private final TrailingFanoutTotalCapacityProcessor trailingFanoutTotalCapacityProcessor;
    private final boolean isNetworkCapacityIngestionBeEnabled;
    private final double maxNetworkInCapacityPercentageAllocation;

    public BrokerCapacitiesUpdater(ClusterBrokerCapacityConfigResolver brokerCapacityConfigResolver, TrailingFanoutTotalCapacityProcessor trailingFanoutTotalCapacityProcessor, double minimumReportedBrokerWithCapacityMetricsPercentage, boolean isNetworkCapacityIngestionBeEnabled, double maxNetworkInCapacityPercentageAllocation) {
        if (minimumReportedBrokerWithCapacityMetricsPercentage < 0.0 || minimumReportedBrokerWithCapacityMetricsPercentage > 1.0) {
            throw new IllegalArgumentException("The minimum reported broker with capacity metrics percentage must be in the range (0, 1).");
        }
        if (maxNetworkInCapacityPercentageAllocation < 0.0 || maxNetworkInCapacityPercentageAllocation > 1.0) {
            throw new IllegalArgumentException("The maximum network in capacity percentage allocation must be in the range (0, 1).");
        }
        this.isNetworkCapacityIngestionBeEnabled = isNetworkCapacityIngestionBeEnabled;
        this.maxNetworkInCapacityPercentageAllocation = maxNetworkInCapacityPercentageAllocation;
        this.brokerCapacityConfigResolver = brokerCapacityConfigResolver;
        this.trailingFanoutTotalCapacityProcessor = trailingFanoutTotalCapacityProcessor;
        this.minimumReportedBrokerWithCapacityMetricsPercentage = minimumReportedBrokerWithCapacityMetricsPercentage;
        LOG.info("Broker capacities updater is configured to" + (isNetworkCapacityIngestionBeEnabled ? "" : " not") + " ingest network capacities");
    }

    public ClusterBrokerCapacityConfigResolver brokerCapacityConfigResolver() {
        return this.brokerCapacityConfigResolver;
    }

    public void updateCapacities(Cluster cluster, Map<Integer, BrokerLoad> brokerLoadMap, long timestampMs) {
        Map<ClusterBrokerCapacityConfigResolver.Broker, Map<Resource, Double>> networkCapacities = this.networkCapacities(cluster, brokerLoadMap, timestampMs);
        Map<ClusterBrokerCapacityConfigResolver.Broker, Map<Resource, Double>> diskCapacities = this.miBDiskCapacityPerBroker(cluster, brokerLoadMap);
        HashMap<ClusterBrokerCapacityConfigResolver.Broker, Map<Resource, Double>> mergedCapacities = new HashMap<ClusterBrokerCapacityConfigResolver.Broker, Map<Resource, Double>>(networkCapacities);
        diskCapacities.forEach((broker, diskCapacity) -> mergedCapacities.merge((ClusterBrokerCapacityConfigResolver.Broker)broker, (Map<Resource, Double>)diskCapacity, (network, disk) -> {
            HashMap merged = new HashMap(network);
            merged.putAll(disk);
            return merged;
        }));
        this.brokerCapacityConfigResolver.mergeCapacitiesForBrokers(mergedCapacities);
    }

    private Map<ClusterBrokerCapacityConfigResolver.Broker, Map<Resource, Double>> networkCapacities(Cluster cluster, Map<Integer, BrokerLoad> brokerLoadMap, long timestampMs) {
        if (!this.isNetworkCapacityIngestionBeEnabled || !this.reportedNetworkMetricsCoverTheMinimumRequiredNumber(cluster, brokerLoadMap)) {
            return Collections.emptyMap();
        }
        for (Map.Entry<Integer, BrokerLoad> entry : brokerLoadMap.entrySet()) {
            Integer brokerId = entry.getKey();
            BrokerLoad brokerLoad = entry.getValue();
            if (!brokerLoad.brokerMetricAvailable(RawMetricType.BROKER_PRODUCE_MIRROR_CAPACITY) || !brokerLoad.brokerMetricAvailable(RawMetricType.BROKER_CONSUME_CAPACITY)) continue;
            double produceIn = brokerLoad.brokerMetric(RawMetricType.BROKER_PRODUCE_MIRROR_CAPACITY);
            double consumeOut = brokerLoad.brokerMetric(RawMetricType.BROKER_CONSUME_CAPACITY);
            LOG.info("Supplying produce in: {} and consume out: {} capacities to broker {} for timestamp {}", new Object[]{produceIn, consumeOut, brokerId, timestampMs});
            try {
                this.trailingFanoutTotalCapacityProcessor.supply(brokerId, Resource.PRODUCE_IN, produceIn, timestampMs);
                this.trailingFanoutTotalCapacityProcessor.supply(brokerId, Resource.CONSUME_OUT, consumeOut, timestampMs);
            }
            catch (IllegalArgumentException e) {
                LOG.error("Skipping the network capacity update due to {}. This indicates an major issue/race with the ingestion layer since it is not progressing time forwards.", (Object)e.getMessage());
                return Collections.emptyMap();
            }
        }
        List<Integer> brokerIds = cluster.nodes().stream().map(Node::id).collect(Collectors.toList());
        Map<Integer, Map<Resource, Double>> perBrokerNetworkCapacities = this.trailingFanoutTotalCapacityProcessor.capacitiesForBrokers(brokerIds);
        Map<Resource, Double> networkCapacities = TrailingFanoutTotalCapacityProcessor.averageAllResources(perBrokerNetworkCapacities);
        List<ClusterBrokerCapacityConfigResolver.Broker> brokers = cluster.nodes().stream().map(node -> new ClusterBrokerCapacityConfigResolver.Broker(MonitorUtils.getRackHandleNull(node), node.host(), node.id())).collect(Collectors.toList());
        Map<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> perBrokerCapacitiesMap = this.brokerCapacityConfigResolver.capacitiesForBrokers(brokers);
        Optional<Double> replicationInCapacity = BrokerCapacitiesUpdater.replicationIn(perBrokerCapacitiesMap, perBrokerNetworkCapacities, BrokerCapacitiesUpdater.replicationFactor(cluster), this.maxNetworkInCapacityPercentageAllocation);
        if (replicationInCapacity.isEmpty()) {
            return Collections.emptyMap();
        }
        double produceInMirrorInCapacity = networkCapacities.get((Object)Resource.PRODUCE_IN);
        double consumeOutCapacity = networkCapacities.get((Object)Resource.CONSUME_OUT);
        LOG.info("Calculated average cluster-wide producerInbound capacity as {}, consumerOutbound capacity as {} ad replicationInbound capacity as {}", new Object[]{produceInMirrorInCapacity, consumeOutCapacity, replicationInCapacity.get()});
        return cluster.nodes().stream().collect(Collectors.toMap(node -> new ClusterBrokerCapacityConfigResolver.Broker(MonitorUtils.getRackHandleNull(node), node.host(), node.id()), node -> Map.of(Resource.PRODUCE_IN, produceInMirrorInCapacity, Resource.MIRROR_IN, produceInMirrorInCapacity, Resource.CONSUME_OUT, consumeOutCapacity, Resource.RACK_BASED_CONSUME_OUT, consumeOutCapacity, Resource.RACK_LESS_CONSUME_OUT, consumeOutCapacity, Resource.REPLICATION_IN, (Double)replicationInCapacity.get())));
    }

    private static Optional<Double> replicationIn(Map<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> perBrokerConfigCapacitiesMap, Map<Integer, Map<Resource, Double>> perBrokerTrailingNetworkCapacities, long replicationFactor, double maxNetworkInCapacityPercentageAllocation) {
        if (perBrokerTrailingNetworkCapacities.isEmpty() || perBrokerTrailingNetworkCapacities.values().stream().noneMatch(x -> x.containsKey((Object)Resource.PRODUCE_IN) && x.containsKey((Object)Resource.CONSUME_OUT)) || replicationFactor <= 0L) {
            LOG.error("The per broker network capacities ({}) must contain at least one broker with produce in and consume out capacities, and the replication factor must be greater than 1 (currently {}).", perBrokerTrailingNetworkCapacities, (Object)replicationFactor);
            return Optional.empty();
        }
        Map<Resource, Double> networkCapacities = TrailingFanoutTotalCapacityProcessor.averageAllResources(perBrokerTrailingNetworkCapacities);
        double replicationFactorBasedReplicationInCapacity = networkCapacities.get((Object)Resource.PRODUCE_IN) * (double)(replicationFactor - 1L);
        double networkInCapacity = BrokerCapacitiesUpdater.calculateNetworkInCapacity(perBrokerConfigCapacitiesMap, maxNetworkInCapacityPercentageAllocation);
        double maxProduceInAmongAllBrokers = perBrokerTrailingNetworkCapacities.values().stream().filter(x -> x.containsKey((Object)Resource.PRODUCE_IN)).map(x -> (Double)x.get((Object)Resource.PRODUCE_IN)).max(Double::compareTo).get();
        double totalNetworkInboundBasedCapacityReplicationInCapacity = networkInCapacity - maxProduceInAmongAllBrokers;
        if (Math.floor(networkCapacities.get((Object)Resource.CONSUME_OUT) / networkCapacities.get((Object)Resource.PRODUCE_IN)) > 3.0 && totalNetworkInboundBasedCapacityReplicationInCapacity > replicationFactorBasedReplicationInCapacity) {
            return Optional.of(totalNetworkInboundBasedCapacityReplicationInCapacity);
        }
        return Optional.of(replicationFactorBasedReplicationInCapacity);
    }

    private static double calculateNetworkInCapacity(Map<ClusterBrokerCapacityConfigResolver.Broker, BrokerCapacityInfo> perBrokerCapacitiesMap, double maxNetworkInCapacityPercentageAllocation) {
        List networkInCapacities = perBrokerCapacitiesMap.values().stream().map(x -> x.capacity().get((Object)Resource.NW_IN)).collect(Collectors.toList());
        return networkInCapacities.stream().mapToDouble(Double::doubleValue).min().orElse(0.0) * maxNetworkInCapacityPercentageAllocation;
    }

    private boolean reportedNetworkMetricsCoverTheMinimumRequiredNumber(Cluster cluster, Map<Integer, BrokerLoad> brokerLoadMap) {
        Set brokerIdsWithNetworkCapacityMetrics = brokerLoadMap.entrySet().stream().filter(brokerLoad -> ((BrokerLoad)brokerLoad.getValue()).brokerMetricAvailable(RawMetricType.BROKER_PRODUCE_MIRROR_CAPACITY) && ((BrokerLoad)brokerLoad.getValue()).brokerMetricAvailable(RawMetricType.BROKER_CONSUME_CAPACITY)).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (brokerIdsWithNetworkCapacityMetrics.size() < cluster.nodes().size()) {
            List brokerIdsWithoutCapacityMetrics = cluster.nodes().stream().map(Node::id).filter(id -> !brokerIdsWithNetworkCapacityMetrics.contains(id)).collect(Collectors.toList());
            double availableBrokersPercentage = (double)brokerIdsWithNetworkCapacityMetrics.size() / (double)cluster.nodes().size();
            if (availableBrokersPercentage < this.minimumReportedBrokerWithCapacityMetricsPercentage) {
                LOG.warn("Only ({}/{}) {}% of the brokers in the cluster have all network capacity metrics available. Skipping network capacity update. Brokers without network capacity metrics: {}", new Object[]{brokerIdsWithNetworkCapacityMetrics.size(), cluster.nodes().size(), Math.round(availableBrokersPercentage * 100.0), brokerIdsWithoutCapacityMetrics});
                return false;
            }
            LOG.warn("Only {}% of the brokers in the cluster have produce and consume network capacity metrics available. If this type of miss persists in multiple subsequent rounds, it will lead to fanout ratio that the customer may not expect. Brokers without network capacity metrics: {}", (Object)Math.round(availableBrokersPercentage * 100.0), brokerIdsWithoutCapacityMetrics);
        }
        return true;
    }

    private Map<ClusterBrokerCapacityConfigResolver.Broker, Map<Resource, Double>> miBDiskCapacityPerBroker(Cluster cluster, Map<Integer, BrokerLoad> brokerLoadMap) {
        return cluster.nodes().stream().filter(node -> brokerLoadMap.get(node.id()) != null && ((BrokerLoad)brokerLoadMap.get(node.id())).brokerMetricAvailable(RawMetricType.BROKER_DISK_CAPACITY)).collect(Collectors.toMap(node -> new ClusterBrokerCapacityConfigResolver.Broker(MonitorUtils.getRackHandleNull(node), node.host(), node.id()), node -> Collections.singletonMap(Resource.DISK, ((BrokerLoad)brokerLoadMap.get(node.id())).brokerMetric(RawMetricType.BROKER_DISK_CAPACITY) / 1048576.0)));
    }

    private static long replicationFactor(Cluster cluster) {
        return Math.round(cluster.internalTopics().stream().map(topicName -> cluster.partitionsForTopic(topicName).stream().findFirst()).filter(Optional::isPresent).mapToInt(x -> ((PartitionInfo)x.get()).replicas().length).average().orElse(3.0));
    }
}

