/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.CruiseControlMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.PartitionMetric;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.RawMetricType;
import com.linkedin.kafka.cruisecontrol.metricsreporter.metric.TopicMetric;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.HolderUtils;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.RawMetricsHolder;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ValueHolder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerLoad {
    private static final Logger LOG = LoggerFactory.getLogger(BrokerLoad.class);
    private static final double MAX_ALLOWED_MISSING_PARTITION_METRIC_PERCENT = 0.05;
    private static final double MAX_ALLOWED_MISSING_TOPIC_METRIC_PERCENT = 0.05;
    private static final List<RawMetricType> MISSING_VALUE_ALLOWED_BROKER_RAW_METRIC_TYPES = Arrays.asList(RawMetricType.BROKER_FOLLOWER_FETCH_REQUEST_RATE, RawMetricType.BROKER_PRODUCE_REQUEST_RATE, RawMetricType.BROKER_CONSUMER_FETCH_REQUEST_RATE);
    private final RawMetricsHolder brokerMetrics;
    private final Map<String, RawMetricsHolder> topicMetrics;
    private final Map<TopicPartition, RawMetricsHolder> partitionMetrics;
    private final Set<String> topicsWithPartitionSizeReported = new HashSet<String>();

    public BrokerLoad() {
        this.brokerMetrics = new RawMetricsHolder();
        this.topicMetrics = new HashMap<String, RawMetricsHolder>();
        this.partitionMetrics = new HashMap<TopicPartition, RawMetricsHolder>();
    }

    public void recordMetric(CruiseControlMetric ccm) {
        RawMetricType rawMetricType = ccm.rawMetricType();
        switch (rawMetricType.metricScope()) {
            case BROKER: {
                this.brokerMetrics.recordCruiseControlMetric(ccm);
                break;
            }
            case TOPIC: {
                TopicMetric tm = (TopicMetric)ccm;
                this.topicMetrics.computeIfAbsent(tm.topic(), t -> new RawMetricsHolder()).recordCruiseControlMetric(ccm);
                break;
            }
            case PARTITION: {
                PartitionMetric pm = (PartitionMetric)ccm;
                this.partitionMetrics.computeIfAbsent(new TopicPartition(pm.topic(), pm.partition()), tp -> new RawMetricsHolder()).recordCruiseControlMetric(ccm);
                this.topicsWithPartitionSizeReported.add(pm.topic());
                break;
            }
            default: {
                throw new IllegalStateException(String.format("Should never be here. Unrecognized metric scope %s", new Object[]{rawMetricType.metricScope()}));
            }
        }
    }

    public boolean topicMetricsAvailable(String topic) {
        return this.topicsWithPartitionSizeReported.contains(topic);
    }

    public boolean brokerMetricAvailable(RawMetricType rawMetricType) {
        return this.brokerMetrics.metricValue(rawMetricType) != null;
    }

    public double brokerMetric(RawMetricType rawMetricType) {
        HolderUtils.sanityCheckMetricScope(rawMetricType, RawMetricType.MetricScope.BROKER);
        ValueHolder valueHolder = this.brokerMetrics.metricValue(rawMetricType);
        if (valueHolder == null) {
            throw new IllegalArgumentException(String.format("Broker metric %s does not exist.", new Object[]{rawMetricType}));
        }
        return rawMetricType.convertUnit(valueHolder.value());
    }

    public double topicMetrics(String topic, RawMetricType rawMetricType) {
        return this.topicMetrics(topic, rawMetricType, true);
    }

    public double topicMetrics(String topic, RawMetricType rawMetricType, boolean convertUnit) {
        HolderUtils.sanityCheckMetricScope(rawMetricType, RawMetricType.MetricScope.TOPIC);
        if (!this.topicMetricsAvailable(topic)) {
            throw new IllegalArgumentException(String.format("Topic metric %s does not exist for topic name %s.", new Object[]{rawMetricType, topic}));
        }
        RawMetricsHolder rawMetricsHolder = this.topicMetrics.get(topic);
        if (rawMetricsHolder == null || rawMetricsHolder.metricValue(rawMetricType) == null) {
            LOG.debug("Topic metric " + String.valueOf((Object)rawMetricType) + " is not available for topic " + topic);
            return 0.0;
        }
        double rawMetricValue = rawMetricsHolder.metricValue(rawMetricType).value();
        return convertUnit ? rawMetricType.convertUnit(rawMetricValue) : rawMetricValue;
    }

    public void setTopicMetrics(String topic, RawMetricType rawMetricType, double newValue, long time) {
        HolderUtils.sanityCheckMetricScope(rawMetricType, RawMetricType.MetricScope.TOPIC);
        RawMetricsHolder rawMetricsHolder = this.topicMetrics.computeIfAbsent(topic, t -> new RawMetricsHolder());
        rawMetricsHolder.setRawMetricValue(rawMetricType, newValue, time);
    }

    public double partitionMetric(String topic, int partition, RawMetricType rawMetricType) {
        HolderUtils.sanityCheckMetricScope(rawMetricType, RawMetricType.MetricScope.PARTITION);
        RawMetricsHolder metricsHolder = this.partitionMetrics.get(new TopicPartition(topic, partition));
        if (metricsHolder == null || metricsHolder.metricValue(rawMetricType) == null) {
            throw new IllegalArgumentException(String.format("Partition metric %s does not exist for topic %s and partition %d.", new Object[]{rawMetricType, topic, partition}));
        }
        return rawMetricType.convertUnit(metricsHolder.metricValue(rawMetricType).value());
    }

    public void prepareBrokerMetrics(Cluster cluster, int brokerId, long time) {
        boolean enoughTopicPartitionMetrics = this.enoughTopicPartitionMetrics(cluster, brokerId);
        if (enoughTopicPartitionMetrics) {
            HashMap sumOfTopicMetrics = new HashMap();
            HolderUtils.METRIC_TYPES_TO_SUM.keySet().forEach(type -> this.topicsWithPartitionSizeReported.forEach(topic -> {
                double value = this.topicMetrics((String)topic, (RawMetricType)((Object)type), false);
                sumOfTopicMetrics.compute(type, (t, v) -> (v == null ? 0.0 : v) + value);
            }));
            for (Map.Entry entry : sumOfTopicMetrics.entrySet()) {
                RawMetricType rawTopicMetricType = (RawMetricType)((Object)entry.getKey());
                double value = (Double)entry.getValue();
                this.brokerMetrics.setRawMetricValue(HolderUtils.METRIC_TYPES_TO_SUM.get((Object)rawTopicMetricType), value, time);
            }
        } else {
            LOG.warn("Not enough topic metrics for broker {} as part of processing the metrics for time {} ({}).", new Object[]{brokerId, KafkaCruiseControlUtils.toTimeStringOrNonePlaceholder(time), time});
        }
        this.setDefaultMissingBrokerMetricValueWhenPossible(cluster, brokerId, time);
    }

    static boolean canBrokerMetricBeBackfilledWithTheDefaultValue(Cluster cluster, int brokerId, RawMetricType rawMetricType) {
        switch (rawMetricType) {
            case BROKER_FOLLOWER_FETCH_REQUEST_RATE: {
                for (PartitionInfo partitionInfo : cluster.partitionsForNode(brokerId)) {
                    if (partitionInfo.replicas().length <= 1 || partitionInfo.leader() == null || partitionInfo.leader().id() != brokerId) continue;
                    return false;
                }
                return true;
            }
            case BROKER_PRODUCE_REQUEST_RATE: 
            case BROKER_CONSUMER_FETCH_REQUEST_RATE: {
                return true;
            }
        }
        return false;
    }

    private void setDefaultMissingBrokerMetricValueWhenPossible(Cluster cluster, int brokerId, long time) {
        for (RawMetricType rawBrokerMetricType : MISSING_VALUE_ALLOWED_BROKER_RAW_METRIC_TYPES) {
            if (this.brokerMetrics.metricValue(rawBrokerMetricType) != null || !BrokerLoad.canBrokerMetricBeBackfilledWithTheDefaultValue(cluster, brokerId, rawBrokerMetricType)) continue;
            this.brokerMetrics.setRawMetricValue(rawBrokerMetricType, 0.0, time);
        }
    }

    private boolean enoughTopicPartitionMetrics(Cluster cluster, int brokerId) {
        boolean result;
        HashSet missingTopics = new HashSet();
        HashSet topicsInBroker = new HashSet();
        AtomicInteger missingPartitions = new AtomicInteger(0);
        List leaderPartitionsInNode = cluster.partitionsForNode(brokerId);
        if (leaderPartitionsInNode.isEmpty()) {
            return true;
        }
        leaderPartitionsInNode.forEach(info -> {
            String topic = info.topic();
            topicsInBroker.add(topic);
            if (!this.topicsWithPartitionSizeReported.contains(topic)) {
                missingPartitions.incrementAndGet();
                missingTopics.add(topic);
            }
        });
        boolean bl = result = (double)missingTopics.size() / (double)topicsInBroker.size() <= 0.05 && (double)missingPartitions.get() / (double)cluster.partitionsForNode(brokerId).size() <= 0.05;
        if (!result) {
            LOG.warn("Broker {} is missing {}/{} topics metrics and {}/{} leader partition metrics. Missing leader topics: {}.", new Object[]{brokerId, missingTopics.size(), topicsInBroker.size(), missingPartitions.get(), cluster.partitionsForNode(brokerId).size(), missingTopics});
        }
        return result;
    }
}

