/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.sampling.holder;

import com.linkedin.kafka.cruisecontrol.monitor.sampling.holder.ValueHolder;

class ValueAndCount
implements ValueHolder {
    static final float NO_RECORD_EXISTS = -1.0f;
    private float value = 0.0f;
    private int count = 0;

    ValueAndCount() {
    }

    @Override
    public void recordValue(double value, long time) {
        this.value += (float)value;
        ++this.count;
    }

    @Override
    public void reset() {
        this.value = 0.0f;
        this.count = 0;
    }

    @Override
    public double value() {
        return this.count == 0 ? 0.0 : (double)(this.value / (float)this.count);
    }

    @Override
    public double value(boolean assertNonZeroCount) {
        return this.count == 0 ? (assertNonZeroCount ? -1.0 : 0.0) : (double)(this.value / (float)this.count);
    }
}

