/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.kafka.cruisecontrol.monitor.task;

import com.linkedin.cruisecontrol.monitor.sampling.aggregator.MetricsWindow;
import com.linkedin.cruisecontrol.monitor.sampling.aggregator.WindowCalculationHelper;
import com.linkedin.kafka.cruisecontrol.KafkaCruiseControlUtils;
import com.linkedin.kafka.cruisecontrol.common.MetadataClient;
import com.linkedin.kafka.cruisecontrol.config.ClusterBrokerCapacityConfigResolver;
import com.linkedin.kafka.cruisecontrol.config.KafkaCruiseControlConfig;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.MetricFetcherManager;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.SamplingOptions;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaPartitionMetricSampleAggregator;
import com.linkedin.kafka.cruisecontrol.monitor.sampling.aggregator.KafkaReplicaMetricSampleAggregator;
import com.yammer.metrics.core.Meter;
import io.confluent.databalancer.metrics.CommonMetrics;
import io.confluent.databalancer.metrics.GeneralSBCMetricsRegistry;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetricSamplingTask
extends KafkaThread {
    private static final Logger LOG = LoggerFactory.getLogger(MetricSamplingTask.class);
    private static final String THREAD_NAME = "SBK_MetricSampling";
    public static final String SAMPLING_LOOP_FAILURE_RATE_METRIC_NAME = "metric-sampling-loop-failure-rate";
    public static final String SAMPLING_LOOP_SUCCESS_RATE_METRIC_NAME = "metric-sampling-loop-success-rate";
    public static final String SAMPLING_LOOP_SKIPPED_RATE_METRIC_NAME = "metric-sampling-loop-skipped-rate";
    private final GeneralSBCMetricsRegistry metricRegistry;
    private final MetricFetcherManager metricFetcherManager;
    private final long samplingIntervalMs;
    private volatile MetricSamplingTaskState state;
    private volatile boolean awaitingPauseSampling;
    private volatile String reasonOfLatestPauseOrResume;
    public static final Duration SAMPLING_ERROR_BACKOFF_DURATION = Duration.ofMinutes(1L);
    private Meter samplingFetcherFailureRate;
    private Meter samplingFetcherSkippedRate;
    private Meter samplingFetcherSuccessRate;
    private final SamplingScheduler samplingScheduler;

    public MetricSamplingTask(KafkaCruiseControlConfig config, KafkaReplicaMetricSampleAggregator replicaMetricSampleAggregator, KafkaPartitionMetricSampleAggregator partitionMetricSampleAggregator, MetadataClient metadataClient, Time time, GeneralSBCMetricsRegistry metricRegistry, ClusterBrokerCapacityConfigResolver brokerCapacityConfigResolver) {
        super(THREAD_NAME, false);
        this.metricRegistry = metricRegistry;
        this.metricFetcherManager = new MetricFetcherManager(config, replicaMetricSampleAggregator, partitionMetricSampleAggregator, time, metricRegistry, brokerCapacityConfigResolver, null);
        this.awaitingPauseSampling = false;
        this.reasonOfLatestPauseOrResume = null;
        this.state = MetricSamplingTaskState.NOT_STARTED;
        this.samplingIntervalMs = config.samplingIntervalWindowMs();
        this.samplingScheduler = new SamplingScheduler(metadataClient, this.metricFetcherManager, time, null);
    }

    public MetricSamplingTaskState state() {
        return this.state;
    }

    void configure() {
        this.metricFetcherManager.start();
        this.samplingFetcherFailureRate = this.metricRegistry.newMeter(MetricFetcherManager.class, SAMPLING_LOOP_FAILURE_RATE_METRIC_NAME, "metric-sampling-errors", TimeUnit.SECONDS);
        this.samplingFetcherSuccessRate = this.metricRegistry.newMeter(MetricFetcherManager.class, SAMPLING_LOOP_SUCCESS_RATE_METRIC_NAME, "metric-sampling-runs", TimeUnit.SECONDS);
        this.samplingFetcherSkippedRate = this.metricRegistry.newMeter(MetricFetcherManager.class, SAMPLING_LOOP_SKIPPED_RATE_METRIC_NAME, "metric-sampling-skips", TimeUnit.SECONDS);
        this.state = MetricSamplingTaskState.RUNNING;
    }

    public void run() {
        super.run();
        LOG.info("Starting metric sampling task.");
        this.configure();
        this.samplingScheduler.run();
    }

    public void handleInvalidation(long invalidationTimeMs) {
        this.samplingScheduler.handleWindowInvalidation(invalidationTimeMs);
    }

    public void shutdown() {
        LOG.info("Shutting down metric sampling task.");
        KafkaCruiseControlUtils.executeSilently(this.samplingScheduler, SamplingScheduler::shutdown);
        KafkaCruiseControlUtils.executeSilently(this.metricFetcherManager, MetricFetcherManager::shutdown);
        KafkaCruiseControlUtils.executeSilently(this, Thread::interrupt);
        LOG.info("Metric sampling task shutdown completed.");
    }

    public synchronized void pauseSampling(String reason) {
        boolean wasPausedAlready;
        boolean bl = wasPausedAlready = this.state == MetricSamplingTaskState.PAUSED;
        if (!wasPausedAlready && this.state != MetricSamplingTaskState.RUNNING) {
            this.awaitingPauseSampling = true;
            throw new IllegalStateException("Cannot pause the load monitor because it is in " + String.valueOf((Object)this.state) + " state.");
        }
        this.state = MetricSamplingTaskState.PAUSED;
        if (wasPausedAlready) {
            LOG.info("Pausing the load monitor a second time, the last reason was {} and the latest now is {}.", (Object)this.reasonOfLatestPauseOrResume, (Object)reason);
        } else {
            LOG.info("Pausing metrics sampling due to reason {}", (Object)reason);
        }
        this.awaitingPauseSampling = false;
        this.reasonOfLatestPauseOrResume = reason;
    }

    public synchronized void resumeSampling(String reason) {
        if (this.state != MetricSamplingTaskState.RUNNING && this.state != MetricSamplingTaskState.PAUSED) {
            throw new IllegalStateException("Cannot resume the load monitor because it is in " + String.valueOf((Object)this.state) + " state");
        }
        this.state = MetricSamplingTaskState.RUNNING;
        this.reasonOfLatestPauseOrResume = reason;
    }

    public String reasonOfLatestPauseOrResume() {
        return this.reasonOfLatestPauseOrResume;
    }

    public boolean awaitingPauseSampling() {
        return this.awaitingPauseSampling;
    }

    SamplingScheduler samplingScheduler() {
        return this.samplingScheduler;
    }

    public static enum MetricSamplingTaskState {
        NOT_STARTED,
        RUNNING,
        SAMPLING,
        PAUSED;

    }

    class SamplingScheduler {
        private final Time time;
        private final MetadataClient metadataClient;
        private final MetricFetcherManager metricFetcherManager;
        private final InterruptedCheck interruptedCheck;
        private volatile boolean shutdownRequested = false;
        private MetricsWindow lastSampledWindow;
        final SamplingAwakeCondition samplingAwakeCondition;
        private volatile long baseTimeMs;
        private volatile long resumptionTimestampMs;

        SamplingScheduler(MetadataClient metadataClient, MetricFetcherManager metricFetcherManager, Time time, InterruptedCheck interruptedCheck) {
            this.time = time;
            this.metadataClient = metadataClient;
            this.metricFetcherManager = metricFetcherManager;
            this.lastSampledWindow = MetricsWindow.empty(MetricSamplingTask.this.samplingIntervalMs);
            this.interruptedCheck = Objects.requireNonNullElseGet(interruptedCheck, () -> () -> {
                SamplingScheduler samplingScheduler = this;
                synchronized (samplingScheduler) {
                    return this.shutdownRequested;
                }
            });
            this.samplingAwakeCondition = new SamplingAwakeCondition();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.interruptedCheck.isInterrupted()) {
                try {
                    long nowMs = this.time.milliseconds();
                    long deadlineMs = nowMs + MetricSamplingTask.this.samplingIntervalMs;
                    SamplingStep currentStep = this.takeNextStep(nowMs, this.computeTargetWindow(nowMs, MetricSamplingTask.this.samplingIntervalMs, this.lastSampledWindow));
                    if (currentStep.nextSamplingStep == NextSamplingStep.SKIP_SAMPLING) {
                        ActionPostWait nextStep = this.waitForDuration(currentStep.sleepDuration.toMillis());
                        if (nextStep == ActionPostWait.SHUTDOWN) {
                            LOG.info("Shutting down sampling scheduler.");
                            return;
                        }
                        MetricSamplingTask.this.samplingFetcherSkippedRate.mark();
                        continue;
                    }
                    if (currentStep.nextSamplingStep == NextSamplingStep.SAMPLE_AFTER) {
                        ActionPostWait nextStep = this.waitForDuration(currentStep.sleepDuration.toMillis());
                        if (nextStep == ActionPostWait.RECOMPUTE_TARGET_WINDOW) continue;
                        if (nextStep == ActionPostWait.SHUTDOWN) {
                            LOG.info("Shutting down sampling scheduler.");
                            return;
                        }
                    }
                    LOG.info("Beginning to sample {}", (Object)currentStep.targetWindow);
                    boolean successfullySampled = this.sample(currentStep.targetWindow, nowMs, deadlineMs);
                    LOG.debug("Finished sampling {}", (Object)currentStep.targetWindow);
                    if (!successfullySampled) continue;
                    this.lastSampledWindow = currentStep.targetWindow;
                    MetricSamplingTask.this.samplingFetcherSuccessRate.mark();
                }
                catch (Throwable e) {
                    LOG.error("Unexpected exception caught during metric sampling", e);
                    CommonMetrics.recordFatalError(MetricSamplingTask.class);
                    MetricSamplingTask.this.samplingFetcherFailureRate.mark();
                    ActionPostWait nextStep = this.waitForDuration(SAMPLING_ERROR_BACKOFF_DURATION.toMillis());
                    if (nextStep != ActionPostWait.SHUTDOWN) continue;
                    LOG.info("Shutting down sampling scheduler.");
                    return;
                }
                finally {
                    if (MetricSamplingTask.this.state != MetricSamplingTaskState.SAMPLING) continue;
                    MetricSamplingTask.this.state = MetricSamplingTaskState.RUNNING;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ActionPostWait waitForDuration(long timeoutDurationMs) {
            try {
                if (this.shutdownRequested) {
                    return ActionPostWait.SHUTDOWN;
                }
                long currentTimeMs = this.time.milliseconds();
                if (currentTimeMs < this.resumptionTimestampMs && this.resumptionTimestampMs < currentTimeMs + timeoutDurationMs) {
                    return ActionPostWait.RECOMPUTE_TARGET_WINDOW;
                }
                long nowMs = this.time.hiResClockMs();
                AwakeningReason awakeningReason = this.awaitForInterruptOrTimeout(nowMs + timeoutDurationMs);
                switch (awakeningReason.ordinal()) {
                    case 0: {
                        LOG.trace("Awakened task due to timeout : {}", (Object)timeoutDurationMs);
                        SamplingScheduler samplingScheduler = this;
                        synchronized (samplingScheduler) {
                            if (MetricSamplingTask.this.state == MetricSamplingTaskState.PAUSED || this.time.milliseconds() < this.resumptionTimestampMs) {
                                return ActionPostWait.RECOMPUTE_TARGET_WINDOW;
                            }
                            if (MetricSamplingTask.this.state == MetricSamplingTaskState.RUNNING) {
                                MetricSamplingTask.this.state = MetricSamplingTaskState.SAMPLING;
                            }
                            return ActionPostWait.SAMPLE_PRE_COMPUTED_WINDOW;
                        }
                    }
                    case 1: {
                        LOG.info("Received shutdown request while sleeping.");
                        return ActionPostWait.SHUTDOWN;
                    }
                    case 2: {
                        LOG.debug("Invalidation happened during sleep.");
                        return ActionPostWait.RECOMPUTE_TARGET_WINDOW;
                    }
                }
                throw new IllegalStateException("Unexpected signal found during sleep.");
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        AwakeningReason awaitForInterruptOrTimeout(long waitPeriodEndMs) throws InterruptedException {
            long sleepDuration = waitPeriodEndMs - this.time.hiResClockMs();
            LOG.debug("SamplingScheduler is going to sleep : {}({}) ", (Object)KafkaCruiseControlUtils.toTimeString(sleepDuration), (Object)sleepDuration);
            SamplingAwakeCondition samplingAwakeCondition = this.samplingAwakeCondition;
            synchronized (samplingAwakeCondition) {
                long remainingWaitDuration = waitPeriodEndMs - this.time.hiResClockMs();
                while (remainingWaitDuration > 0L) {
                    AwakeningReason awakeningReason = this.samplingAwakeCondition.await(waitPeriodEndMs - this.time.hiResClockMs());
                    if (awakeningReason != null) {
                        return awakeningReason;
                    }
                    remainingWaitDuration = waitPeriodEndMs - this.time.hiResClockMs();
                }
            }
            return AwakeningReason.SLEEP_DURATION_COMPLETED;
        }

        public synchronized void handleWindowInvalidation(long invalidationTimeMs) {
            this.resumptionTimestampMs = WindowCalculationHelper.currentWindow(invalidationTimeMs, MetricSamplingTask.this.samplingIntervalMs, invalidationTimeMs).endMsInclusive();
            this.baseTimeMs = invalidationTimeMs;
            this.samplingAwakeCondition.signal(AwakeningReason.INVALIDATED);
        }

        boolean sample(MetricsWindow targetWindow, long nowMs, long deadlineMs) {
            long now = nowMs;
            long deadlineIntervalMs = Math.max(0L, deadlineMs - nowMs);
            long startMs = targetWindow.startMs();
            long endMs = targetWindow.endMsInclusive();
            while (!this.shutdownRequested) {
                Cluster latestCluster = this.metadataClient.maybeRefreshMetadata().cluster();
                SamplingOptions samplingOptions = new SamplingOptions(startMs, endMs, latestCluster);
                boolean hasSamplingError = this.metricFetcherManager.fetchSamples(samplingOptions, deadlineMs - now);
                now = this.time.milliseconds();
                if (!hasSamplingError) {
                    LOG.info("Successfully finished metric sampling for time period {} to {} ({} to {}).", new Object[]{KafkaCruiseControlUtils.toTimeString(startMs), KafkaCruiseControlUtils.toTimeString(endMs), startMs, endMs});
                    return true;
                }
                if (now > deadlineMs) {
                    LOG.warn("Sampling did not finish in {} ms, skipping this sampling interval of window {}.", (Object)deadlineIntervalMs, (Object)targetWindow);
                    return false;
                }
                if (this.shutdownRequested) continue;
                LOG.info("Retrying sampling interval of window {}", (Object)targetWindow);
            }
            return false;
        }

        SamplingStep takeNextStep(long nowMs, WindowSamplingInstruction windowInstruction) {
            if (MetricSamplingTask.this.awaitingPauseSampling()) {
                String reason = MetricSamplingTask.this.reasonOfLatestPauseOrResume() == null ? "<unknown reason>" : MetricSamplingTask.this.reasonOfLatestPauseOrResume();
                LOG.info("The SamplingScheduler is awaiting pausation (reason given: {}). Sleeping for {}...", (Object)reason, (Object)SAMPLING_ERROR_BACKOFF_DURATION);
                return new SamplingStep(NextSamplingStep.SKIP_SAMPLING, windowInstruction, SAMPLING_ERROR_BACKOFF_DURATION);
            }
            if (windowInstruction.samplingInstruction == NextWindowStep.SLEEP_UNTIL) {
                long sleepIntervalMs = Math.max(windowInstruction.timeMs - nowMs, 0L);
                LOG.info("Sleeping the SamplingScheduler until {} (for {}ms) as instructed due to reason {}", new Object[]{KafkaCruiseControlUtils.toTimeString(windowInstruction.timeMs), sleepIntervalMs, windowInstruction.reason});
                return new SamplingStep(NextSamplingStep.SAMPLE_AFTER, windowInstruction, Duration.ofMillis(sleepIntervalMs));
            }
            if (windowInstruction.samplingInstruction != NextWindowStep.RUN_NOW) {
                LOG.warn("Computed an unknown next step {} in the sampling task. Skipping it and sleeping for the backoff duration {}.", (Object)windowInstruction.samplingInstruction, (Object)SAMPLING_ERROR_BACKOFF_DURATION);
                return new SamplingStep(NextSamplingStep.SKIP_SAMPLING, windowInstruction, SAMPLING_ERROR_BACKOFF_DURATION);
            }
            if (MetricSamplingTask.this.state != MetricSamplingTaskState.RUNNING) {
                long resumeTimeMs = windowInstruction.targetWindow.nextWindow().endMsInclusive();
                long sleepIntervalMs = Math.max(resumeTimeMs - nowMs, 0L);
                LOG.info("Could not transition the SamplingScheduler to state {}. Current state is {}. Sleeping until we'd be ready for the next sampling interval {} (for {}ms)...", new Object[]{MetricSamplingTaskState.SAMPLING, MetricSamplingTask.this.state(), KafkaCruiseControlUtils.toTimeString(windowInstruction.timeMs), sleepIntervalMs});
                return new SamplingStep(NextSamplingStep.SKIP_SAMPLING, windowInstruction, Duration.ofMillis(sleepIntervalMs));
            }
            MetricSamplingTask.this.state = MetricSamplingTaskState.SAMPLING;
            return new SamplingStep(NextSamplingStep.SAMPLE_NOW, windowInstruction, Duration.ZERO);
        }

        synchronized WindowSamplingInstruction computeTargetWindow(long nowMs, long windowMs, MetricsWindow lastSampledWindow) {
            if (windowMs != lastSampledWindow.sizeMs()) {
                throw new IllegalArgumentException(String.format("Inconsistent window sizes - lastSampledWindow: %s, windowMs: %d", lastSampledWindow, windowMs));
            }
            long normalizedTargetWindowTimestamp = Math.max(this.resumptionTimestampMs, nowMs);
            MetricsWindow currentWindow = WindowCalculationHelper.currentWindow(normalizedTargetWindowTimestamp, windowMs, this.baseTimeMs);
            if (currentWindow.endMsInclusive() <= lastSampledWindow.endMsInclusive()) {
                MetricsWindow nextTargetWindow = lastSampledWindow.nextWindow();
                long sleepResumeTime = nextTargetWindow.endMsInclusive();
                LOG.warn("Tried to sample a window that we've already sampled. This is unexpected - might it be due to clock skew? Sleeping until the end of the next window we haven't sampled...  (nowMs: {}({}), normalizedTargetWindowTimestamp:{}({}) currentWindow: {}, lastSampledWindow: {}), next window: {}", new Object[]{nowMs, KafkaCruiseControlUtils.toTimeString(nowMs), normalizedTargetWindowTimestamp, KafkaCruiseControlUtils.toTimeString(normalizedTargetWindowTimestamp), currentWindow, lastSampledWindow, nextTargetWindow});
                return new WindowSamplingInstruction(NextWindowStep.SLEEP_UNTIL, nextTargetWindow, sleepResumeTime, String.format("The SamplingScheduler's current window is either behind or exactly at what it has already sampled. The SamplingScheduler should sleep until the window after the last sampled window passes. (currentWindow: %s, last sampled window: %s, target window after that: %s)", currentWindow.toConciseString(), lastSampledWindow.toConciseString(), nextTargetWindow.toConciseString()));
            }
            MetricsWindow lastWindow = currentWindow.previousWindow();
            MetricsWindow nextTargetWindow = currentWindow;
            long sampleResumeMs = nextTargetWindow.endMsInclusive();
            if (lastWindow.endMsInclusive() == lastSampledWindow.endMsInclusive()) {
                return new WindowSamplingInstruction(NextWindowStep.SLEEP_UNTIL, nextTargetWindow, sampleResumeMs, String.format("The last eligible window for sampling was already sampled. Sleeping until the end of the current window...  (lastSampledWindow: %s, currentWindow: %s)", lastSampledWindow.toConciseString(), currentWindow.toConciseString()));
            }
            if (lastWindow.endMsInclusive() < lastSampledWindow.endMsInclusive()) {
                String msg = String.format("The previous window is older than the last sampled window. This code path should be impossible to enter and therefore indicates a bug, since we already checked the current window against the last sampled-at window. Sleeping until the end of the current window...  (lastWindow: %s, lastSampledWindow: %s, currentWindow: %s)", lastWindow.toConciseString(), lastSampledWindow.toConciseString(), currentWindow.toConciseString());
                LOG.warn(msg);
                return new WindowSamplingInstruction(NextWindowStep.SLEEP_UNTIL, nextTargetWindow, sampleResumeMs, msg);
            }
            if (nowMs < this.resumptionTimestampMs) {
                return new WindowSamplingInstruction(NextWindowStep.SLEEP_UNTIL, nextTargetWindow, sampleResumeMs, String.format("There has been an invalidation of metrics. Sleeping until the end of the end of the current window...  (lastWindow: %s, currentWindow: %s, lastSampledWindow: %s, nowMs: %d (%s) normalizedTargetWindowTimestamp: %d (%s))", lastWindow, currentWindow, lastSampledWindow, nowMs, KafkaCruiseControlUtils.toTimeString(nowMs), normalizedTargetWindowTimestamp, KafkaCruiseControlUtils.toTimeString(normalizedTargetWindowTimestamp)));
            }
            return new WindowSamplingInstruction(NextWindowStep.RUN_NOW, lastWindow, sampleResumeMs, String.format("The last window is eligible for sampling. Sampling now and resuming at the end of the current window...  (lastWindow: %s, currentWindow: %s, nowMs: %d (%s) normalizedTargetWindowTimestamp: %d (%s))", lastWindow, currentWindow, nowMs, KafkaCruiseControlUtils.toTimeString(nowMs), normalizedTargetWindowTimestamp, KafkaCruiseControlUtils.toTimeString(normalizedTargetWindowTimestamp)));
        }

        public synchronized void shutdown() {
            this.shutdownRequested = true;
            this.samplingAwakeCondition.signal(AwakeningReason.SHUTDOWN);
        }

        long resumptionTimestampMs() {
            return this.resumptionTimestampMs;
        }

        void resumptionTimestampMs(long sleepDurationPostInvalidationMs) {
            this.resumptionTimestampMs = sleepDurationPostInvalidationMs;
        }

        void baseTimestamp(long invalidationTimestamp) {
            this.baseTimeMs = invalidationTimestamp;
        }
    }

    static interface InterruptedCheck {
        public boolean isInterrupted();
    }

    @Immutable
    public static class WindowSamplingInstruction {
        public final NextWindowStep samplingInstruction;
        public final MetricsWindow targetWindow;
        public final long timeMs;
        public final String reason;

        public WindowSamplingInstruction(NextWindowStep samplingInstruction, MetricsWindow targetWindow, long timeMs, String reason) {
            this.samplingInstruction = samplingInstruction;
            this.timeMs = timeMs;
            this.targetWindow = targetWindow;
            this.reason = reason;
        }
    }

    public class SamplingStep {
        public final Duration sleepDuration;
        public final NextSamplingStep nextSamplingStep;
        public final MetricsWindow targetWindow;

        public SamplingStep(NextSamplingStep nextSamplingStep, WindowSamplingInstruction wis, Duration sleepDuration) {
            this.targetWindow = wis.targetWindow;
            this.nextSamplingStep = nextSamplingStep;
            this.sleepDuration = sleepDuration;
        }

        public String toString() {
            return "SamplingStep{sleepDuration=" + String.valueOf(this.sleepDuration) + ", nextSamplingStep=" + String.valueOf((Object)this.nextSamplingStep) + ", targetWindow=" + String.valueOf(this.targetWindow) + "}";
        }
    }

    static class SamplingAwakeCondition {
        AwakeningReason awakeningReason;

        SamplingAwakeCondition() {
        }

        synchronized void signal(AwakeningReason reason) {
            this.awakeningReason = reason;
            this.notify();
        }

        synchronized AwakeningReason await(long waitPeriodEndMs) throws InterruptedException {
            this.awakeningReason = null;
            this.wait(waitPeriodEndMs);
            return this.awakeningReason;
        }
    }

    public static enum NextSamplingStep {
        SAMPLE_AFTER,
        SKIP_SAMPLING,
        SAMPLE_NOW;

    }

    public static enum NextWindowStep {
        SLEEP_UNTIL,
        RUN_NOW;

    }

    public static enum ActionPostWait {
        RECOMPUTE_TARGET_WINDOW,
        SHUTDOWN,
        SAMPLE_PRE_COMPUTED_WINDOW;

    }

    public static enum AwakeningReason {
        SLEEP_DURATION_COMPLETED,
        SHUTDOWN,
        INVALIDATED;

    }
}

