/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kafka.common.AliveBrokersMetadata;
import kafka.common.AliveBrokersSnapshot;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.metadata.BrokerRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokersMetadataSnapshot
implements AliveBrokersMetadata {
    private static final Logger LOG = LoggerFactory.getLogger(BrokersMetadataSnapshot.class);
    private final AliveBrokersSnapshot aliveBrokersSnapshot;
    private final Optional<Map<Integer, BrokerRegistration>> brokerRegistrationOptional;
    private final Set<Integer> replicaExclusions;
    private final Set<Integer> degradedBrokers;

    public static BrokersMetadataSnapshot of(AliveBrokersSnapshot aliveBrokersSnapshot) {
        return new BrokersMetadataSnapshot(aliveBrokersSnapshot, null, aliveBrokersSnapshot.replicaExclusions());
    }

    public static BrokersMetadataSnapshot of(Map<Integer, BrokerRegistration> brokerRegistrations, Set<Integer> replicaExclusions) {
        return new BrokersMetadataSnapshot(AliveBrokersSnapshot.EMPTY_SNAPSHOT, new HashMap<Integer, BrokerRegistration>(brokerRegistrations), replicaExclusions);
    }

    private BrokersMetadataSnapshot(AliveBrokersSnapshot aliveBrokersSnapshot, Map<Integer, BrokerRegistration> brokerRegistrations, Set<Integer> replicaExclusions) {
        this.aliveBrokersSnapshot = aliveBrokersSnapshot;
        this.brokerRegistrationOptional = Optional.ofNullable(brokerRegistrations);
        this.replicaExclusions = replicaExclusions;
        this.degradedBrokers = this.degradedBrokersFromMetadata();
    }

    private Set<Integer> degradedBrokersFromMetadata() {
        if (this.brokerRegistrationOptional.isPresent()) {
            return this.brokerRegistrationOptional.get().values().stream().filter(r -> r.degradedComponents() != null && !r.degradedComponents().isEmpty()).map(BrokerRegistration::id).collect(Collectors.toSet());
        }
        return this.aliveBrokersSnapshot.degradedBrokers();
    }

    public Set<Integer> aliveBrokers() {
        return this.brokerRegistrationOptional.map(registrations -> registrations.entrySet().stream().filter(brokerRegistrationEntry -> !((BrokerRegistration)brokerRegistrationEntry.getValue()).fenced()).map(Map.Entry::getKey).collect(Collectors.toSet())).orElseGet(() -> this.aliveBrokersSnapshot.aliveBrokers());
    }

    public Set<Integer> replicaExclusions() {
        return this.replicaExclusions;
    }

    public Set<Integer> degradedBrokers() {
        return this.degradedBrokers;
    }

    public Optional<Long> epochFor(int brokerId) {
        if (this.brokerRegistrationOptional.isPresent()) {
            BrokerRegistration registration = this.brokerRegistrationOptional.get().get(brokerId);
            if (registration == null) {
                LOG.info("Could not find registration for broker {} when searching for its epoch", (Object)brokerId);
            } else {
                if (registration.fenced()) {
                    LOG.info("Broker {} is fenced, will not be returning its epoch", (Object)brokerId);
                    return Optional.empty();
                }
                return Optional.of(registration.epoch());
            }
        }
        return this.aliveBrokersSnapshot.epochFor(brokerId);
    }

    public Optional<Endpoint> endpointFor(ListenerName listenerName) {
        if (!this.brokerRegistrationOptional.isPresent()) {
            LOG.info("Could not find an endpoint for listener {} as no broker registrations were present in the snapshot", (Object)listenerName);
            return Optional.empty();
        }
        Map<Integer, BrokerRegistration> registeredBrokers = this.brokerRegistrationOptional.get();
        return registeredBrokers.values().stream().filter(brokerRegistration -> !brokerRegistration.fenced() && brokerRegistration.listeners().containsKey(listenerName.value())).map(brokerRegistration -> (Endpoint)brokerRegistration.listeners().get(listenerName.value())).findFirst();
    }

    public boolean isEmpty() {
        boolean registrationsAreEmpty = this.brokerRegistrationOptional.map(Map::isEmpty).orElse(true);
        boolean snapshotIsEmpty = this.aliveBrokersSnapshot.isEmpty();
        return registrationsAreEmpty && snapshotIsEmpty;
    }
}

