/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.metrics;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.kafka.common.utils.Sanitizer;

public final class DataBalancerMetricsUtils {
    private static final String GROUP = "kafka.databalancer";

    public static Map<String, String> brokerIdMetricTag(int brokerId) {
        HashMap<String, String> brokerIdTag = new HashMap<String, String>();
        brokerIdTag.put("broker", String.valueOf(brokerId));
        return brokerIdTag;
    }

    public static MetricName metricName(Class<?> klass, String name) {
        return DataBalancerMetricsUtils.metricName(GROUP, klass.getSimpleName(), name, Collections.emptyMap());
    }

    public static MetricName metricName(Class<?> klass, String name, Map<String, String> tags) {
        return DataBalancerMetricsUtils.metricName(GROUP, klass.getSimpleName(), name, tags);
    }

    public static MetricName metricName(String group, String type, String name, Map<String, String> tags) {
        Object mbeanName = String.format("%s:type=%s,name=%s", group, type, name);
        String tagsName = DataBalancerMetricsUtils.tagsToMBeanName(tags);
        if (!tagsName.isEmpty()) {
            mbeanName = (String)mbeanName + "," + tagsName;
        }
        return new MetricName(group, type, name, null, (String)mbeanName);
    }

    public static <T> Gauge<T> createGauge(MetricsRegistry metricsRegistry, MetricName metricName, final Supplier<T> valueSupplier) {
        return metricsRegistry.newGauge(metricName, new Gauge<T>(){

            public T value() {
                return valueSupplier.get();
            }
        });
    }

    private static String tagsToMBeanName(Map<String, String> tags) {
        List tagsList = tags.entrySet().stream().filter(x -> x.getValue() != null && !((String)x.getValue()).isEmpty()).map(kv -> String.format("%s=%s", kv.getKey(), Sanitizer.jmxSanitize((String)((String)kv.getValue())))).collect(Collectors.toList());
        return String.join((CharSequence)",", tagsList);
    }
}

