/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.metrics;

import com.linkedin.kafka.cruisecontrol.detector.tenantstriping.TenantAutoScaler;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import io.confluent.databalancer.metrics.DataBalancerMetricsUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;

public class TenantStripingMetrics {
    public static final String TENANT_ID_TAG = "tenant";
    private static final String INSUFFICIENT_CELLS_AVAILABLE_METRIC_NAME = "insufficient-cells-available";
    public static final String SKIPPED_TENANTS_BY_EXPIRY_METRIC_NAME = "expired-tenants";
    private static final String RATE_LIMITED_TENANTS_METRIC_NAME = "rate-limited-tenants";
    private static final String STRIPES_PLACED_METRIC_NAME = "stripes-placed";
    public static final String PENDING_TENANT_METRIC_NAME = "pending-tenant";
    public static final String DRY_RUN_MODE_METRIC_NAME = "dry-run-mode";
    public static final String TENANT_LOAD_SPIKE_DETECTION_TIME_SEC = "tenant-load-spike-detection-time-sec";
    public static final String TENANT_METADATA_UPDATE_FAILURE = "tenant-metadata-update-failure";
    private final MetricsRegistry metricsRegistry = KafkaYammerMetrics.defaultRegistry();
    private final Map<String, AtomicInteger> insufficientCellsAvailableGaugeByTenant = new HashMap<String, AtomicInteger>();
    private final Map<String, Gauge<Boolean>> tenantsConstantlyExpiredMetricsByTenant = new HashMap<String, Gauge<Boolean>>();
    private final Map<String, AtomicLong> tenantLoadSpikeDetectionTimeSecByTenant = new HashMap<String, AtomicLong>();
    private final Map<String, Gauge<Boolean>> pendingTenantMetricsByTenant = new HashMap<String, Gauge<Boolean>>();
    private final Map<String, Gauge<Boolean>> tenantMetadataUpdateFailureMetricsByTenant = new HashMap<String, Gauge<Boolean>>();
    private volatile int rateLimitedTenantsCount;
    private volatile int stripesPlacedCount;

    public TenantStripingMetrics() {
        DataBalancerMetricsUtils.createGauge(this.metricsRegistry, DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, RATE_LIMITED_TENANTS_METRIC_NAME), () -> this.rateLimitedTenantsCount);
        DataBalancerMetricsUtils.createGauge(this.metricsRegistry, DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, STRIPES_PLACED_METRIC_NAME), () -> this.stripesPlacedCount);
    }

    public <T> void newGauge(String name, Supplier<T> valueSupplier) {
        DataBalancerMetricsUtils.createGauge(this.metricsRegistry, DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, name), valueSupplier);
    }

    public void recordInsufficientCellsAvailable(String tenantId, int stripesStillNeeded) {
        AtomicInteger gaugeValue = this.insufficientCellsAvailableGaugeByTenant.computeIfAbsent(tenantId, id -> {
            AtomicInteger value = new AtomicInteger(stripesStillNeeded);
            MetricName metricName = DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, INSUFFICIENT_CELLS_AVAILABLE_METRIC_NAME, Map.of(TENANT_ID_TAG, tenantId));
            DataBalancerMetricsUtils.createGauge(this.metricsRegistry, metricName, value::get);
            return value;
        });
        gaugeValue.set(stripesStillNeeded);
    }

    public void clearInsufficientCellsAvailableMetric(String tenantId) {
        MetricName metricName = DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, INSUFFICIENT_CELLS_AVAILABLE_METRIC_NAME, Map.of(TENANT_ID_TAG, tenantId));
        this.metricsRegistry.removeMetric(metricName);
        this.insufficientCellsAvailableGaugeByTenant.remove(tenantId);
    }

    public void recordRateLimitedTenantsCount(int count) {
        this.rateLimitedTenantsCount = count;
    }

    public void recordStripesPlacedCount(int count) {
        this.stripesPlacedCount = count;
    }

    public void recordTenantsSkippedByExpiry(String tenantId) {
        this.tenantsConstantlyExpiredMetricsByTenant.computeIfAbsent(tenantId, id -> {
            MetricName metricName = DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, SKIPPED_TENANTS_BY_EXPIRY_METRIC_NAME, Map.of(TENANT_ID_TAG, tenantId));
            return DataBalancerMetricsUtils.createGauge(this.metricsRegistry, metricName, () -> true);
        });
    }

    public void clearTenantSkippedByExpiry(String tenantId) {
        MetricName metricName = DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, SKIPPED_TENANTS_BY_EXPIRY_METRIC_NAME, Map.of(TENANT_ID_TAG, tenantId));
        this.metricsRegistry.removeMetric(metricName);
        this.tenantsConstantlyExpiredMetricsByTenant.remove(tenantId);
    }

    public void recordTenantMetadataUpdateFailure(String tenantId) {
        this.tenantMetadataUpdateFailureMetricsByTenant.computeIfAbsent(tenantId, id -> {
            MetricName metricName = DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, TENANT_METADATA_UPDATE_FAILURE, Map.of(TENANT_ID_TAG, tenantId));
            return DataBalancerMetricsUtils.createGauge(this.metricsRegistry, metricName, () -> true);
        });
    }

    public void clearTenantMetadataUpdateFailure(String tenantId) {
        MetricName metricName = DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, TENANT_METADATA_UPDATE_FAILURE, Map.of(TENANT_ID_TAG, tenantId));
        this.metricsRegistry.removeMetric(metricName);
        this.tenantMetadataUpdateFailureMetricsByTenant.remove(tenantId);
    }

    public void recordTenantLoadSpikeDetectionTime(String tenantId, long detectionTimeSec) {
        AtomicLong gaugeValue = this.tenantLoadSpikeDetectionTimeSecByTenant.computeIfAbsent(tenantId, id -> {
            AtomicLong value = new AtomicLong(detectionTimeSec);
            MetricName metricName = DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, TENANT_LOAD_SPIKE_DETECTION_TIME_SEC, Map.of(TENANT_ID_TAG, tenantId));
            DataBalancerMetricsUtils.createGauge(this.metricsRegistry, metricName, value::get);
            return value;
        });
        gaugeValue.set(detectionTimeSec);
    }

    public void clearTenantLoadSpikeDetectionTime(String tenantId) {
        MetricName metricName = DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, TENANT_LOAD_SPIKE_DETECTION_TIME_SEC, Map.of(TENANT_ID_TAG, tenantId));
        this.metricsRegistry.removeMetric(metricName);
        this.tenantLoadSpikeDetectionTimeSecByTenant.remove(tenantId);
    }

    public void recordTenantPending(String tenantId) {
        this.pendingTenantMetricsByTenant.computeIfAbsent(tenantId, id -> {
            MetricName metricName = DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, PENDING_TENANT_METRIC_NAME, Map.of(TENANT_ID_TAG, tenantId));
            return DataBalancerMetricsUtils.createGauge(this.metricsRegistry, metricName, () -> true);
        });
    }

    public void clearTenantPending(String tenantId) {
        MetricName metricName = DataBalancerMetricsUtils.metricName(TenantAutoScaler.class, PENDING_TENANT_METRIC_NAME, Map.of(TENANT_ID_TAG, tenantId));
        this.metricsRegistry.removeMetric(metricName);
        this.pendingTenantMetricsByTenant.remove(tenantId);
    }
}

