/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.metrics.internals;

import com.linkedin.kafka.cruisecontrol.common.CellResource;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TenantResourceStats {
    private final List<Integer> cellIds;
    private final String tenantId;
    private final CellResource resource;
    private final double cellCapacityValue;
    private final double utilizationValue;
    private final Map<Integer, Double> utilizationValuePerCell;

    public TenantResourceStats(List<Integer> cellIds, String tenantId, CellResource resource, double cellCapacityValue, double utilizationValue, Map<Integer, Double> utilizationValuePerCell) {
        this.cellIds = cellIds;
        this.tenantId = Objects.requireNonNull(tenantId);
        this.resource = Objects.requireNonNull(resource);
        this.cellCapacityValue = cellCapacityValue;
        this.utilizationValue = utilizationValue;
        this.utilizationValuePerCell = utilizationValuePerCell;
    }

    public List<Integer> cellIds() {
        return this.cellIds;
    }

    public String tenantId() {
        return this.tenantId;
    }

    public CellResource resource() {
        return this.resource;
    }

    public double utilizationValue() {
        return this.utilizationValue;
    }

    public Map<Integer, Double> utilizationValuePerCell() {
        return this.utilizationValuePerCell;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TenantResourceStats that = (TenantResourceStats)o;
        if (this.cellIds != that.cellIds) {
            return false;
        }
        if (Double.compare(this.cellCapacityValue, that.cellCapacityValue) != 0) {
            return false;
        }
        if (Double.compare(this.utilizationValue, that.utilizationValue) != 0) {
            return false;
        }
        if (!this.tenantId.equals(that.tenantId)) {
            return false;
        }
        return this.resource == that.resource;
    }

    public int hashCode() {
        int result = this.cellIds.hashCode();
        result = 31 * result + this.tenantId.hashCode();
        result = 31 * result + this.resource.hashCode();
        long temp = Double.doubleToLongBits(this.cellCapacityValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.utilizationValue);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "TenantResourceStats{cellId=" + String.valueOf(this.cellIds) + ", tenantId='" + this.tenantId + "', resource=" + String.valueOf((Object)this.resource) + ", cellCapacityValue=" + this.cellCapacityValue + ", utilizationValue=" + this.utilizationValue + "}";
    }
}

