/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.operation.BalancerOperationEvent;
import io.confluent.databalancer.operation.BalancerOperationState;
import io.confluent.databalancer.operation.StateMachine;
import io.confluent.databalancer.operation.StateTransitioner;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.apache.kafka.clients.admin.BalancerOperationStatus;
import org.apache.kafka.clients.admin.PartitionReassignmentsStatus;
import org.apache.kafka.common.utils.Time;

public class BrokerAdditionStateMachine
extends StateMachine<BrokerAdditionState, BrokerAdditionEvent> {
    private static StateTransitioner<BrokerAdditionState, BrokerAdditionEvent> transitioner = new StateTransitioner.Builder().with(BrokerAdditionStateMachine.transition().from(BrokerAdditionState.PLAN_COMPUTATION).to(BrokerAdditionState.REASSIGNMENT).when(new BrokerAdditionEvent[]{BrokerAdditionEvent.PLAN_COMPUTED})).with(BrokerAdditionStateMachine.transition().from(BrokerAdditionState.REASSIGNMENT).to(BrokerAdditionState.COMPLETED).when(new BrokerAdditionEvent[]{BrokerAdditionEvent.REASSIGNMENT_FINISHED})).with(BrokerAdditionStateMachine.transition().from(BrokerAdditionState.PLAN_COMPUTATION).to(BrokerAdditionState.PLAN_COMPUTATION_FAILED).when(new BrokerAdditionEvent[]{BrokerAdditionEvent.UNEXPECTED_ERROR})).with(BrokerAdditionStateMachine.transition().from(BrokerAdditionState.REASSIGNMENT).to(BrokerAdditionState.REASSIGNMENT_FAILED).when(new BrokerAdditionEvent[]{BrokerAdditionEvent.UNEXPECTED_ERROR})).with(BrokerAdditionStateMachine.transition().from(BrokerAdditionState.PLAN_COMPUTATION).to(BrokerAdditionState.PLAN_COMPUTATION_CANCELED).when(new BrokerAdditionEvent[]{BrokerAdditionEvent.BROKER_REMOVAL_REQUEST_OVERRIDES})).with(BrokerAdditionStateMachine.transition().from(BrokerAdditionState.PLAN_COMPUTATION).to(BrokerAdditionState.PLAN_COMPUTATION_CANCELED).when(new BrokerAdditionEvent[]{BrokerAdditionEvent.BROKER_EXCLUSION_DETECTED})).with(BrokerAdditionStateMachine.transition().from(BrokerAdditionState.PLAN_COMPUTATION).to(BrokerAdditionState.PLAN_COMPUTATION_CANCELED).when(new BrokerAdditionEvent[]{BrokerAdditionEvent.BROKER_DEMOTION_DETECTED})).with(BrokerAdditionStateMachine.transition().from(BrokerAdditionState.PLAN_COMPUTATION).to(BrokerAdditionState.COMPLETED).when(new BrokerAdditionEvent[]{BrokerAdditionEvent.EXCLUSION_SHORT_CIRCUITS})).with(BrokerAdditionStateMachine.transition().from(BrokerAdditionState.REASSIGNMENT).to(BrokerAdditionState.REASSIGNMENT_CANCELED).when(new BrokerAdditionEvent[]{BrokerAdditionEvent.BROKER_REMOVAL_REQUEST_OVERRIDES})).with(BrokerAdditionStateMachine.transition().from(BrokerAdditionState.REASSIGNMENT).to(BrokerAdditionState.REASSIGNMENT_CANCELED).when(new BrokerAdditionEvent[]{BrokerAdditionEvent.BROKER_EXCLUSION_DETECTED})).with(BrokerAdditionStateMachine.transition().from(BrokerAdditionState.REASSIGNMENT).to(BrokerAdditionState.REASSIGNMENT_CANCELED).when(new BrokerAdditionEvent[]{BrokerAdditionEvent.BROKER_DEMOTION_DETECTED})).build();
    static final BrokerAdditionState START_STATE = BrokerAdditionState.PLAN_COMPUTATION;

    public BrokerAdditionStateMachine(int brokerId) {
        this(brokerId, Time.SYSTEM);
    }

    public BrokerAdditionStateMachine(int brokerId, Time time) {
        super(brokerId, "Broker Addition", START_STATE, time);
    }

    private static StateTransitioner.TransitionBuilder<BrokerAdditionState, BrokerAdditionEvent> transition() {
        return new StateTransitioner.TransitionBuilder<BrokerAdditionState, BrokerAdditionEvent>();
    }

    public static boolean isStateTerminal(BrokerAdditionState state) {
        return transitioner.isTerminalState(state);
    }

    @Override
    StateTransitioner<BrokerAdditionState, BrokerAdditionEvent> transitioner() {
        return transitioner;
    }

    public static BalancerOperationStatus convertBrokerAdditionStatus(PartitionReassignmentsStatus partitionReassignmentsStatus) {
        if (partitionReassignmentsStatus == PartitionReassignmentsStatus.COMPLETED) {
            return BalancerOperationStatus.SUCCESS;
        }
        if (partitionReassignmentsStatus == PartitionReassignmentsStatus.PENDING || partitionReassignmentsStatus == PartitionReassignmentsStatus.IN_PROGRESS) {
            return BalancerOperationStatus.IN_PROGRESS;
        }
        return BalancerOperationStatus.FAILED;
    }

    @Immutable
    public static enum BrokerAdditionState implements BalancerOperationState
    {
        PLAN_COMPUTATION(PartitionReassignmentsStatus.PENDING),
        REASSIGNMENT(PartitionReassignmentsStatus.IN_PROGRESS),
        PLAN_COMPUTATION_CANCELED(PartitionReassignmentsStatus.CANCELED, true),
        REASSIGNMENT_CANCELED(PartitionReassignmentsStatus.CANCELED, true),
        PLAN_COMPUTATION_FAILED(PartitionReassignmentsStatus.ERROR, true),
        REASSIGNMENT_FAILED(PartitionReassignmentsStatus.ERROR, true),
        COMPLETED(PartitionReassignmentsStatus.COMPLETED, true);

        private final PartitionReassignmentsStatus status;
        private final boolean isTerminal;

        private BrokerAdditionState(PartitionReassignmentsStatus status) {
            this(status, false);
        }

        private BrokerAdditionState(PartitionReassignmentsStatus status, boolean isTerminal) {
            this.status = status;
            this.isTerminal = isTerminal;
        }

        public PartitionReassignmentsStatus status() {
            return this.status;
        }

        @Override
        public boolean isTerminal() {
            return this.isTerminal;
        }
    }

    public static enum BrokerAdditionEvent implements BalancerOperationEvent
    {
        BROKER_REMOVAL_REQUEST_OVERRIDES(true),
        BROKER_EXCLUSION_DETECTED(true),
        UNEXPECTED_ERROR(true),
        BROKER_DEMOTION_DETECTED(true),
        EXCLUSION_SHORT_CIRCUITS,
        PLAN_COMPUTED,
        REASSIGNMENT_FINISHED;

        private final boolean canCancel;

        private BrokerAdditionEvent() {
            this(false);
        }

        private BrokerAdditionEvent(boolean canCancel) {
            this.canCancel = canCancel;
        }

        public boolean canCancel() {
            return this.canCancel;
        }

        public AdditionEvent withBrokers(List<Integer> affectedBrokers) {
            return this.withBrokers(new HashSet<Integer>(affectedBrokers));
        }

        public AdditionEvent withBrokers(Set<Integer> affectedBrokers) {
            return new AdditionEvent(this, affectedBrokers);
        }
    }

    public static class AdditionEvent {
        public final BrokerAdditionEvent event;
        public final Set<Integer> affectedBrokerIds;

        public AdditionEvent(BrokerAdditionEvent event, Set<Integer> affectedBrokerIds) {
            this.event = event;
            this.affectedBrokerIds = affectedBrokerIds;
        }

        public String toString() {
            return "AdditionEvent{event=" + String.valueOf(this.event) + ", affectedBrokerIds=" + String.valueOf(this.affectedBrokerIds) + "}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AdditionEvent that = (AdditionEvent)o;
            return this.event == that.event && Objects.equals(this.affectedBrokerIds, that.affectedBrokerIds);
        }

        public int hashCode() {
            return Objects.hash(this.event, this.affectedBrokerIds);
        }
    }
}

