/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.databalancer.operation;

import io.confluent.databalancer.operation.BrokerRemovalStateMachine;
import io.confluent.databalancer.operation.MultiBrokerBalancerOperationProgressListener;
import io.confluent.databalancer.persistence.ApiStatePersistenceStore;
import io.confluent.databalancer.persistence.BrokerRemovalStateRecord;
import io.confluent.databalancer.utils.ImmutableSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistRemoveApiStateListener
implements MultiBrokerBalancerOperationProgressListener<BrokerRemovalStateMachine.BrokerRemovalState> {
    private static final Logger LOG = LoggerFactory.getLogger(PersistRemoveApiStateListener.class);
    private final ApiStatePersistenceStore persistenceStore;
    private final boolean shouldShutdown;

    public PersistRemoveApiStateListener(ApiStatePersistenceStore persistenceStore, boolean shouldShutdown) {
        this.persistenceStore = persistenceStore;
        this.shouldShutdown = shouldShutdown;
    }

    @Override
    public void onProgressChanged(Set<Integer> brokerIds, BrokerRemovalStateMachine.BrokerRemovalState state, Exception e) {
        boolean isNew;
        BrokerRemovalStateRecord record = new BrokerRemovalStateRecord(brokerIds, state, e, this.shouldShutdown);
        BrokerRemovalStateRecord existingRemovalStateRecord = this.persistenceStore.getBrokerRemovalStateRecord(new ImmutableSet<Integer>(brokerIds));
        boolean bl = isNew = existingRemovalStateRecord == null || BrokerRemovalStateMachine.isStateTerminal(existingRemovalStateRecord.state());
        if (!isNew) {
            record.setStartTime(existingRemovalStateRecord.startTime());
        }
        try {
            this.persistenceStore.save(record, isNew);
            LOG.info("Removal status persisted record for brokers {} changed from {} to {}", new Object[]{brokerIds, existingRemovalStateRecord, record});
        }
        catch (InterruptedException ex) {
            LOG.error("Interrupted when broker removal state for brokers: {}", brokerIds, (Object)ex);
            Thread.currentThread().interrupt();
            throw new RuntimeException(ex);
        }
    }
}

