/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfluentTopicConfig;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.coordinator.group.ConsumerGroupMigrationPolicy;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.Utils;
import org.apache.kafka.coordinator.group.api.assignor.ConsumerGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.PartitionAssignor;
import org.apache.kafka.coordinator.group.api.assignor.ShareGroupPartitionAssignor;
import org.apache.kafka.coordinator.group.assignor.RangeAssignor;
import org.apache.kafka.coordinator.group.assignor.SimpleAssignor;
import org.apache.kafka.coordinator.group.assignor.UniformAssignor;
import org.apache.kafka.coordinator.group.modern.share.ShareGroupConfig;
import org.apache.kafka.metadata.TopicPlacement;

public class GroupCoordinatorConfig {
    public static final String CONFLUENT_PREFIX = "confluent.";
    public static final String GROUP_COORDINATOR_REBALANCE_PROTOCOLS_CONFIG = "group.coordinator.rebalance.protocols";
    public static final String GROUP_COORDINATOR_REBALANCE_PROTOCOLS_DOC = "The list of enabled rebalance protocols.The " + String.valueOf((Object)Group.GroupType.STREAMS) + " rebalance protocol is in early access and therefore must not be used in production.";
    public static final List<String> GROUP_COORDINATOR_REBALANCE_PROTOCOLS_DEFAULT = List.of(Group.GroupType.CLASSIC.toString(), Group.GroupType.CONSUMER.toString(), Group.GroupType.SHARE.toString(), Group.GroupType.STREAMS.toString());
    public static final String GROUP_COORDINATOR_APPEND_LINGER_MS_CONFIG = "group.coordinator.append.linger.ms";
    public static final String GROUP_COORDINATOR_APPEND_LINGER_MS_DOC = "The duration in milliseconds that the coordinator will wait for writes to accumulate before flushing them to disk. Increasing this value improves write efficiency and batch size, but also increases the response latency for requests, as the coordinator must wait for batches to be flushed to disk before completing request processing. Transactional writes are not accumulated.";
    public static final int GROUP_COORDINATOR_APPEND_LINGER_MS_DEFAULT = 5;
    public static final String GROUP_COORDINATOR_NUM_THREADS_CONFIG = "group.coordinator.threads";
    public static final String GROUP_COORDINATOR_NUM_THREADS_DOC = "The number of threads used by the group coordinator.";
    public static final int GROUP_COORDINATOR_NUM_THREADS_DEFAULT = 4;
    public static final String OFFSETS_LOAD_BUFFER_SIZE_CONFIG = "offsets.load.buffer.size";
    public static final int OFFSETS_LOAD_BUFFER_SIZE_DEFAULT = 0x500000;
    public static final String OFFSETS_LOAD_BUFFER_SIZE_DOC = "Batch size for reading from the offsets segments when loading group metadata  into the cache (soft-limit, overridden if records are too large).";
    public static final String OFFSET_COMMIT_TIMEOUT_MS_CONFIG = "offsets.commit.timeout.ms";
    public static final int OFFSET_COMMIT_TIMEOUT_MS_DEFAULT = 5000;
    public static final String OFFSET_COMMIT_TIMEOUT_MS_DOC = "Offset commit will be delayed until all replicas for the offsets topic receive the commit or this timeout is reached. This is similar to the producer request timeout. This is applied to all the writes made by the coordinator.";
    public static final String OFFSETS_TOPIC_PARTITIONS_CONFIG = "offsets.topic.num.partitions";
    public static final int OFFSETS_TOPIC_PARTITIONS_DEFAULT = 50;
    public static final String OFFSETS_TOPIC_PARTITIONS_DOC = "The number of partitions for the offset commit topic (should not change after deployment).";
    public static final String OFFSETS_TOPIC_SEGMENT_BYTES_CONFIG = "offsets.topic.segment.bytes";
    public static final int OFFSETS_TOPIC_SEGMENT_BYTES_DEFAULT = 0x6400000;
    public static final String OFFSETS_TOPIC_SEGMENT_BYTES_DOC = "The offsets topic segment bytes should be kept relatively small in order to facilitate faster log compaction and cache loads.";
    public static final String OFFSETS_TOPIC_REPLICATION_FACTOR_CONFIG = "offsets.topic.replication.factor";
    public static final short OFFSETS_TOPIC_REPLICATION_FACTOR_DEFAULT = 3;
    public static final String OFFSETS_TOPIC_REPLICATION_FACTOR_DOC = "The replication factor for the offsets topic (set higher to ensure availability). Internal topic creation will fail until the cluster size meets this replication factor requirement.";
    public static final String OFFSETS_TOPIC_COMPRESSION_CODEC_CONFIG = "offsets.topic.compression.codec";
    public static final CompressionType OFFSETS_TOPIC_COMPRESSION_CODEC_DEFAULT = CompressionType.NONE;
    public static final String OFFSETS_TOPIC_COMPRESSION_CODEC_DOC = "Compression codec for the offsets topic - compression may be used to achieve \"atomic\" commits.";
    public static final String GROUP_METADATA_LOAD_THREADS_CONFIG = "confluent.group.metadata.load.threads";
    public static final String GROUP_METADATA_LOAD_THREADS_DOC = "The number of threads group metadata load / unload can use to concurrently load / unload metadata.";
    public static final int GROUP_METADATA_LOAD_THREADS_DEFAULT = 32;
    public static final String GROUP_COORDINATOR_OFFSET_WRITER_THREADS_CONFIG = "confluent.group.coordinator.offsets.writer.threads";
    public static final String GROUP_COORDINATOR_OFFSET_WRITER_THREADS_DOC = "The number of offset commit batching writer threads.";
    public static final int GROUP_COORDINATOR_OFFSET_WRITER_THREADS_DEFAULT = 2;
    public static final String GROUP_COORDINATOR_OFFSETS_BATCHING_ENABLE_CONFIG = "confluent.group.coordinator.offsets.batching.enable";
    public static final String GROUP_COORDINATOR_OFFSETS_BATCHING_ENABLE_DOC = "Enables offset commit batching in the group coordinator.";
    public static final boolean GROUP_COORDINATOR_OFFSETS_BATCHING_ENABLE_DEFAULT = false;
    public static final String GROUP_SUBSCRIPTION_PATTERN_LOG_INTERVAL_MS_CONFIG = "confluent.group.subscription.pattern.log.interval.ms";
    public static final String GROUP_SUBSCRIPTION_PATTERN_LOG_INTERVAL_MS_DOC = "The minimum interval between logging groups with heterogeneous subscription patterns. -1 disables logging.";
    public static final int GROUP_SUBSCRIPTION_PATTERN_LOG_INTERVAL_MS_DEFAULT = -1;
    public static final String GROUP_HIGHEST_OFFSET_COMMIT_RATES_LOG_ENABLE_CONFIG = "confluent.group.highest.offset.commit.rates.log.enable";
    public static final String GROUP_HIGHEST_OFFSET_COMMIT_RATES_LOG_ENABLE_DOC = "Enables periodic logging of groups with the highest offset commit rates.";
    public static final boolean GROUP_HIGHEST_OFFSET_COMMIT_RATES_LOG_ENABLE_DEFAULT = false;
    public static final String GROUP_HIGHEST_OFFSET_COMMIT_RATES_LOG_INTERVAL_MS_CONFIG = "confluent.group.highest.offset.commit.rates.log.interval.ms";
    public static final String GROUP_HIGHEST_OFFSET_COMMIT_RATES_LOG_INTERVAL_MS_DOC = "The interval between logging groups with the highest offset commit rates.";
    public static final int GROUP_HIGHEST_OFFSET_COMMIT_RATES_LOG_INTERVAL_MS_DEFAULT = 300000;
    public static final String GROUP_HIGHEST_OFFSET_COMMIT_RATES_LOG_COUNT_CONFIG = "confluent.group.highest.offset.commit.rates.log.count";
    public static final String GROUP_HIGHEST_OFFSET_COMMIT_RATES_LOG_COUNT_DOC = "The number of groups with the highest offset commit rates to log.";
    public static final int GROUP_HIGHEST_OFFSET_COMMIT_RATES_LOG_COUNT_DEFAULT = 10;
    public static final String GROUP_COORDINATOR_TXN_OFFSET_VALIDATION_ENABLE = "confluent.group.coordinator.txn.offset.validation.enable";
    public static final String GROUP_COORDINATOR_TXN_OFFSET_VALIDATION_ENABLE_DOC = "Enables validation of transactional offsets in the group coordinator.";
    public static final boolean GROUP_COORDINATOR_TXN_OFFSET_VALIDATION_ENABLE_DEFAULT = false;
    public static final String GROUP_COORDINATOR_DYNAMIC_APPEND_LINGER_ENABLE_CONFIG = "confluent.group.coordinator.dynamic.append.linger.enable";
    public static final String GROUP_COORDINATOR_DYNAMIC_APPEND_LINGER_ENABLE_DOC = "Whether to use a dynamic linger time. When set, the append linger duration is ignored. Instead, the coordinator will add a flush operation at the back of the coordinator queue when starting a new batch of writes, so that the batch captures all currently queued writes.";
    public static final boolean GROUP_COORDINATOR_DYNAMIC_APPEND_LINGER_ENABLE_DEFAULT = false;
    public static final String GROUP_COORDINATOR_MAX_PARTITION_QUEUE_SIZE_CONFIG = "confluent.group.coordinator.max.partition.queue.size";
    public static final String GROUP_COORDINATOR_MAX_PARTITION_QUEUE_SIZE_DOC = "The maximum number of events that can be queued for a partition.";
    public static final int GROUP_COORDINATOR_MAX_PARTITION_QUEUE_SIZE_DEFAULT = -1;
    public static final String OFFSETS_TOPIC_MAX_MESSAGE_BYTES_CONFIG = "confluent.offsets.topic.max.message.bytes";
    public static final String OFFSETS_TOPIC_MAX_MESSAGE_BYTES_DOC = "The max.message.bytes used for the __consumer_offsets topic.";
    public static final int OFFSETS_TOPIC_MAX_MESSAGE_BYTES_DEFAULT = -1;
    public static final String GROUP_COORDINATOR_SLOW_EVENT_LOG_INTERVAL_MS_CONFIG = "confluent.group.coordinator.slow.event.log.interval.ms";
    public static final String GROUP_COORDINATOR_SLOW_EVENT_LOG_INTERVAL_MS_DOC = "The interval between logging slow events.";
    public static final int GROUP_COORDINATOR_SLOW_EVENT_LOG_INTERVAL_MS_DEFAULT = -1;
    public static final String GROUP_COORDINATOR_SLOW_EVENT_LOG_COUNT_CONFIG = "confluent.group.coordinator.slow.event.log.count";
    public static final String GROUP_COORDINATOR_SLOW_EVENT_LOG_COUNT_DOC = "The number of slow events to log.";
    public static final int GROUP_COORDINATOR_SLOW_EVENT_LOG_COUNT_DEFAULT = 10;
    public static final String OFFSET_METADATA_MAX_SIZE_CONFIG = "offset.metadata.max.bytes";
    public static final int OFFSET_METADATA_MAX_SIZE_DEFAULT = 4096;
    public static final String OFFSET_METADATA_MAX_SIZE_DOC = "The maximum size for a metadata entry associated with an offset commit.";
    public static final String OFFSETS_RETENTION_MINUTES_CONFIG = "offsets.retention.minutes";
    public static final int OFFSETS_RETENTION_MINUTES_DEFAULT = 10080;
    public static final String OFFSETS_RETENTION_MINUTES_DOC = "For subscribed consumers, committed offset of a specific partition will be expired and discarded when 1) this retention period has elapsed after the consumer group loses all its consumers (i.e. becomes empty); 2) this retention period has elapsed since the last time an offset is committed for the partition and the group is no longer subscribed to the corresponding topic. For standalone consumers (using manual assignment), offsets will be expired after this retention period has elapsed since the time of last commit. Note that when a group is deleted via the delete-group request, its committed offsets will also be deleted without extra retention period; also when a topic is deleted via the delete-topic request, upon propagated metadata update any group's committed offsets for that topic will also be deleted without extra retention period.";
    public static final String OFFSETS_RETENTION_CHECK_INTERVAL_MS_CONFIG = "offsets.retention.check.interval.ms";
    public static final long OFFSETS_RETENTION_CHECK_INTERVAL_MS_DEFAULT = 600000L;
    public static final String OFFSETS_RETENTION_CHECK_INTERVAL_MS_DOC = "Frequency at which to check for stale offsets";
    public static final String GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG = "group.min.session.timeout.ms";
    public static final String GROUP_MIN_SESSION_TIMEOUT_MS_DOC = "The minimum allowed session timeout for registered consumers. Shorter timeouts result in quicker failure detection at the cost of more frequent consumer heartbeating, which can overwhelm broker resources.";
    public static final int GROUP_MIN_SESSION_TIMEOUT_MS_DEFAULT = 6000;
    public static final String GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG = "group.max.session.timeout.ms";
    public static final String GROUP_MAX_SESSION_TIMEOUT_MS_DOC = "The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.";
    public static final int GROUP_MAX_SESSION_TIMEOUT_MS_DEFAULT = 1800000;
    public static final String GROUP_INITIAL_REBALANCE_DELAY_MS_CONFIG = "group.initial.rebalance.delay.ms";
    public static final String GROUP_INITIAL_REBALANCE_DELAY_MS_DOC = "The amount of time the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins.";
    public static final int GROUP_INITIAL_REBALANCE_DELAY_MS_DEFAULT = 3000;
    public static final String GROUP_MAX_SIZE_CONFIG = "group.max.size";
    public static final String GROUP_MAX_SIZE_DOC = "The maximum number of consumers that a single consumer group can accommodate.";
    public static final int GROUP_MAX_SIZE_DEFAULT = Integer.MAX_VALUE;
    public static final String CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG = "group.consumer.session.timeout.ms";
    public static final String CONSUMER_GROUP_SESSION_TIMEOUT_MS_DOC = "The timeout to detect client failures when using the consumer group protocol.";
    public static final int CONSUMER_GROUP_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG = "group.consumer.min.session.timeout.ms";
    public static final String CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_DOC = "The minimum allowed session timeout for registered consumers.";
    public static final int CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG = "group.consumer.max.session.timeout.ms";
    public static final String CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_DOC = "The maximum allowed session timeout for registered consumers.";
    public static final int CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_DEFAULT = 60000;
    public static final String CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG = "group.consumer.heartbeat.interval.ms";
    public static final String CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_DOC = "The heartbeat interval given to the members of a consumer group.";
    public static final int CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG = "group.consumer.min.heartbeat.interval.ms";
    public static final String CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DOC = "The minimum heartbeat interval for registered consumers.";
    public static final int CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG = "group.consumer.max.heartbeat.interval.ms";
    public static final String CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DOC = "The maximum heartbeat interval for registered consumers.";
    public static final int CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DEFAULT = 15000;
    public static final String CONSUMER_GROUP_MAX_SIZE_CONFIG = "group.consumer.max.size";
    public static final String CONSUMER_GROUP_MAX_SIZE_DOC = "The maximum number of consumers that a single consumer group can accommodate. This value will only impact groups under the CONSUMER group protocol. To configure the max group size when using the CLASSIC group protocol use group.max.size instead.";
    public static final int CONSUMER_GROUP_MAX_SIZE_DEFAULT = Integer.MAX_VALUE;
    private static final List<ConsumerGroupPartitionAssignor> CONSUMER_GROUP_BUILTIN_ASSIGNORS = List.of(new UniformAssignor(), new RangeAssignor());
    public static final String CONSUMER_GROUP_ASSIGNORS_CONFIG = "group.consumer.assignors";
    public static final String CONSUMER_GROUP_ASSIGNORS_DOC = "The server side assignors as a list of either names for builtin assignors or full class names for customer assignors. The first one in the list is considered as the default assignor to be used in the case where the consumer does not specify an assignor. The supported builtin assignors are: " + CONSUMER_GROUP_BUILTIN_ASSIGNORS.stream().map(PartitionAssignor::name).collect(Collectors.joining(", ")) + ".";
    public static final List<String> CONSUMER_GROUP_ASSIGNORS_DEFAULT = CONSUMER_GROUP_BUILTIN_ASSIGNORS.stream().map(PartitionAssignor::name).toList();
    public static final String CONSUMER_GROUP_MIGRATION_POLICY_CONFIG = "group.consumer.migration.policy";
    public static final String CONSUMER_GROUP_MIGRATION_POLICY_DEFAULT = ConsumerGroupMigrationPolicy.BIDIRECTIONAL.toString();
    public static final String CONSUMER_GROUP_MIGRATION_POLICY_DOC = "The config that enables converting the non-empty classic group using the consumer embedded protocol to the non-empty consumer group using the consumer group protocol and vice versa; conversions of empty groups in both directions are always enabled regardless of this policy. " + String.valueOf((Object)ConsumerGroupMigrationPolicy.BIDIRECTIONAL) + ": both upgrade from classic group to consumer group and downgrade from consumer group to classic group are enabled, " + String.valueOf((Object)ConsumerGroupMigrationPolicy.UPGRADE) + ": only upgrade from classic group to consumer group is enabled, " + String.valueOf((Object)ConsumerGroupMigrationPolicy.DOWNGRADE) + ": only downgrade from consumer group to classic group is enabled, " + String.valueOf((Object)ConsumerGroupMigrationPolicy.DISABLED) + ": neither upgrade nor downgrade is enabled.";
    public static final String CONSUMER_GROUP_REGEX_REFRESH_INTERVAL_MS_CONFIG = "group.consumer.regex.refresh.interval.ms";
    public static final String CONSUMER_GROUP_REGEX_REFRESH_INTERVAL_MS_DOC = "The interval at which the group coordinator will refresh the topics matching the group subscribed regexes. This is only applicable to consumer groups using the consumer group protocol. ";
    public static final int CONSUMER_GROUP_REGEX_REFRESH_INTERVAL_MS_DEFAULT = 600000;
    public static final String SHARE_GROUP_MAX_SIZE_CONFIG = "group.share.max.size";
    public static final int SHARE_GROUP_MAX_SIZE_DEFAULT = 200;
    public static final String SHARE_GROUP_MAX_SIZE_DOC = "The maximum number of members that a single share group can accommodate.";
    public static final String SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG = "group.share.session.timeout.ms";
    public static final int SHARE_GROUP_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String SHARE_GROUP_SESSION_TIMEOUT_MS_DOC = "The timeout to detect client failures when using the share group protocol.";
    public static final String SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG = "group.share.min.session.timeout.ms";
    public static final int SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_DOC = "The minimum allowed session timeout for share group members.";
    public static final String SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG = "group.share.max.session.timeout.ms";
    public static final int SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_DEFAULT = 60000;
    public static final String SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_DOC = "The maximum allowed session timeout for share group members.";
    public static final String SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG = "group.share.heartbeat.interval.ms";
    public static final int SHARE_GROUP_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String SHARE_GROUP_HEARTBEAT_INTERVAL_MS_DOC = "The heartbeat interval given to the members of a share group.";
    public static final String SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG = "group.share.min.heartbeat.interval.ms";
    public static final int SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DOC = "The minimum heartbeat interval for share group members.";
    public static final String SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG = "group.share.max.heartbeat.interval.ms";
    public static final int SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DEFAULT = 15000;
    public static final String SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DOC = "The maximum heartbeat interval for share group members.";
    private static final ShareGroupPartitionAssignor SHARE_GROUP_BUILTIN_ASSIGNOR = new SimpleAssignor();
    public static final String SHARE_GROUP_ASSIGNORS_CONFIG = "group.share.assignors";
    public static final String SHARE_GROUP_ASSIGNORS_DOC = "The server-side assignors as a list of either names for built-in assignors or full class names for custom assignors. The list must contain only a single entry which is used by all groups. The supported built-in assignors are: " + SHARE_GROUP_BUILTIN_ASSIGNOR.name() + ".";
    public static final String SHARE_GROUP_ASSIGNORS_DEFAULT = SHARE_GROUP_BUILTIN_ASSIGNOR.name();
    public static final String OFFSET_TOPIC_PLACEMENT_CONSTRAINTS_CONFIG = "confluent.offsets.topic.placement.constraints";
    public static final String OFFSET_TOPIC_PLACEMENT_CONSTRAINTS_DOC = ConfluentTopicConfig.TOPIC_PLACEMENT_CONSTRAINTS_DOC;
    public static final String OFFSET_TOPIC_PLACEMENT_CONSTRAINTS_DEFAULT = "";
    public static final String OFFSETS_LOG_CLEANER_DELETE_RETENTION_MS_CONFIG = "confluent.offsets.log.cleaner.delete.retention.ms";
    public static final String OFFSETS_LOG_CLEANER_DELETE_RETENTION_MS_DOC = "The delete retention timeout for the log cleaner compacting the __consumer_offsets topic.";
    public static final long OFFSETS_LOG_CLEANER_DELETE_RETENTION_MS_DEFAULT = 86400000L;
    public static final String OFFSETS_LOG_CLEANER_MIN_CLEANABLE_DIRTY_RATIO_CONFIG = "confluent.offsets.log.cleaner.min.cleanable.dirty.ratio";
    public static final String OFFSETS_LOG_CLEANER_MIN_CLEANABLE_DIRTY_RATIO_DOC = "The minimum cleanable dirty ratio config for the __consumer_offsets topic.";
    public static final double OFFSETS_LOG_CLEANER_MIN_CLEANABLE_DIRTY_RATIO_DEFAULT = 0.5;
    public static final String OFFSETS_LOG_CLEANER_MAX_COMPACTION_LAG_MS_CONFIG = "confluent.offsets.log.cleaner.max.compaction.lag.ms";
    public static final String OFFSETS_LOG_CLEANER_MAX_COMPACTION_LAG_MS_DOC = "The maximum time a message will remain ineligible for compaction in the log. Only applicable for __consumer_offsets logs that are being compacted.";
    public static final long OFFSETS_LOG_CLEANER_MAX_COMPACTION_LAG_MS_DEFAULT = Long.MAX_VALUE;
    public static final String STREAMS_GROUP_SESSION_TIMEOUT_MS_CONFIG = "group.streams.session.timeout.ms";
    public static final int STREAMS_GROUP_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String STREAMS_GROUP_SESSION_TIMEOUT_MS_DOC = "The timeout to detect client failures when using the streams group protocol.";
    public static final String STREAMS_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG = "group.streams.min.session.timeout.ms";
    public static final int STREAMS_GROUP_MIN_SESSION_TIMEOUT_MS_DEFAULT = 45000;
    public static final String STREAMS_GROUP_MIN_SESSION_TIMEOUT_MS_DOC = "The minimum allowed value for the group-level configuration of streams.session.timeout.ms";
    public static final String STREAMS_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG = "group.streams.max.session.timeout.ms";
    public static final int STREAMS_GROUP_MAX_SESSION_TIMEOUT_MS_DEFAULT = 60000;
    public static final String STREAMS_GROUP_MAX_SESSION_TIMEOUT_MS_DOC = "The maximum allowed value for the group-level configuration of streams.session.timeout.ms";
    public static final String STREAMS_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG = "group.streams.heartbeat.interval.ms";
    public static final int STREAMS_GROUP_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String STREAMS_GROUP_HEARTBEAT_INTERVAL_MS_DOC = "The heartbeat interval given to the members.";
    public static final String STREAMS_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG = "group.streams.min.heartbeat.interval.ms";
    public static final int STREAMS_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DEFAULT = 5000;
    public static final String STREAMS_GROUP_MIN_HEARTBEAT_INTERVAL_MS_DOC = "The minimum allowed value for the group-level configuration of streams.heartbeat.interval.ms";
    public static final String STREAMS_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG = "group.streams.max.heartbeat.interval.ms";
    public static final int STREAMS_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DEFAULT = 15000;
    public static final String STREAMS_GROUP_MAX_HEARTBEAT_INTERVAL_MS_DOC = "The maximum allowed value for the group-level configuration of streams.heartbeat.interval.ms";
    public static final String STREAMS_GROUP_MAX_SIZE_CONFIG = "group.streams.max.size";
    public static final int STREAMS_GROUP_MAX_SIZE_DEFAULT = Integer.MAX_VALUE;
    public static final String STREAMS_GROUP_MAX_SIZE_DOC = "The maximum number of streams clients that a single streams group can accommodate.";
    public static final String STREAMS_GROUP_NUM_STANDBY_REPLICAS_CONFIG = "group.streams.num.standby.replicas";
    public static final int STREAMS_GROUP_NUM_STANDBY_REPLICAS_DEFAULT = 0;
    public static final String STREAMS_GROUP_NUM_STANDBY_REPLICAS_DOC = "The number of standby replicas for each task.";
    public static final String STREAMS_GROUP_MAX_STANDBY_REPLICAS_CONFIG = "group.streams.max.standby.replicas";
    public static final int STREAMS_GROUP_MAX_STANDBY_REPLICAS_DEFAULT = 2;
    public static final String STREAMS_GROUP_MAX_STANDBY_REPLICAS_DOC = "The maximum allowed value for the group-level configuration of streams.num.standby.replicas";
    public static final String SHARE_GROUP_INITIALIZE_RETRY_INTERVAL_MS_CONFIG = "group.share.initialize.retry.interval.ms";
    public static final int SHARE_GROUP_INITIALIZE_RETRY_INTERVAL_MS_DEFAULT = 30000;
    public static final String SHARE_GROUP_INITIALIZE_RETRY_INTERVAL_MS_DOC = "Time elapsed before retrying initialize share group state request. If below offsets.commit.timeout.ms, then value of offsets.commit.timeout.ms is used.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("group.coordinator.rebalance.protocols", ConfigDef.Type.LIST, GROUP_COORDINATOR_REBALANCE_PROTOCOLS_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidList.in((String[])Group.GroupType.documentValidValues()), ConfigDef.Importance.MEDIUM, GROUP_COORDINATOR_REBALANCE_PROTOCOLS_DOC).define("group.coordinator.threads", ConfigDef.Type.INT, (Object)4, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The number of threads used by the group coordinator.").define("group.coordinator.append.linger.ms", ConfigDef.Type.INT, (Object)5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The duration in milliseconds that the coordinator will wait for writes to accumulate before flushing them to disk. Increasing this value improves write efficiency and batch size, but also increases the response latency for requests, as the coordinator must wait for batches to be flushed to disk before completing request processing. Transactional writes are not accumulated.").define("offsets.commit.timeout.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "Offset commit will be delayed until all replicas for the offsets topic receive the commit or this timeout is reached. This is similar to the producer request timeout. This is applied to all the writes made by the coordinator.").define("offsets.load.buffer.size", ConfigDef.Type.INT, (Object)0x500000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "Batch size for reading from the offsets segments when loading group metadata  into the cache (soft-limit, overridden if records are too large).").define("offsets.topic.replication.factor", ConfigDef.Type.SHORT, (Object)3, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The replication factor for the offsets topic (set higher to ensure availability). Internal topic creation will fail until the cluster size meets this replication factor requirement.").define("offsets.topic.num.partitions", ConfigDef.Type.INT, (Object)50, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The number of partitions for the offset commit topic (should not change after deployment).").define("offsets.topic.segment.bytes", ConfigDef.Type.INT, (Object)0x6400000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The offsets topic segment bytes should be kept relatively small in order to facilitate faster log compaction and cache loads.").define("offsets.topic.compression.codec", ConfigDef.Type.INT, (Object)GroupCoordinatorConfig.OFFSETS_TOPIC_COMPRESSION_CODEC_DEFAULT.id, ConfigDef.Importance.HIGH, "Compression codec for the offsets topic - compression may be used to achieve \"atomic\" commits.").define("confluent.group.metadata.load.threads", ConfigDef.Type.INT, (Object)32, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The number of threads group metadata load / unload can use to concurrently load / unload metadata.").defineInternal("confluent.group.coordinator.offsets.writer.threads", ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The number of offset commit batching writer threads.").defineInternal("confluent.group.coordinator.offsets.batching.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, "Enables offset commit batching in the group coordinator.").defineInternal("confluent.group.subscription.pattern.log.interval.ms", ConfigDef.Type.INT, (Object)-1, ConfigDef.Importance.MEDIUM, "The minimum interval between logging groups with heterogeneous subscription patterns. -1 disables logging.").defineInternal("confluent.group.highest.offset.commit.rates.log.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Enables periodic logging of groups with the highest offset commit rates.").defineInternal("confluent.group.highest.offset.commit.rates.log.interval.ms", ConfigDef.Type.INT, (Object)300000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The interval between logging groups with the highest offset commit rates.").defineInternal("confluent.group.highest.offset.commit.rates.log.count", ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The number of groups with the highest offset commit rates to log.").defineInternal("confluent.group.coordinator.txn.offset.validation.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Enables validation of transactional offsets in the group coordinator.").defineInternal("confluent.group.coordinator.dynamic.append.linger.enable", ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.MEDIUM, "Whether to use a dynamic linger time. When set, the append linger duration is ignored. Instead, the coordinator will add a flush operation at the back of the coordinator queue when starting a new batch of writes, so that the batch captures all currently queued writes.").defineInternal("confluent.group.coordinator.max.partition.queue.size", ConfigDef.Type.INT, (Object)-1, ConfigDef.Importance.MEDIUM, "The maximum number of events that can be queued for a partition.").defineInternal("confluent.offsets.topic.max.message.bytes", ConfigDef.Type.INT, (Object)-1, ConfigDef.Importance.MEDIUM, "The max.message.bytes used for the __consumer_offsets topic.").defineInternal("confluent.group.coordinator.slow.event.log.interval.ms", ConfigDef.Type.INT, (Object)-1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)-1), ConfigDef.Importance.MEDIUM, "The interval between logging slow events.").defineInternal("confluent.group.coordinator.slow.event.log.count", ConfigDef.Type.INT, (Object)10, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The number of slow events to log.").define("offset.metadata.max.bytes", ConfigDef.Type.INT, (Object)4096, ConfigDef.Importance.HIGH, "The maximum size for a metadata entry associated with an offset commit.").define("offsets.retention.minutes", ConfigDef.Type.INT, (Object)10080, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "For subscribed consumers, committed offset of a specific partition will be expired and discarded when 1) this retention period has elapsed after the consumer group loses all its consumers (i.e. becomes empty); 2) this retention period has elapsed since the last time an offset is committed for the partition and the group is no longer subscribed to the corresponding topic. For standalone consumers (using manual assignment), offsets will be expired after this retention period has elapsed since the time of last commit. Note that when a group is deleted via the delete-group request, its committed offsets will also be deleted without extra retention period; also when a topic is deleted via the delete-topic request, upon propagated metadata update any group's committed offsets for that topic will also be deleted without extra retention period.").define("offsets.retention.check.interval.ms", ConfigDef.Type.LONG, (Object)600000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "Frequency at which to check for stale offsets").define("confluent.offsets.topic.placement.constraints", ConfigDef.Type.STRING, (Object)"", TopicPlacement.VALIDATOR, ConfigDef.Importance.HIGH, OFFSET_TOPIC_PLACEMENT_CONSTRAINTS_DOC).define("confluent.offsets.log.cleaner.delete.retention.ms", ConfigDef.Type.LONG, (Object)86400000L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The delete retention timeout for the log cleaner compacting the __consumer_offsets topic.").define("confluent.offsets.log.cleaner.min.cleanable.dirty.ratio", ConfigDef.Type.DOUBLE, (Object)0.5, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, "The minimum cleanable dirty ratio config for the __consumer_offsets topic.").define("confluent.offsets.log.cleaner.max.compaction.lag.ms", ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, "The maximum time a message will remain ineligible for compaction in the log. Only applicable for __consumer_offsets logs that are being compacted.").define("group.min.session.timeout.ms", ConfigDef.Type.INT, (Object)6000, ConfigDef.Importance.MEDIUM, "The minimum allowed session timeout for registered consumers. Shorter timeouts result in quicker failure detection at the cost of more frequent consumer heartbeating, which can overwhelm broker resources.").define("group.max.session.timeout.ms", ConfigDef.Type.INT, (Object)1800000, ConfigDef.Importance.MEDIUM, "The maximum allowed session timeout for registered consumers. Longer timeouts give consumers more time to process messages in between heartbeats at the cost of a longer time to detect failures.").define("group.initial.rebalance.delay.ms", ConfigDef.Type.INT, (Object)3000, ConfigDef.Importance.MEDIUM, "The amount of time the group coordinator will wait for more consumers to join a new group before performing the first rebalance. A longer delay means potentially fewer rebalances, but increases the time until processing begins.").define("group.max.size", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum number of consumers that a single consumer group can accommodate.").define("group.consumer.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The timeout to detect client failures when using the consumer group protocol.").define("group.consumer.min.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum allowed session timeout for registered consumers.").define("group.consumer.max.session.timeout.ms", ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum allowed session timeout for registered consumers.").define("group.consumer.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The heartbeat interval given to the members of a consumer group.").define("group.consumer.min.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum heartbeat interval for registered consumers.").define("group.consumer.max.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)15000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum heartbeat interval for registered consumers.").define("group.consumer.max.size", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum number of consumers that a single consumer group can accommodate. This value will only impact groups under the CONSUMER group protocol. To configure the max group size when using the CLASSIC group protocol use group.max.size instead.").define("group.consumer.assignors", ConfigDef.Type.LIST, CONSUMER_GROUP_ASSIGNORS_DEFAULT, null, ConfigDef.Importance.MEDIUM, CONSUMER_GROUP_ASSIGNORS_DOC).define("group.consumer.migration.policy", ConfigDef.Type.STRING, (Object)CONSUMER_GROUP_MIGRATION_POLICY_DEFAULT, (ConfigDef.Validator)ConfigDef.CaseInsensitiveValidString.in((String[])org.apache.kafka.common.utils.Utils.enumOptions(ConsumerGroupMigrationPolicy.class)), ConfigDef.Importance.MEDIUM, CONSUMER_GROUP_MIGRATION_POLICY_DOC).defineInternal("group.consumer.regex.refresh.interval.ms", ConfigDef.Type.INT, (Object)600000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)10000), ConfigDef.Importance.MEDIUM, "The interval at which the group coordinator will refresh the topics matching the group subscribed regexes. This is only applicable to consumer groups using the consumer group protocol. ").define("group.share.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The timeout to detect client failures when using the share group protocol.").define("group.share.min.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum allowed session timeout for share group members.").define("group.share.max.session.timeout.ms", ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum allowed session timeout for share group members.").define("group.share.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The heartbeat interval given to the members of a share group.").define("group.share.min.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum heartbeat interval for share group members.").define("group.share.max.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)15000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum heartbeat interval for share group members.").define("group.share.max.size", ConfigDef.Type.INT, (Object)200, (ConfigDef.Validator)ConfigDef.Range.between((Number)1, (Number)1000), ConfigDef.Importance.MEDIUM, "The maximum number of members that a single share group can accommodate.").define("group.share.assignors", ConfigDef.Type.LIST, (Object)SHARE_GROUP_ASSIGNORS_DEFAULT, null, ConfigDef.Importance.MEDIUM, SHARE_GROUP_ASSIGNORS_DOC).defineInternal("group.share.initialize.retry.interval.ms", ConfigDef.Type.INT, (Object)30000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.LOW, "Time elapsed before retrying initialize share group state request. If below offsets.commit.timeout.ms, then value of offsets.commit.timeout.ms is used.").define("group.streams.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The timeout to detect client failures when using the streams group protocol.").define("group.streams.min.session.timeout.ms", ConfigDef.Type.INT, (Object)45000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum allowed value for the group-level configuration of streams.session.timeout.ms").define("group.streams.max.session.timeout.ms", ConfigDef.Type.INT, (Object)60000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum allowed value for the group-level configuration of streams.session.timeout.ms").define("group.streams.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The heartbeat interval given to the members.").define("group.streams.min.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)5000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The minimum allowed value for the group-level configuration of streams.heartbeat.interval.ms").define("group.streams.max.heartbeat.interval.ms", ConfigDef.Type.INT, (Object)15000, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum allowed value for the group-level configuration of streams.heartbeat.interval.ms").define("group.streams.max.size", ConfigDef.Type.INT, (Object)Integer.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.MEDIUM, "The maximum number of streams clients that a single streams group can accommodate.").define("group.streams.num.standby.replicas", ConfigDef.Type.INT, (Object)0, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The number of standby replicas for each task.").define("group.streams.max.standby.replicas", ConfigDef.Type.INT, (Object)2, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.MEDIUM, "The maximum allowed value for the group-level configuration of streams.num.standby.replicas");
    public static final int CLASSIC_GROUP_NEW_MEMBER_JOIN_TIMEOUT_MS = 300000;
    private final int numThreads;
    private final int appendLingerMs;
    private final int consumerGroupSessionTimeoutMs;
    private final int consumerGroupHeartbeatIntervalMs;
    private final int consumerGroupMaxSize;
    private final List<ConsumerGroupPartitionAssignor> consumerGroupAssignors;
    private final int offsetsTopicSegmentBytes;
    private final int offsetMetadataMaxSize;
    private final long offsetsLogCleanerDeleteRetentionMs;
    private final double offsetsLogCleanerMinCleanableDirtyRatio;
    private final long offsetsLogCleanerMaxCompactionLagMs;
    private final int classicGroupMaxSize;
    private final int classicGroupInitialRebalanceDelayMs;
    private final int classicGroupMinSessionTimeoutMs;
    private final int classicGroupMaxSessionTimeoutMs;
    private final long offsetsRetentionCheckIntervalMs;
    private final long offsetsRetentionMs;
    private final int offsetCommitTimeoutMs;
    private final ConsumerGroupMigrationPolicy consumerGroupMigrationPolicy;
    private final CompressionType offsetTopicCompressionType;
    private final int offsetsLoadBufferSize;
    private final int offsetsTopicPartitions;
    private final short offsetsTopicReplicationFactor;
    private final int consumerGroupMinSessionTimeoutMs;
    private final int consumerGroupMaxSessionTimeoutMs;
    private final int consumerGroupMinHeartbeatIntervalMs;
    private final int consumerGroupMaxHeartbeatIntervalMs;
    private final int consumerGroupRegexRefreshIntervalMs;
    private final Optional<TopicPlacement> offsetsTopicPlacementConstraints;
    private final int shareGroupMaxSize;
    private final int shareGroupSessionTimeoutMs;
    private final int shareGroupMinSessionTimeoutMs;
    private final int shareGroupMaxSessionTimeoutMs;
    private final int shareGroupHeartbeatIntervalMs;
    private final int shareGroupMinHeartbeatIntervalMs;
    private final int shareGroupMaxHeartbeatIntervalMs;
    private final List<ShareGroupPartitionAssignor> shareGroupAssignors;
    private final int shareGroupInitializeRetryIntervalMs;
    private final int streamsGroupSessionTimeoutMs;
    private final int streamsGroupMinSessionTimeoutMs;
    private final int streamsGroupMaxSessionTimeoutMs;
    private final int streamsGroupHeartbeatIntervalMs;
    private final int streamsGroupMinHeartbeatIntervalMs;
    private final int streamsGroupMaxHeartbeatIntervalMs;
    private final int streamsGroupMaxSize;
    private final int streamsGroupNumStandbyReplicas;
    private final int streamsGroupMaxStandbyReplicas;
    private final int groupMetadataLoadThreads;
    private final int groupCoordinatorOffsetWriterThreads;
    private final boolean groupCoordinatorOffsetsBatchingEnable;
    private final int groupSubscriptionPatternLogIntervalMs;
    private final boolean groupHighestOffsetCommitRatesLogEnable;
    private final int groupHighestOffsetCommitRatesLogIntervalMs;
    private final int groupHighestOffsetCommitRatesLogCount;
    private final boolean txnOffsetValidationEnable;
    private final boolean dynamicAppendLingerEnable;
    private final int maxPartitionQueueSize;
    private final OptionalInt offsetsTopicMaxMessageBytes;
    private final int groupCoordinatorSlowEventLogIntervalMs;
    private final int groupCoordinatorSlowEventLogCount;

    public GroupCoordinatorConfig(AbstractConfig config) {
        this.numThreads = config.getInt(GROUP_COORDINATOR_NUM_THREADS_CONFIG);
        this.appendLingerMs = config.getInt(GROUP_COORDINATOR_APPEND_LINGER_MS_CONFIG);
        this.consumerGroupSessionTimeoutMs = config.getInt(CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG);
        this.consumerGroupHeartbeatIntervalMs = config.getInt(CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.consumerGroupMaxSize = config.getInt(CONSUMER_GROUP_MAX_SIZE_CONFIG);
        this.consumerGroupAssignors = this.consumerGroupAssignors(config);
        this.offsetsTopicSegmentBytes = config.getInt(OFFSETS_TOPIC_SEGMENT_BYTES_CONFIG);
        this.offsetMetadataMaxSize = config.getInt(OFFSET_METADATA_MAX_SIZE_CONFIG);
        this.offsetsLogCleanerDeleteRetentionMs = config.getLong(OFFSETS_LOG_CLEANER_DELETE_RETENTION_MS_CONFIG);
        this.offsetsLogCleanerMinCleanableDirtyRatio = config.getDouble(OFFSETS_LOG_CLEANER_MIN_CLEANABLE_DIRTY_RATIO_CONFIG);
        this.offsetsLogCleanerMaxCompactionLagMs = config.getLong(OFFSETS_LOG_CLEANER_MAX_COMPACTION_LAG_MS_CONFIG);
        this.classicGroupMaxSize = config.getInt(GROUP_MAX_SIZE_CONFIG);
        this.classicGroupInitialRebalanceDelayMs = config.getInt(GROUP_INITIAL_REBALANCE_DELAY_MS_CONFIG);
        this.classicGroupMinSessionTimeoutMs = config.getInt(GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG);
        this.classicGroupMaxSessionTimeoutMs = config.getInt(GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG);
        this.offsetsRetentionCheckIntervalMs = config.getLong(OFFSETS_RETENTION_CHECK_INTERVAL_MS_CONFIG);
        this.offsetsRetentionMs = (long)config.getInt(OFFSETS_RETENTION_MINUTES_CONFIG).intValue() * 60L * 1000L;
        this.offsetCommitTimeoutMs = config.getInt(OFFSET_COMMIT_TIMEOUT_MS_CONFIG);
        this.consumerGroupMigrationPolicy = ConsumerGroupMigrationPolicy.parse(config.getString(CONSUMER_GROUP_MIGRATION_POLICY_CONFIG));
        this.offsetTopicCompressionType = Optional.ofNullable(config.getInt(OFFSETS_TOPIC_COMPRESSION_CODEC_CONFIG)).map(CompressionType::forId).orElse(null);
        this.offsetsLoadBufferSize = config.getInt(OFFSETS_LOAD_BUFFER_SIZE_CONFIG);
        this.offsetsTopicPartitions = config.getInt(OFFSETS_TOPIC_PARTITIONS_CONFIG);
        this.offsetsTopicReplicationFactor = config.getShort(OFFSETS_TOPIC_REPLICATION_FACTOR_CONFIG);
        this.consumerGroupMinSessionTimeoutMs = config.getInt(CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG);
        this.consumerGroupMaxSessionTimeoutMs = config.getInt(CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG);
        this.consumerGroupMinHeartbeatIntervalMs = config.getInt(CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.consumerGroupMaxHeartbeatIntervalMs = config.getInt(CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.consumerGroupRegexRefreshIntervalMs = config.getInt(CONSUMER_GROUP_REGEX_REFRESH_INTERVAL_MS_CONFIG);
        this.offsetsTopicPlacementConstraints = TopicPlacement.parse((String)config.getString(OFFSET_TOPIC_PLACEMENT_CONSTRAINTS_CONFIG));
        this.shareGroupSessionTimeoutMs = config.getInt(SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG);
        this.shareGroupMinSessionTimeoutMs = config.getInt(SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG);
        this.shareGroupMaxSessionTimeoutMs = config.getInt(SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG);
        this.shareGroupHeartbeatIntervalMs = config.getInt(SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.shareGroupMinHeartbeatIntervalMs = config.getInt(SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.shareGroupMaxHeartbeatIntervalMs = config.getInt(SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.shareGroupMaxSize = config.getInt(SHARE_GROUP_MAX_SIZE_CONFIG);
        this.shareGroupAssignors = this.shareGroupAssignors(config);
        int initializeRetryMs = config.getInt(SHARE_GROUP_INITIALIZE_RETRY_INTERVAL_MS_CONFIG);
        this.shareGroupInitializeRetryIntervalMs = Math.max(initializeRetryMs, this.offsetCommitTimeoutMs);
        this.streamsGroupSessionTimeoutMs = config.getInt(STREAMS_GROUP_SESSION_TIMEOUT_MS_CONFIG);
        this.streamsGroupMinSessionTimeoutMs = config.getInt(STREAMS_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG);
        this.streamsGroupMaxSessionTimeoutMs = config.getInt(STREAMS_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG);
        this.streamsGroupHeartbeatIntervalMs = config.getInt(STREAMS_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.streamsGroupMinHeartbeatIntervalMs = config.getInt(STREAMS_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.streamsGroupMaxHeartbeatIntervalMs = config.getInt(STREAMS_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG);
        this.streamsGroupMaxSize = config.getInt(STREAMS_GROUP_MAX_SIZE_CONFIG);
        this.streamsGroupNumStandbyReplicas = config.getInt(STREAMS_GROUP_NUM_STANDBY_REPLICAS_CONFIG);
        this.streamsGroupMaxStandbyReplicas = config.getInt(STREAMS_GROUP_MAX_STANDBY_REPLICAS_CONFIG);
        this.groupMetadataLoadThreads = config.getInt(GROUP_METADATA_LOAD_THREADS_CONFIG);
        this.groupCoordinatorOffsetWriterThreads = config.getInt(GROUP_COORDINATOR_OFFSET_WRITER_THREADS_CONFIG);
        this.groupCoordinatorOffsetsBatchingEnable = config.getBoolean(GROUP_COORDINATOR_OFFSETS_BATCHING_ENABLE_CONFIG);
        this.groupSubscriptionPatternLogIntervalMs = config.getInt(GROUP_SUBSCRIPTION_PATTERN_LOG_INTERVAL_MS_CONFIG);
        this.groupHighestOffsetCommitRatesLogEnable = config.getBoolean(GROUP_HIGHEST_OFFSET_COMMIT_RATES_LOG_ENABLE_CONFIG);
        this.groupHighestOffsetCommitRatesLogIntervalMs = config.getInt(GROUP_HIGHEST_OFFSET_COMMIT_RATES_LOG_INTERVAL_MS_CONFIG);
        this.groupHighestOffsetCommitRatesLogCount = config.getInt(GROUP_HIGHEST_OFFSET_COMMIT_RATES_LOG_COUNT_CONFIG);
        this.txnOffsetValidationEnable = config.getBoolean(GROUP_COORDINATOR_TXN_OFFSET_VALIDATION_ENABLE);
        this.dynamicAppendLingerEnable = config.getBoolean(GROUP_COORDINATOR_DYNAMIC_APPEND_LINGER_ENABLE_CONFIG);
        this.maxPartitionQueueSize = config.getInt(GROUP_COORDINATOR_MAX_PARTITION_QUEUE_SIZE_CONFIG);
        this.offsetsTopicMaxMessageBytes = Utils.ofSentinel(config.getInt(OFFSETS_TOPIC_MAX_MESSAGE_BYTES_CONFIG));
        this.groupCoordinatorSlowEventLogIntervalMs = config.getInt(GROUP_COORDINATOR_SLOW_EVENT_LOG_INTERVAL_MS_CONFIG);
        this.groupCoordinatorSlowEventLogCount = config.getInt(GROUP_COORDINATOR_SLOW_EVENT_LOG_COUNT_CONFIG);
        org.apache.kafka.common.utils.Utils.require((this.consumerGroupMaxHeartbeatIntervalMs >= this.consumerGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG, CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.consumerGroupHeartbeatIntervalMs >= this.consumerGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, CONSUMER_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.consumerGroupHeartbeatIntervalMs <= this.consumerGroupMaxHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equal to %s", CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, CONSUMER_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.consumerGroupMaxSessionTimeoutMs >= this.consumerGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG, CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.consumerGroupSessionTimeoutMs >= this.consumerGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG, CONSUMER_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.consumerGroupSessionTimeoutMs <= this.consumerGroupMaxSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equal to %s", CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG, CONSUMER_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.consumerGroupHeartbeatIntervalMs < this.consumerGroupSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be less than %s", CONSUMER_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, CONSUMER_GROUP_SESSION_TIMEOUT_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.shareGroupMaxHeartbeatIntervalMs >= this.shareGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG, SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.shareGroupHeartbeatIntervalMs >= this.shareGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, SHARE_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.shareGroupHeartbeatIntervalMs <= this.shareGroupMaxHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equal to %s", SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, SHARE_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.shareGroupMaxSessionTimeoutMs >= this.shareGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG, SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.shareGroupSessionTimeoutMs >= this.shareGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG, SHARE_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.shareGroupSessionTimeoutMs <= this.shareGroupMaxSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equal to %s", SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG, SHARE_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.shareGroupHeartbeatIntervalMs < this.shareGroupSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be less than %s", SHARE_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, SHARE_GROUP_SESSION_TIMEOUT_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.shareGroupAssignors.size() == 1 ? 1 : 0) != 0, (String)String.format("%s must contain exactly one assignor, but found %d", SHARE_GROUP_ASSIGNORS_CONFIG, this.shareGroupAssignors.size()));
        org.apache.kafka.common.utils.Utils.require((this.streamsGroupMaxHeartbeatIntervalMs >= this.streamsGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", STREAMS_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG, STREAMS_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.streamsGroupHeartbeatIntervalMs >= this.streamsGroupMinHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", STREAMS_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, STREAMS_GROUP_MIN_HEARTBEAT_INTERVAL_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.streamsGroupHeartbeatIntervalMs <= this.streamsGroupMaxHeartbeatIntervalMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equal to %s", STREAMS_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, STREAMS_GROUP_MAX_HEARTBEAT_INTERVAL_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.streamsGroupMaxSessionTimeoutMs >= this.streamsGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", STREAMS_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG, STREAMS_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.streamsGroupSessionTimeoutMs >= this.streamsGroupMinSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be greater than or equal to %s", STREAMS_GROUP_SESSION_TIMEOUT_MS_CONFIG, STREAMS_GROUP_MIN_SESSION_TIMEOUT_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.streamsGroupSessionTimeoutMs <= this.streamsGroupMaxSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be less than or equal to %s", STREAMS_GROUP_SESSION_TIMEOUT_MS_CONFIG, STREAMS_GROUP_MAX_SESSION_TIMEOUT_MS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.streamsGroupNumStandbyReplicas <= this.streamsGroupMaxStandbyReplicas ? 1 : 0) != 0, (String)String.format("%s must be less than or equal to %s", STREAMS_GROUP_NUM_STANDBY_REPLICAS_CONFIG, STREAMS_GROUP_MAX_STANDBY_REPLICAS_CONFIG));
        org.apache.kafka.common.utils.Utils.require((this.streamsGroupHeartbeatIntervalMs < this.streamsGroupSessionTimeoutMs ? 1 : 0) != 0, (String)String.format("%s must be less than %s", STREAMS_GROUP_HEARTBEAT_INTERVAL_MS_CONFIG, STREAMS_GROUP_SESSION_TIMEOUT_MS_CONFIG));
    }

    public static GroupCoordinatorConfig fromProps(Map<?, ?> props) {
        return new GroupCoordinatorConfig(new AbstractConfig(CONFIG_DEF, props));
    }

    protected List<ConsumerGroupPartitionAssignor> consumerGroupAssignors(AbstractConfig config) {
        Map defaultAssignors = CONSUMER_GROUP_BUILTIN_ASSIGNORS.stream().collect(Collectors.toMap(PartitionAssignor::name, Function.identity()));
        ArrayList<ConsumerGroupPartitionAssignor> assignors = new ArrayList<ConsumerGroupPartitionAssignor>();
        try {
            for (Object object : config.getList(CONSUMER_GROUP_ASSIGNORS_CONFIG)) {
                ConsumerGroupPartitionAssignor assignor;
                if (object instanceof String) {
                    String klass = (String)object;
                    assignor = (ConsumerGroupPartitionAssignor)defaultAssignors.get(klass);
                    if (assignor == null) {
                        try {
                            assignor = (ConsumerGroupPartitionAssignor)org.apache.kafka.common.utils.Utils.newInstance((String)klass, ConsumerGroupPartitionAssignor.class);
                        }
                        catch (ClassNotFoundException e) {
                            throw new KafkaException("Class " + klass + " cannot be found", (Throwable)e);
                        }
                        catch (ClassCastException e) {
                            throw new KafkaException(klass + " is not an instance of " + ConsumerGroupPartitionAssignor.class.getName());
                        }
                    }
                } else if (object instanceof Class) {
                    Class klass = (Class)object;
                    Object o = org.apache.kafka.common.utils.Utils.newInstance((Class)klass);
                    if (!ConsumerGroupPartitionAssignor.class.isInstance(o)) {
                        throw new KafkaException(String.valueOf(klass) + " is not an instance of " + ConsumerGroupPartitionAssignor.class.getName());
                    }
                    assignor = (ConsumerGroupPartitionAssignor)o;
                } else {
                    throw new KafkaException("Unexpected element of type " + object.getClass().getName() + ", expected String or Class");
                }
                assignors.add(assignor);
                if (!(assignor instanceof Configurable)) continue;
                Configurable configurable = (Configurable)assignor;
                configurable.configure(config.originals());
            }
        }
        catch (Exception e) {
            for (ConsumerGroupPartitionAssignor assignor : assignors) {
                org.apache.kafka.common.utils.Utils.maybeCloseQuietly((Object)assignor, (String)"AutoCloseable object constructed and configured during failed call to consumerGroupAssignors");
            }
            throw e;
        }
        return assignors;
    }

    protected List<ShareGroupPartitionAssignor> shareGroupAssignors(AbstractConfig config) {
        ArrayList<ShareGroupPartitionAssignor> assignors = new ArrayList<ShareGroupPartitionAssignor>();
        try {
            for (String kclass : config.getList(SHARE_GROUP_ASSIGNORS_CONFIG)) {
                ShareGroupPartitionAssignor assignor = SHARE_GROUP_BUILTIN_ASSIGNOR;
                if (!Objects.equals(kclass, SHARE_GROUP_ASSIGNORS_DEFAULT)) {
                    try {
                        assignor = (ShareGroupPartitionAssignor)org.apache.kafka.common.utils.Utils.newInstance((String)kclass, ShareGroupPartitionAssignor.class);
                    }
                    catch (ClassNotFoundException e) {
                        throw new KafkaException("Class " + kclass + " cannot be found", (Throwable)e);
                    }
                    catch (ClassCastException e) {
                        throw new KafkaException(kclass + " is not an instance of " + ShareGroupPartitionAssignor.class.getName());
                    }
                }
                assignors.add(assignor);
                if (!(assignor instanceof Configurable)) continue;
                Configurable configurable = (Configurable)assignor;
                configurable.configure(config.originals());
            }
        }
        catch (Exception e) {
            for (ShareGroupPartitionAssignor assignor : assignors) {
                org.apache.kafka.common.utils.Utils.maybeCloseQuietly((Object)assignor, (String)"AutoCloseable object constructed and configured during failed call to shareGroupAssignors");
            }
            throw e;
        }
        return assignors;
    }

    public Map<String, Integer> extractGroupConfigMap(ShareGroupConfig shareGroupConfig) {
        HashMap<String, Integer> defaultConfigs = new HashMap<String, Integer>();
        defaultConfigs.putAll(this.extractConsumerGroupConfigMap());
        defaultConfigs.putAll(shareGroupConfig.extractShareGroupConfigMap(this));
        return Collections.unmodifiableMap(defaultConfigs);
    }

    public Map<String, Integer> extractConsumerGroupConfigMap() {
        return Map.of("consumer.session.timeout.ms", this.consumerGroupSessionTimeoutMs(), "consumer.heartbeat.interval.ms", this.consumerGroupHeartbeatIntervalMs());
    }

    public int numThreads() {
        return this.numThreads;
    }

    public int appendLingerMs() {
        return this.appendLingerMs;
    }

    public int consumerGroupSessionTimeoutMs() {
        return this.consumerGroupSessionTimeoutMs;
    }

    public int consumerGroupHeartbeatIntervalMs() {
        return this.consumerGroupHeartbeatIntervalMs;
    }

    public int consumerGroupMaxSize() {
        return this.consumerGroupMaxSize;
    }

    public List<ConsumerGroupPartitionAssignor> consumerGroupAssignors() {
        return this.consumerGroupAssignors;
    }

    public int offsetsTopicSegmentBytes() {
        return this.offsetsTopicSegmentBytes;
    }

    public int offsetMetadataMaxSize() {
        return this.offsetMetadataMaxSize;
    }

    public long offsetsLogCleanerDeleteRetentionMs() {
        return this.offsetsLogCleanerDeleteRetentionMs;
    }

    public double offsetsLogCleanerMinCleanableDirtyRatio() {
        return this.offsetsLogCleanerMinCleanableDirtyRatio;
    }

    public long offsetsLogCleanerMaxCompactionLagMs() {
        return this.offsetsLogCleanerMaxCompactionLagMs;
    }

    public int classicGroupMaxSize() {
        return this.classicGroupMaxSize;
    }

    public int classicGroupInitialRebalanceDelayMs() {
        return this.classicGroupInitialRebalanceDelayMs;
    }

    public int classicGroupNewMemberJoinTimeoutMs() {
        return 300000;
    }

    public int classicGroupMinSessionTimeoutMs() {
        return this.classicGroupMinSessionTimeoutMs;
    }

    public int classicGroupMaxSessionTimeoutMs() {
        return this.classicGroupMaxSessionTimeoutMs;
    }

    public long offsetsRetentionCheckIntervalMs() {
        return this.offsetsRetentionCheckIntervalMs;
    }

    public long offsetsRetentionMs() {
        return this.offsetsRetentionMs;
    }

    public int offsetCommitTimeoutMs() {
        return this.offsetCommitTimeoutMs;
    }

    public ConsumerGroupMigrationPolicy consumerGroupMigrationPolicy() {
        return this.consumerGroupMigrationPolicy;
    }

    public CompressionType offsetsTopicCompressionType() {
        return this.offsetTopicCompressionType;
    }

    public int offsetsLoadBufferSize() {
        return this.offsetsLoadBufferSize;
    }

    public int offsetsTopicPartitions() {
        return this.offsetsTopicPartitions;
    }

    public short offsetsTopicReplicationFactor() {
        return this.offsetsTopicReplicationFactor;
    }

    public int consumerGroupMinSessionTimeoutMs() {
        return this.consumerGroupMinSessionTimeoutMs;
    }

    public int consumerGroupMaxSessionTimeoutMs() {
        return this.consumerGroupMaxSessionTimeoutMs;
    }

    public int consumerGroupMinHeartbeatIntervalMs() {
        return this.consumerGroupMinHeartbeatIntervalMs;
    }

    public int consumerGroupMaxHeartbeatIntervalMs() {
        return this.consumerGroupMaxHeartbeatIntervalMs;
    }

    public int consumerGroupRegexRefreshIntervalMs() {
        return this.consumerGroupRegexRefreshIntervalMs;
    }

    public Optional<TopicPlacement> offsetsTopicPlacementConstraints() {
        return this.offsetsTopicPlacementConstraints;
    }

    public int shareGroupSessionTimeoutMs() {
        return this.shareGroupSessionTimeoutMs;
    }

    public int shareGroupHeartbeatIntervalMs() {
        return this.shareGroupHeartbeatIntervalMs;
    }

    public int shareGroupMaxSize() {
        return this.shareGroupMaxSize;
    }

    public int shareGroupMinSessionTimeoutMs() {
        return this.shareGroupMinSessionTimeoutMs;
    }

    public int shareGroupMaxSessionTimeoutMs() {
        return this.shareGroupMaxSessionTimeoutMs;
    }

    public int shareGroupMinHeartbeatIntervalMs() {
        return this.shareGroupMinHeartbeatIntervalMs;
    }

    public int shareGroupMaxHeartbeatIntervalMs() {
        return this.shareGroupMaxHeartbeatIntervalMs;
    }

    public List<ShareGroupPartitionAssignor> shareGroupAssignors() {
        return this.shareGroupAssignors;
    }

    public int groupMetadataLoadThreads() {
        return this.groupMetadataLoadThreads;
    }

    public int groupCoordinatorOffsetWriterThreads() {
        return this.groupCoordinatorOffsetWriterThreads;
    }

    public boolean groupCoordinatorOffsetsBatchingEnable() {
        return this.groupCoordinatorOffsetsBatchingEnable;
    }

    public int classicGroupSubscriptionPatternLogIntervalMs() {
        return this.groupSubscriptionPatternLogIntervalMs;
    }

    public boolean groupHighestOffsetCommitRatesLogEnable() {
        return this.groupHighestOffsetCommitRatesLogEnable;
    }

    public int groupHighestOffsetCommitRatesLogIntervalMs() {
        return this.groupHighestOffsetCommitRatesLogIntervalMs;
    }

    public int groupHighestOffsetCommitRatesLogCount() {
        return this.groupHighestOffsetCommitRatesLogCount;
    }

    public boolean txnOffsetValidationEnable() {
        return this.txnOffsetValidationEnable;
    }

    public boolean dynamicAppendLingerEnable() {
        return this.dynamicAppendLingerEnable;
    }

    public int maxPartitionQueueSize() {
        return this.maxPartitionQueueSize;
    }

    public OptionalInt offsetsTopicMaxMessageBytes() {
        return this.offsetsTopicMaxMessageBytes;
    }

    public boolean groupCoordinatorSlowEventLogEnable() {
        return this.groupCoordinatorSlowEventLogIntervalMs >= 0 && this.groupCoordinatorSlowEventLogCount > 0;
    }

    public int groupCoordinatorSlowEventLogIntervalMs() {
        return this.groupCoordinatorSlowEventLogIntervalMs;
    }

    public int groupCoordinatorSlowEventLogCount() {
        return this.groupCoordinatorSlowEventLogCount;
    }

    public int shareGroupInitializeRetryIntervalMs() {
        return this.shareGroupInitializeRetryIntervalMs;
    }

    public int streamsGroupSessionTimeoutMs() {
        return this.streamsGroupSessionTimeoutMs;
    }

    public int streamsGroupMaxSessionTimeoutMs() {
        return this.streamsGroupMaxSessionTimeoutMs;
    }

    public int streamsGroupMinSessionTimeoutMs() {
        return this.streamsGroupMinSessionTimeoutMs;
    }

    public int streamsGroupHeartbeatIntervalMs() {
        return this.streamsGroupHeartbeatIntervalMs;
    }

    public int streamsGroupMinHeartbeatIntervalMs() {
        return this.streamsGroupMinHeartbeatIntervalMs;
    }

    public int streamsGroupMaxHeartbeatIntervalMs() {
        return this.streamsGroupMaxHeartbeatIntervalMs;
    }

    public int streamsGroupMaxSize() {
        return this.streamsGroupMaxSize;
    }

    public int streamsGroupNumStandbyReplicas() {
        return this.streamsGroupNumStandbyReplicas;
    }

    public int streamsGroupMaxNumStandbyReplicas() {
        return this.streamsGroupMaxStandbyReplicas;
    }
}

