/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.StaleMemberEpochException;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.message.OffsetDeleteRequestData;
import org.apache.kafka.common.message.OffsetDeleteResponseData;
import org.apache.kafka.common.message.OffsetFetchRequestData;
import org.apache.kafka.common.message.OffsetFetchResponseData;
import org.apache.kafka.common.message.TxnOffsetCommitRequestData;
import org.apache.kafka.common.message.TxnOffsetCommitResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.common.runtime.CoordinatorRecord;
import org.apache.kafka.coordinator.common.runtime.CoordinatorResult;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.GroupCoordinatorConfig;
import org.apache.kafka.coordinator.group.GroupCoordinatorRecordHelpers;
import org.apache.kafka.coordinator.group.GroupMetadataManager;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.OffsetExpirationCondition;
import org.apache.kafka.coordinator.group.classic.ClassicGroup;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.metrics.GroupCoordinatorMetricsShard;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.apache.kafka.timeline.TimelineHashSet;
import org.slf4j.Logger;

public class OffsetMetadataManager {
    private final Logger log;
    private final SnapshotRegistry snapshotRegistry;
    private final Time time;
    private final GroupMetadataManager groupMetadataManager;
    private final GroupCoordinatorMetricsShard metrics;
    private final GroupCoordinatorConfig config;
    private final Offsets offsets;
    private final TimelineHashMap<Long, Offsets> pendingTransactionalOffsets;
    private final OpenTransactions openTransactions;

    OffsetMetadataManager(SnapshotRegistry snapshotRegistry, LogContext logContext, Time time, MetadataImage metadataImage, GroupMetadataManager groupMetadataManager, GroupCoordinatorConfig config, GroupCoordinatorMetricsShard metrics) {
        this.snapshotRegistry = snapshotRegistry;
        this.log = logContext.logger(OffsetMetadataManager.class);
        this.time = time;
        this.groupMetadataManager = groupMetadataManager;
        this.config = config;
        this.metrics = metrics;
        this.offsets = new Offsets();
        this.pendingTransactionalOffsets = new TimelineHashMap(snapshotRegistry, 0);
        this.openTransactions = new OpenTransactions();
    }

    private Group validateOffsetCommit(AuthorizableRequestContext context, OffsetCommitRequestData request) throws ApiException {
        Group group;
        try {
            group = this.groupMetadataManager.group(request.groupId());
        }
        catch (GroupIdNotFoundException ex) {
            if (request.generationIdOrMemberEpoch() < 0) {
                this.log.info("[GroupId {}] Creating a simple consumer group via manual offset commit.", (Object)request.groupId());
                group = this.groupMetadataManager.getOrMaybeCreateClassicGroup(request.groupId(), true);
            }
            if (context.requestVersion() >= 9) {
                throw ex;
            }
            throw Errors.ILLEGAL_GENERATION.exception();
        }
        group.validateOffsetCommit(request.memberId(), request.groupInstanceId(), request.generationIdOrMemberEpoch(), false, context.requestVersion());
        return group;
    }

    private Group validateTransactionalOffsetCommit(AuthorizableRequestContext context, TxnOffsetCommitRequestData request) throws ApiException {
        Group group;
        try {
            group = this.groupMetadataManager.group(request.groupId());
        }
        catch (GroupIdNotFoundException ex) {
            if (request.generationId() < 0) {
                group = this.groupMetadataManager.getOrMaybeCreateClassicGroup(request.groupId(), true);
            }
            throw Errors.ILLEGAL_GENERATION.exception();
        }
        try {
            group.validateOffsetCommit(request.memberId(), request.groupInstanceId(), request.generationId(), true, context.requestVersion());
        }
        catch (StaleMemberEpochException ex) {
            throw Errors.ILLEGAL_GENERATION.exception();
        }
        return group;
    }

    private void validateOffsetFetch(OffsetFetchRequestData.OffsetFetchRequestGroup request, long lastCommittedOffset) throws GroupIdNotFoundException {
        Group group = this.groupMetadataManager.group(request.groupId(), lastCommittedOffset);
        group.validateOffsetFetch(request.memberId(), request.memberEpoch(), lastCommittedOffset);
    }

    private Group validateOffsetDelete(OffsetDeleteRequestData request) throws GroupIdNotFoundException {
        Group group = this.groupMetadataManager.group(request.groupId());
        group.validateOffsetDelete();
        return group;
    }

    private boolean isMetadataInvalid(String metadata) {
        return metadata != null && metadata.length() > this.config.offsetMetadataMaxSize();
    }

    private static OptionalLong expireTimestampMs(long retentionTimeMs, long currentTimeMs) {
        return retentionTimeMs == -1L ? OptionalLong.empty() : OptionalLong.of(currentTimeMs + retentionTimeMs);
    }

    public CoordinatorResult<OffsetCommitResponseData, CoordinatorRecord> commitOffset(AuthorizableRequestContext context, OffsetCommitRequestData request) throws ApiException {
        ClassicGroup classicGroup;
        Group group = this.validateOffsetCommit(context, request);
        if (group.type() == Group.GroupType.CLASSIC && ((classicGroup = (ClassicGroup)group).isInState(ClassicGroupState.STABLE) || classicGroup.isInState(ClassicGroupState.PREPARING_REBALANCE))) {
            this.groupMetadataManager.rescheduleClassicGroupMemberHeartbeat(classicGroup, classicGroup.member(request.memberId()));
        }
        OffsetCommitResponseData response = new OffsetCommitResponseData();
        ArrayList records = new ArrayList();
        long currentTimeMs = this.time.milliseconds();
        OptionalLong expireTimestampMs = OffsetMetadataManager.expireTimestampMs(request.retentionTimeMs(), currentTimeMs);
        request.topics().forEach(topic -> {
            OffsetCommitResponseData.OffsetCommitResponseTopic topicResponse = new OffsetCommitResponseData.OffsetCommitResponseTopic().setTopicId(topic.topicId()).setName(topic.name());
            response.topics().add(topicResponse);
            topic.partitions().forEach(partition -> {
                if (this.isMetadataInvalid(partition.committedMetadata())) {
                    topicResponse.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(Errors.OFFSET_METADATA_TOO_LARGE.code()));
                } else {
                    this.log.debug("[GroupId {}] Committing offsets {} for partition {}-{}-{} from member {} with leader epoch {}.", new Object[]{request.groupId(), partition.committedOffset(), topic.topicId(), topic.name(), partition.partitionIndex(), request.memberId(), partition.committedLeaderEpoch()});
                    topicResponse.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(Errors.NONE.code()));
                    OffsetAndMetadata offsetAndMetadata = OffsetAndMetadata.fromRequest(topic.topicId(), partition, currentTimeMs, expireTimestampMs);
                    records.add(GroupCoordinatorRecordHelpers.newOffsetCommitRecord(request.groupId(), topic.name(), partition.partitionIndex(), offsetAndMetadata));
                }
            });
        });
        if (!records.isEmpty()) {
            this.metrics.record("OffsetCommits", records.size());
        }
        return new CoordinatorResult(records, (Object)response);
    }

    public CoordinatorResult<TxnOffsetCommitResponseData, CoordinatorRecord> commitTransactionalOffset(AuthorizableRequestContext context, TxnOffsetCommitRequestData request) throws ApiException {
        this.validateTransactionalOffsetCommit(context, request);
        TxnOffsetCommitResponseData response = new TxnOffsetCommitResponseData();
        ArrayList records = new ArrayList();
        long currentTimeMs = this.time.milliseconds();
        request.topics().forEach(topic -> {
            TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic topicResponse = new TxnOffsetCommitResponseData.TxnOffsetCommitResponseTopic().setName(topic.name());
            response.topics().add(topicResponse);
            topic.partitions().forEach(partition -> {
                if (this.isMetadataInvalid(partition.committedMetadata())) {
                    topicResponse.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(Errors.OFFSET_METADATA_TOO_LARGE.code()));
                } else {
                    this.log.debug("[GroupId {}] Committing transactional offsets {} for partition {}-{} from member {} with leader epoch {}.", new Object[]{request.groupId(), partition.committedOffset(), topic.name(), partition.partitionIndex(), request.memberId(), partition.committedLeaderEpoch()});
                    topicResponse.partitions().add(new TxnOffsetCommitResponseData.TxnOffsetCommitResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(Errors.NONE.code()));
                    OffsetAndMetadata offsetAndMetadata = OffsetAndMetadata.fromRequest(partition, currentTimeMs);
                    records.add(GroupCoordinatorRecordHelpers.newOffsetCommitRecord(request.groupId(), topic.name(), partition.partitionIndex(), offsetAndMetadata));
                }
            });
        });
        if (!records.isEmpty()) {
            this.metrics.record("OffsetCommits", records.size());
        }
        return new CoordinatorResult(records, (Object)response);
    }

    public CoordinatorResult<OffsetDeleteResponseData, CoordinatorRecord> deleteOffsets(OffsetDeleteRequestData request) throws ApiException {
        Group group = this.validateOffsetDelete(request);
        ArrayList records = new ArrayList();
        OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection responseTopicCollection = new OffsetDeleteResponseData.OffsetDeleteResponseTopicCollection();
        request.topics().forEach(topic -> {
            OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection responsePartitionCollection = new OffsetDeleteResponseData.OffsetDeleteResponsePartitionCollection();
            if (group.isSubscribedToTopic(topic.name())) {
                topic.partitions().forEach(partition -> responsePartitionCollection.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(Errors.GROUP_SUBSCRIBED_TO_TOPIC.code())));
            } else {
                topic.partitions().forEach(partition -> {
                    responsePartitionCollection.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponsePartition().setPartitionIndex(partition.partitionIndex()));
                    if (this.hasCommittedOffset(request.groupId(), topic.name(), partition.partitionIndex()) || this.hasPendingTransactionalOffsets(request.groupId(), topic.name(), partition.partitionIndex())) {
                        records.add(GroupCoordinatorRecordHelpers.newOffsetCommitTombstoneRecord(request.groupId(), topic.name(), partition.partitionIndex()));
                    }
                });
            }
            responseTopicCollection.add((ImplicitLinkedHashCollection.Element)new OffsetDeleteResponseData.OffsetDeleteResponseTopic().setName(topic.name()).setPartitions(responsePartitionCollection));
        });
        this.metrics.record("OffsetDeletions", records.size());
        return new CoordinatorResult(records, (Object)new OffsetDeleteResponseData().setTopics(responseTopicCollection));
    }

    public int deleteAllOffsets(String groupId, List<CoordinatorRecord> records) {
        TimelineHashMap offsetsByTopic = (TimelineHashMap)this.offsets.offsetsByGroup.get((Object)groupId);
        AtomicInteger numDeletedOffsets = new AtomicInteger();
        if (offsetsByTopic != null) {
            offsetsByTopic.forEach((topic, offsetsByPartition) -> offsetsByPartition.keySet().forEach(partition -> {
                records.add(GroupCoordinatorRecordHelpers.newOffsetCommitTombstoneRecord(groupId, topic, partition));
                numDeletedOffsets.getAndIncrement();
            }));
        }
        this.openTransactions.forEachTopicPartition(groupId, (topic, partition) -> {
            if (!this.hasCommittedOffset(groupId, (String)topic, (int)partition)) {
                records.add(GroupCoordinatorRecordHelpers.newOffsetCommitTombstoneRecord(groupId, topic, partition));
                numDeletedOffsets.getAndIncrement();
            }
        });
        return numDeletedOffsets.get();
    }

    boolean hasPendingTransactionalOffsets(String groupId, String topic, int partition) {
        return this.openTransactions.contains(groupId, topic, partition);
    }

    boolean hasCommittedOffset(String groupId, String topic, int partition) {
        return this.offsets.get(groupId, topic, partition) != null;
    }

    public OffsetFetchResponseData.OffsetFetchResponseGroup fetchOffsets(OffsetFetchRequestData.OffsetFetchRequestGroup request, long lastCommittedOffset) throws ApiException {
        boolean requireStable = lastCommittedOffset == Long.MAX_VALUE;
        boolean failAllPartitions = false;
        try {
            this.validateOffsetFetch(request, lastCommittedOffset);
        }
        catch (GroupIdNotFoundException ex) {
            failAllPartitions = true;
        }
        ArrayList topicResponses = new ArrayList(request.topics().size());
        TimelineHashMap groupOffsets = failAllPartitions ? null : (TimelineHashMap)this.offsets.offsetsByGroup.get((Object)request.groupId(), lastCommittedOffset);
        TimelineHashMap openTransactionsByTopic = requireStable ? (TimelineHashMap)this.openTransactions.openTransactionsByGroup.get((Object)request.groupId(), lastCommittedOffset) : null;
        request.topics().forEach(topic -> {
            OffsetFetchResponseData.OffsetFetchResponseTopics topicResponse = new OffsetFetchResponseData.OffsetFetchResponseTopics().setTopicId(topic.topicId()).setName(topic.name());
            topicResponses.add(topicResponse);
            TimelineHashMap topicOffsets = groupOffsets == null ? null : (TimelineHashMap)groupOffsets.get((Object)topic.name(), lastCommittedOffset);
            TimelineHashMap openTransactionsByPartition = requireStable && openTransactionsByTopic != null ? (TimelineHashMap)openTransactionsByTopic.get((Object)topic.name(), lastCommittedOffset) : null;
            topic.partitionIndexes().forEach(partitionIndex -> {
                OffsetAndMetadata offsetAndMetadata;
                OffsetAndMetadata offsetAndMetadata2 = offsetAndMetadata = topicOffsets == null ? null : (OffsetAndMetadata)topicOffsets.get(partitionIndex, lastCommittedOffset);
                if (requireStable && openTransactionsByPartition != null && openTransactionsByPartition.containsKey(partitionIndex, lastCommittedOffset)) {
                    topicResponse.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partitionIndex.intValue()).setErrorCode(Errors.UNSTABLE_OFFSET_COMMIT.code()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata(""));
                } else if (OffsetMetadataManager.isOffsetInvalid(offsetAndMetadata, topic.topicId())) {
                    topicResponse.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partitionIndex.intValue()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata(""));
                } else {
                    topicResponse.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partitionIndex.intValue()).setCommittedOffset(offsetAndMetadata.committedOffset).setCommittedLeaderEpoch(offsetAndMetadata.leaderEpoch.orElse(-1)).setMetadata(offsetAndMetadata.metadata));
                }
            });
        });
        return new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setTopics(topicResponses);
    }

    private static boolean isOffsetInvalid(OffsetAndMetadata offsetAndMetadata, Uuid expectedTopicId) {
        return offsetAndMetadata == null || OffsetMetadataManager.isMismatchedTopicId(offsetAndMetadata.topicId, expectedTopicId);
    }

    private static boolean isMismatchedTopicId(Uuid actual, Uuid expected) {
        return !actual.equals((Object)Uuid.ZERO_UUID) && !expected.equals((Object)Uuid.ZERO_UUID) && !actual.equals((Object)expected);
    }

    public OffsetFetchResponseData.OffsetFetchResponseGroup fetchAllOffsets(OffsetFetchRequestData.OffsetFetchRequestGroup request, long lastCommittedOffset) throws ApiException {
        TimelineHashMap openTransactionsByTopic;
        boolean requireStable = lastCommittedOffset == Long.MAX_VALUE;
        try {
            this.validateOffsetFetch(request, lastCommittedOffset);
        }
        catch (GroupIdNotFoundException ex) {
            return new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setTopics(List.of());
        }
        ArrayList topicResponses = new ArrayList();
        TimelineHashMap groupOffsets = (TimelineHashMap)this.offsets.offsetsByGroup.get((Object)request.groupId(), lastCommittedOffset);
        TimelineHashMap timelineHashMap = openTransactionsByTopic = requireStable ? (TimelineHashMap)this.openTransactions.openTransactionsByGroup.get((Object)request.groupId(), lastCommittedOffset) : null;
        if (groupOffsets != null) {
            groupOffsets.entrySet(lastCommittedOffset).forEach(topicEntry -> {
                String topic = (String)topicEntry.getKey();
                TimelineHashMap topicOffsets = (TimelineHashMap)topicEntry.getValue();
                TimelineHashMap openTransactionsByPartition = requireStable && openTransactionsByTopic != null ? (TimelineHashMap)openTransactionsByTopic.get((Object)topic, lastCommittedOffset) : null;
                OffsetFetchResponseData.OffsetFetchResponseTopics topicResponse = new OffsetFetchResponseData.OffsetFetchResponseTopics().setTopicId(Uuid.ZERO_UUID).setName(topic);
                topicResponses.add(topicResponse);
                topicOffsets.entrySet(lastCommittedOffset).forEach(partitionEntry -> {
                    int partition = (Integer)partitionEntry.getKey();
                    OffsetAndMetadata offsetAndMetadata = (OffsetAndMetadata)partitionEntry.getValue();
                    if (requireStable && openTransactionsByPartition != null && openTransactionsByPartition.containsKey((Object)partition, lastCommittedOffset)) {
                        topicResponse.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partition).setErrorCode(Errors.UNSTABLE_OFFSET_COMMIT.code()).setCommittedOffset(-1L).setCommittedLeaderEpoch(-1).setMetadata(""));
                    } else {
                        topicResponse.partitions().add(new OffsetFetchResponseData.OffsetFetchResponsePartitions().setPartitionIndex(partition).setCommittedOffset(offsetAndMetadata.committedOffset).setCommittedLeaderEpoch(offsetAndMetadata.leaderEpoch.orElse(-1)).setMetadata(offsetAndMetadata.metadata));
                    }
                });
            });
        }
        return new OffsetFetchResponseData.OffsetFetchResponseGroup().setGroupId(request.groupId()).setTopics(topicResponses);
    }

    public boolean cleanupExpiredOffsets(String groupId, List<CoordinatorRecord> records) {
        TimelineHashMap offsetsByTopic = (TimelineHashMap)this.offsets.offsetsByGroup.get((Object)groupId);
        if (offsetsByTopic == null) {
            return !this.openTransactions.contains(groupId);
        }
        Group group = this.groupMetadataManager.group(groupId);
        long currentTimestampMs = this.time.milliseconds();
        Optional<OffsetExpirationCondition> offsetExpirationCondition = group.offsetExpirationCondition();
        if (offsetExpirationCondition.isEmpty()) {
            return false;
        }
        AtomicBoolean allOffsetsExpired = new AtomicBoolean(true);
        OffsetExpirationCondition condition = offsetExpirationCondition.get();
        offsetsByTopic.forEach((topic, partitions) -> {
            if (!group.isSubscribedToTopic((String)topic)) {
                partitions.forEach((partition, offsetAndMetadata) -> {
                    if (condition.isOffsetExpired((OffsetAndMetadata)offsetAndMetadata, currentTimestampMs, this.config.offsetsRetentionMs()) && !this.hasPendingTransactionalOffsets(groupId, (String)topic, (int)partition)) {
                        this.appendOffsetCommitTombstone(groupId, (String)topic, (int)partition, records);
                        this.log.debug("[GroupId {}] Expired offset for partition={}-{}", new Object[]{groupId, topic, partition});
                    } else {
                        allOffsetsExpired.set(false);
                    }
                });
            } else {
                allOffsetsExpired.set(false);
            }
        });
        this.metrics.record("OffsetExpired", records.size());
        return allOffsetsExpired.get() && !this.openTransactions.contains(groupId);
    }

    public List<CoordinatorRecord> onPartitionsDeleted(List<TopicPartition> topicPartitions) {
        ArrayList<CoordinatorRecord> records = new ArrayList<CoordinatorRecord>();
        HashMap partitionsByTopic = new HashMap();
        topicPartitions.forEach(tp -> partitionsByTopic.computeIfAbsent(tp.topic(), __ -> new ArrayList()).add(tp.partition()));
        Consumer<Offsets> delete = offsetsToClean -> offsetsToClean.offsetsByGroup.forEach((groupId, topicOffsets) -> topicOffsets.forEach((topic, partitionOffsets) -> {
            if (partitionsByTopic.containsKey(topic)) {
                ((List)partitionsByTopic.get(topic)).forEach(partition -> {
                    if (partitionOffsets.containsKey(partition)) {
                        this.appendOffsetCommitTombstone((String)groupId, (String)topic, (int)partition, records);
                    }
                });
            }
        }));
        delete.accept(this.offsets);
        this.pendingTransactionalOffsets.forEach((__, offsets) -> delete.accept((Offsets)offsets));
        return records;
    }

    private void appendOffsetCommitTombstone(String groupId, String topic, int partition, List<CoordinatorRecord> records) {
        records.add(GroupCoordinatorRecordHelpers.newOffsetCommitTombstoneRecord(groupId, topic, partition));
        this.log.trace("[GroupId {}] Removing expired offset and metadata for {}-{}", new Object[]{groupId, topic, partition});
    }

    public void replay(long recordOffset, long producerId, OffsetCommitKey key, OffsetCommitValue value) {
        String groupId = key.group();
        String topic = key.topic();
        int partition = key.partition();
        if (value != null) {
            try {
                this.groupMetadataManager.group(groupId);
            }
            catch (GroupIdNotFoundException ex) {
                this.groupMetadataManager.getOrMaybeCreateClassicGroup(groupId, true);
            }
            if (producerId == -1L) {
                this.log.debug("Replaying offset commit with key {}, value {}", (Object)key, (Object)value);
                OffsetAndMetadata previousValue = this.offsets.put(groupId, topic, partition, OffsetAndMetadata.fromRecord(recordOffset, value));
                if (previousValue == null) {
                    this.metrics.incrementNumOffsets();
                }
            } else {
                this.log.debug("Replaying transactional offset commit with producer id {}, key {}, value {}", new Object[]{producerId, key, value});
                OffsetAndMetadata newValue = OffsetAndMetadata.fromRecord(recordOffset, value);
                OffsetAndMetadata previousValue = ((Offsets)this.pendingTransactionalOffsets.computeIfAbsent((Object)producerId, __ -> new Offsets())).put(groupId, topic, partition, newValue);
                this.openTransactions.add(groupId, topic, partition, producerId);
                if (previousValue != null && previousValue.committedOffset > newValue.committedOffset) {
                    this.log.warn("TxnOffsetCommit for producer {}, group {}, and partition {}-{} is replacing a newer offset {} with older offset {}", new Object[]{producerId, groupId, topic, partition, previousValue, newValue});
                }
            }
        } else {
            if (this.offsets.remove(groupId, topic, partition) != null) {
                this.metrics.decrementNumOffsets();
            }
            this.openTransactions.forEach(groupId, topic, partition, openProducerId -> {
                Offsets pendingOffsets = (Offsets)this.pendingTransactionalOffsets.get(openProducerId);
                if (pendingOffsets != null) {
                    pendingOffsets.remove(groupId, topic, partition);
                }
            });
            this.openTransactions.clear(groupId, topic, partition);
        }
    }

    public void replayEndTransactionMarker(long producerId, TransactionResult result) throws RuntimeException {
        Offsets pendingOffsets = (Offsets)this.pendingTransactionalOffsets.remove((Object)producerId);
        if (pendingOffsets == null) {
            this.log.debug("Replayed end transaction marker with result {} for producer id {} but no pending offsets are present. Ignoring it.", (Object)result, (Object)producerId);
            return;
        }
        pendingOffsets.offsetsByGroup.forEach((groupId, topicOffsets) -> topicOffsets.forEach((topic, partitionOffsets) -> partitionOffsets.keySet().forEach(partitionId -> this.openTransactions.remove((String)groupId, (String)topic, (int)partitionId, producerId))));
        if (result == TransactionResult.COMMIT) {
            this.log.debug("Committed transactional offset commits for producer id {}.", (Object)producerId);
            pendingOffsets.offsetsByGroup.forEach((groupId, topicOffsets) -> topicOffsets.forEach((topicName, partitionOffsets) -> partitionOffsets.forEach((partitionId, offsetAndMetadata) -> {
                OffsetAndMetadata existingOffsetAndMetadata = this.offsets.get((String)groupId, (String)topicName, (int)partitionId);
                if (existingOffsetAndMetadata == null || offsetAndMetadata.recordOffset > existingOffsetAndMetadata.recordOffset) {
                    this.log.debug("Committed transactional offset commit {} for producer id {} in group {} with topic {} and partition {}.", new Object[]{offsetAndMetadata, producerId, groupId, topicName, partitionId});
                    OffsetAndMetadata previousValue = this.offsets.put((String)groupId, (String)topicName, (int)partitionId, (OffsetAndMetadata)offsetAndMetadata);
                    if (previousValue == null) {
                        this.metrics.incrementNumOffsets();
                    }
                } else {
                    this.log.info("Skipped the materialization of transactional offset commit {} for producer id {} in group {} with topic {}, partition {} since its record offset {} is smaller than the record offset {} of the last committed offset.", new Object[]{offsetAndMetadata, producerId, groupId, topicName, partitionId, offsetAndMetadata.recordOffset, existingOffsetAndMetadata.recordOffset});
                }
            })));
        } else {
            this.log.debug("Aborted transactional offset commits for producer id {}.", (Object)producerId);
        }
    }

    OffsetAndMetadata offset(String groupId, String topic, int partition) {
        return this.offsets.get(groupId, topic, partition);
    }

    OffsetAndMetadata pendingTransactionalOffset(long producerId, String groupId, String topic, int partition) {
        Offsets offsets = (Offsets)this.pendingTransactionalOffsets.get((Object)producerId);
        if (offsets == null) {
            return null;
        }
        return offsets.get(groupId, topic, partition);
    }

    private class Offsets {
        private final TimelineHashMap<String, TimelineHashMap<String, TimelineHashMap<Integer, OffsetAndMetadata>>> offsetsByGroup;

        private Offsets() {
            this.offsetsByGroup = new TimelineHashMap(OffsetMetadataManager.this.snapshotRegistry, 0);
        }

        private OffsetAndMetadata get(String groupId, String topic, int partition) {
            TimelineHashMap topicOffsets = (TimelineHashMap)this.offsetsByGroup.get((Object)groupId);
            if (topicOffsets == null) {
                return null;
            }
            TimelineHashMap partitionOffsets = (TimelineHashMap)topicOffsets.get((Object)topic);
            if (partitionOffsets == null) {
                return null;
            }
            return (OffsetAndMetadata)partitionOffsets.get((Object)partition);
        }

        private OffsetAndMetadata put(String groupId, String topic, int partition, OffsetAndMetadata offsetAndMetadata) {
            TimelineHashMap topicOffsets = (TimelineHashMap)this.offsetsByGroup.computeIfAbsent((Object)groupId, __ -> new TimelineHashMap(OffsetMetadataManager.this.snapshotRegistry, 0));
            TimelineHashMap partitionOffsets = (TimelineHashMap)topicOffsets.computeIfAbsent((Object)topic, __ -> new TimelineHashMap(OffsetMetadataManager.this.snapshotRegistry, 0));
            return (OffsetAndMetadata)partitionOffsets.put((Object)partition, (Object)offsetAndMetadata);
        }

        private OffsetAndMetadata remove(String groupId, String topic, int partition) {
            TimelineHashMap topicOffsets = (TimelineHashMap)this.offsetsByGroup.get((Object)groupId);
            if (topicOffsets == null) {
                return null;
            }
            TimelineHashMap partitionOffsets = (TimelineHashMap)topicOffsets.get((Object)topic);
            if (partitionOffsets == null) {
                return null;
            }
            OffsetAndMetadata removedValue = (OffsetAndMetadata)partitionOffsets.remove((Object)partition);
            if (partitionOffsets.isEmpty()) {
                topicOffsets.remove((Object)topic);
            }
            if (topicOffsets.isEmpty()) {
                this.offsetsByGroup.remove((Object)groupId);
            }
            return removedValue;
        }
    }

    private class OpenTransactions {
        private final TimelineHashMap<String, TimelineHashMap<String, TimelineHashMap<Integer, TimelineHashSet<Long>>>> openTransactionsByGroup;

        private OpenTransactions() {
            this.openTransactionsByGroup = new TimelineHashMap(OffsetMetadataManager.this.snapshotRegistry, 0);
        }

        private boolean add(String groupId, String topic, int partition, long producerId) {
            return ((TimelineHashSet)((TimelineHashMap)((TimelineHashMap)this.openTransactionsByGroup.computeIfAbsent((Object)groupId, __ -> new TimelineHashMap(OffsetMetadataManager.this.snapshotRegistry, 1))).computeIfAbsent((Object)topic, __ -> new TimelineHashMap(OffsetMetadataManager.this.snapshotRegistry, 1))).computeIfAbsent((Object)partition, __ -> new TimelineHashSet(OffsetMetadataManager.this.snapshotRegistry, 1))).add((Object)producerId);
        }

        private void clear(String groupId, String topic, int partition) {
            TimelineHashMap openTransactionsByTopic = (TimelineHashMap)this.openTransactionsByGroup.get((Object)groupId);
            if (openTransactionsByTopic == null) {
                return;
            }
            TimelineHashMap openTransactionsByPartition = (TimelineHashMap)openTransactionsByTopic.get((Object)topic);
            if (openTransactionsByPartition == null) {
                return;
            }
            openTransactionsByPartition.remove((Object)partition);
            if (openTransactionsByPartition.isEmpty()) {
                openTransactionsByTopic.remove((Object)topic);
                if (openTransactionsByTopic.isEmpty()) {
                    this.openTransactionsByGroup.remove((Object)groupId);
                }
            }
        }

        private boolean contains(String groupId) {
            return this.openTransactionsByGroup.containsKey((Object)groupId);
        }

        private boolean contains(String groupId, String topic, int partition) {
            TimelineHashSet<Long> openTransactions = this.get(groupId, topic, partition);
            return openTransactions != null;
        }

        private void forEachTopicPartition(String groupId, BiConsumer<String, Integer> action) {
            TimelineHashMap openTransactionsByTopic = (TimelineHashMap)this.openTransactionsByGroup.get((Object)groupId);
            if (openTransactionsByTopic == null) {
                return;
            }
            openTransactionsByTopic.forEach((topic, openTransactionsByPartition) -> openTransactionsByPartition.forEach((partition, producerIds) -> action.accept((String)topic, (Integer)partition)));
        }

        private void forEach(String groupId, String topic, int partition, Consumer<Long> action) {
            TimelineHashSet<Long> openTransactions = this.get(groupId, topic, partition);
            if (openTransactions == null) {
                return;
            }
            openTransactions.forEach(action);
        }

        private TimelineHashSet<Long> get(String groupId, String topic, int partition) {
            TimelineHashMap openTransactionsByTopic = (TimelineHashMap)this.openTransactionsByGroup.get((Object)groupId);
            if (openTransactionsByTopic == null) {
                return null;
            }
            TimelineHashMap openTransactionsByPartition = (TimelineHashMap)openTransactionsByTopic.get((Object)topic);
            if (openTransactionsByPartition == null) {
                return null;
            }
            return (TimelineHashSet)openTransactionsByPartition.get((Object)partition);
        }

        private boolean remove(String groupId, String topic, int partition, long producerId) {
            TimelineHashSet<Long> openTransactions = this.get(groupId, topic, partition);
            if (openTransactions == null) {
                return false;
            }
            boolean removed = openTransactions.remove((Object)producerId);
            if (openTransactions.isEmpty()) {
                this.clear(groupId, topic, partition);
            }
            return removed;
        }
    }

    public static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;
        private Time time = null;
        private GroupMetadataManager groupMetadataManager = null;
        private MetadataImage metadataImage = null;
        private GroupCoordinatorConfig config = null;
        private GroupCoordinatorMetricsShard metrics = null;

        public Builder withLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        public Builder withSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        public Builder withTime(Time time) {
            this.time = time;
            return this;
        }

        public Builder withGroupMetadataManager(GroupMetadataManager groupMetadataManager) {
            this.groupMetadataManager = groupMetadataManager;
            return this;
        }

        public Builder withGroupCoordinatorConfig(GroupCoordinatorConfig config) {
            this.config = config;
            return this;
        }

        public Builder withMetadataImage(MetadataImage metadataImage) {
            this.metadataImage = metadataImage;
            return this;
        }

        public Builder withGroupCoordinatorMetricsShard(GroupCoordinatorMetricsShard metrics) {
            this.metrics = metrics;
            return this;
        }

        public OffsetMetadataManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.metadataImage == null) {
                this.metadataImage = MetadataImage.EMPTY;
            }
            if (this.time == null) {
                this.time = Time.SYSTEM;
            }
            if (this.groupMetadataManager == null) {
                throw new IllegalArgumentException("GroupMetadataManager cannot be null");
            }
            if (this.metrics == null) {
                throw new IllegalArgumentException("GroupCoordinatorMetricsShard cannot be null");
            }
            return new OffsetMetadataManager(this.snapshotRegistry, this.logContext, this.time, this.metadataImage, this.groupMetadataManager, this.config, this.metrics);
        }
    }
}

