/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.generated;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageContext;
import org.apache.kafka.common.protocol.MessageSizeAccumulator;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.ObjectSerializationCache;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.CompactArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.RawTaggedField;
import org.apache.kafka.common.protocol.types.RawTaggedFieldWriter;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Type;
import org.apache.kafka.common.utils.ByteUtils;

public class StreamsGroupMemberMetadataValue
implements ApiMessage {
    String instanceId;
    String rackId;
    String clientId;
    String clientHost;
    int rebalanceTimeoutMs;
    int topologyEpoch;
    String processId;
    Endpoint userEndpoint;
    List<KeyValue> clientTags;
    private List<RawTaggedField> _unknownTaggedFields;
    public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("instance_id", (Type)Type.COMPACT_NULLABLE_STRING, "The (optional) instance ID for static membership."), new Field("rack_id", (Type)Type.COMPACT_NULLABLE_STRING, "The (optional) rack ID."), new Field("client_id", (Type)Type.COMPACT_STRING, "The client ID."), new Field("client_host", (Type)Type.COMPACT_STRING, "The client host."), new Field("rebalance_timeout_ms", (Type)Type.INT32, "The rebalance timeout."), new Field("topology_epoch", (Type)Type.INT32, "The epoch of the topology."), new Field("process_id", (Type)Type.COMPACT_STRING, "Identity of the streams instance that may have multiple consumers."), new Field("user_endpoint", (Type)Endpoint.SCHEMA_0, "User-defined endpoint for running interactive queries on this instance."), new Field("client_tags", (Type)new CompactArrayOf((Type)KeyValue.SCHEMA_0), "Used for rack-aware assignment algorithm."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
    public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
    public static final short LOWEST_SUPPORTED_VERSION = 0;
    public static final short HIGHEST_SUPPORTED_VERSION = 0;

    public StreamsGroupMemberMetadataValue(Readable _readable, short _version) {
        this.read(_readable, _version, MessageContext.IDENTITY);
    }

    public StreamsGroupMemberMetadataValue(Readable _readable, short _version, MessageContext _context) {
        this.read(_readable, _version, _context);
    }

    public StreamsGroupMemberMetadataValue() {
        this.instanceId = "";
        this.rackId = "";
        this.clientId = "";
        this.clientHost = "";
        this.rebalanceTimeoutMs = -1;
        this.topologyEpoch = 0;
        this.processId = "";
        this.userEndpoint = null;
        this.clientTags = new ArrayList<KeyValue>(0);
    }

    public short apiKey() {
        return 19;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 0;
    }

    public final void read(Readable _readable, short _version, MessageContext _context) {
        int length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.instanceId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field instanceId had invalid length " + length);
            }
            this.instanceId = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            this.rackId = null;
        } else {
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field rackId had invalid length " + length);
            }
            this.rackId = _readable.readString(length);
        }
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clientId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clientId had invalid length " + length);
        }
        this.clientId = _readable.readString(length);
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field clientHost was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field clientHost had invalid length " + length);
        }
        this.clientHost = _readable.readString(length);
        this.rebalanceTimeoutMs = _readable.readInt();
        this.topologyEpoch = _readable.readInt();
        length = _readable.readUnsignedVarint() - 1;
        if (length < 0) {
            throw new RuntimeException("non-nullable field processId was serialized as null");
        }
        if (length > Short.MAX_VALUE) {
            throw new RuntimeException("string field processId had invalid length " + length);
        }
        this.processId = _readable.readString(length);
        this.userEndpoint = _readable.readByte() < 0 ? null : new Endpoint(_readable, _version, _context);
        int arrayLength = _readable.readUnsignedVarint() - 1;
        if (arrayLength < 0) {
            throw new RuntimeException("non-nullable field clientTags was serialized as null");
        }
        if (arrayLength > _readable.remaining()) {
            throw new RuntimeException("Tried to allocate a collection of size " + arrayLength + ", but there are only " + _readable.remaining() + " bytes remaining.");
        }
        ArrayList<KeyValue> newCollection = new ArrayList<KeyValue>(arrayLength);
        for (int i = 0; i < arrayLength; ++i) {
            newCollection.add(new KeyValue(_readable, _version, _context));
        }
        this.clientTags = newCollection;
        this._unknownTaggedFields = null;
        int _numTaggedFields = _readable.readUnsignedVarint();
        for (int _i = 0; _i < _numTaggedFields; ++_i) {
            int _tag = _readable.readUnsignedVarint();
            int _size = _readable.readUnsignedVarint();
            switch (_tag) {
                default: 
            }
            this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
        }
    }

    public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        Object _stringBytes;
        int _numTaggedFields = 0;
        if (this.instanceId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.instanceId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        if (this.rackId == null) {
            _writable.writeUnsignedVarint(0);
        } else {
            _stringBytes = _cache.getSerializedValue((Object)this.rackId);
            _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
            _writable.writeByteArray((byte[])_stringBytes);
        }
        _stringBytes = _cache.getSerializedValue((Object)this.clientId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _stringBytes = _cache.getSerializedValue((Object)this.clientHost);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        _writable.writeInt(this.rebalanceTimeoutMs);
        _writable.writeInt(this.topologyEpoch);
        _stringBytes = _cache.getSerializedValue((Object)this.processId);
        _writable.writeUnsignedVarint(((byte[])_stringBytes).length + 1);
        _writable.writeByteArray((byte[])_stringBytes);
        if (this.userEndpoint == null) {
            _writable.writeByte((byte)-1);
        } else {
            _writable.writeByte((byte)1);
            this.userEndpoint.write(_writable, _cache, _version, _context);
        }
        _writable.writeUnsignedVarint(this.clientTags.size() + 1);
        _stringBytes = this.clientTags.iterator();
        while (_stringBytes.hasNext()) {
            KeyValue clientTagsElement = (KeyValue)_stringBytes.next();
            clientTagsElement.write(_writable, _cache, _version, _context);
        }
        RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
        _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
        _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
    }

    public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
        byte[] _stringBytes;
        int _numTaggedFields = 0;
        if (this.instanceId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.instanceId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'instanceId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.instanceId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        if (this.rackId == null) {
            _size.addBytes(1);
        } else {
            _stringBytes = this.rackId.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'rackId' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.rackId, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        }
        _stringBytes = this.clientId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'clientId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clientId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _stringBytes = this.clientHost.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'clientHost' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.clientHost, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        _size.addBytes(4);
        _size.addBytes(4);
        _stringBytes = this.processId.getBytes(StandardCharsets.UTF_8);
        if (_stringBytes.length > Short.MAX_VALUE) {
            throw new RuntimeException("'processId' field is too long to be serialized");
        }
        _cache.cacheSerializedValue((Object)this.processId, _stringBytes);
        _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
        if (this.userEndpoint == null) {
            _size.addBytes(1);
        } else {
            _size.addBytes(1);
            this.userEndpoint.addSize(_size, _cache, _version, _context);
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)(this.clientTags.size() + 1)));
        for (KeyValue clientTagsElement : this.clientTags) {
            clientTagsElement.addSize(_size, _cache, _version, _context);
        }
        if (this._unknownTaggedFields != null) {
            _numTaggedFields += this._unknownTaggedFields.size();
            for (RawTaggedField _field : this._unknownTaggedFields) {
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                _size.addBytes(_field.size());
            }
        }
        _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StreamsGroupMemberMetadataValue)) {
            return false;
        }
        StreamsGroupMemberMetadataValue other = (StreamsGroupMemberMetadataValue)obj;
        if (this.instanceId == null ? other.instanceId != null : !this.instanceId.equals(other.instanceId)) {
            return false;
        }
        if (this.rackId == null ? other.rackId != null : !this.rackId.equals(other.rackId)) {
            return false;
        }
        if (this.clientId == null ? other.clientId != null : !this.clientId.equals(other.clientId)) {
            return false;
        }
        if (this.clientHost == null ? other.clientHost != null : !this.clientHost.equals(other.clientHost)) {
            return false;
        }
        if (this.rebalanceTimeoutMs != other.rebalanceTimeoutMs) {
            return false;
        }
        if (this.topologyEpoch != other.topologyEpoch) {
            return false;
        }
        if (this.processId == null ? other.processId != null : !this.processId.equals(other.processId)) {
            return false;
        }
        if (this.userEndpoint == null ? other.userEndpoint != null : !this.userEndpoint.equals(other.userEndpoint)) {
            return false;
        }
        if (this.clientTags == null ? other.clientTags != null : !this.clientTags.equals(other.clientTags)) {
            return false;
        }
        return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.instanceId == null ? 0 : this.instanceId.hashCode());
        hashCode = 31 * hashCode + (this.rackId == null ? 0 : this.rackId.hashCode());
        hashCode = 31 * hashCode + (this.clientId == null ? 0 : this.clientId.hashCode());
        hashCode = 31 * hashCode + (this.clientHost == null ? 0 : this.clientHost.hashCode());
        hashCode = 31 * hashCode + this.rebalanceTimeoutMs;
        hashCode = 31 * hashCode + this.topologyEpoch;
        hashCode = 31 * hashCode + (this.processId == null ? 0 : this.processId.hashCode());
        hashCode = 31 * hashCode + (this.userEndpoint == null ? 0 : this.userEndpoint.hashCode());
        hashCode = 31 * hashCode + (this.clientTags == null ? 0 : this.clientTags.hashCode());
        return hashCode;
    }

    public StreamsGroupMemberMetadataValue duplicate() {
        StreamsGroupMemberMetadataValue _duplicate = new StreamsGroupMemberMetadataValue();
        _duplicate.instanceId = this.instanceId == null ? null : this.instanceId;
        _duplicate.rackId = this.rackId == null ? null : this.rackId;
        _duplicate.clientId = this.clientId;
        _duplicate.clientHost = this.clientHost;
        _duplicate.rebalanceTimeoutMs = this.rebalanceTimeoutMs;
        _duplicate.topologyEpoch = this.topologyEpoch;
        _duplicate.processId = this.processId;
        _duplicate.userEndpoint = this.userEndpoint == null ? null : this.userEndpoint.duplicate();
        ArrayList<KeyValue> newClientTags = new ArrayList<KeyValue>(this.clientTags.size());
        for (KeyValue _element : this.clientTags) {
            newClientTags.add(_element.duplicate());
        }
        _duplicate.clientTags = newClientTags;
        return _duplicate;
    }

    public String toString() {
        return "StreamsGroupMemberMetadataValue(instanceId=" + (String)(this.instanceId == null ? "null" : "'" + this.instanceId.toString() + "'") + ", rackId=" + (String)(this.rackId == null ? "null" : "'" + this.rackId.toString() + "'") + ", clientId=" + (String)(this.clientId == null ? "null" : "'" + this.clientId.toString() + "'") + ", clientHost=" + (String)(this.clientHost == null ? "null" : "'" + this.clientHost.toString() + "'") + ", rebalanceTimeoutMs=" + this.rebalanceTimeoutMs + ", topologyEpoch=" + this.topologyEpoch + ", processId=" + (String)(this.processId == null ? "null" : "'" + this.processId.toString() + "'") + ", userEndpoint=" + (this.userEndpoint == null ? "null" : this.userEndpoint.toString()) + ", clientTags=" + MessageUtil.deepToString(this.clientTags.iterator()) + ")";
    }

    public String instanceId() {
        return this.instanceId;
    }

    public String rackId() {
        return this.rackId;
    }

    public String clientId() {
        return this.clientId;
    }

    public String clientHost() {
        return this.clientHost;
    }

    public int rebalanceTimeoutMs() {
        return this.rebalanceTimeoutMs;
    }

    public int topologyEpoch() {
        return this.topologyEpoch;
    }

    public String processId() {
        return this.processId;
    }

    public Endpoint userEndpoint() {
        return this.userEndpoint;
    }

    public List<KeyValue> clientTags() {
        return this.clientTags;
    }

    public List<RawTaggedField> unknownTaggedFields() {
        if (this._unknownTaggedFields == null) {
            this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
        }
        return this._unknownTaggedFields;
    }

    public StreamsGroupMemberMetadataValue setInstanceId(String v) {
        this.instanceId = v;
        return this;
    }

    public StreamsGroupMemberMetadataValue setRackId(String v) {
        this.rackId = v;
        return this;
    }

    public StreamsGroupMemberMetadataValue setClientId(String v) {
        this.clientId = v;
        return this;
    }

    public StreamsGroupMemberMetadataValue setClientHost(String v) {
        this.clientHost = v;
        return this;
    }

    public StreamsGroupMemberMetadataValue setRebalanceTimeoutMs(int v) {
        this.rebalanceTimeoutMs = v;
        return this;
    }

    public StreamsGroupMemberMetadataValue setTopologyEpoch(int v) {
        this.topologyEpoch = v;
        return this;
    }

    public StreamsGroupMemberMetadataValue setProcessId(String v) {
        this.processId = v;
        return this;
    }

    public StreamsGroupMemberMetadataValue setUserEndpoint(Endpoint v) {
        this.userEndpoint = v;
        return this;
    }

    public StreamsGroupMemberMetadataValue setClientTags(List<KeyValue> v) {
        this.clientTags = v;
        return this;
    }

    public static class Endpoint
    implements Message {
        String host;
        int port;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("host", (Type)Type.COMPACT_STRING, "The host of the endpoint."), new Field("port", (Type)Type.UINT16, "The port of the endpoint."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public Endpoint(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public Endpoint() {
            this.host = "";
            this.port = 0;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field host was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field host had invalid length " + length);
            }
            this.host = _readable.readString(length);
            this.port = _readable.readUnsignedShort();
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.host);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _writable.writeUnsignedShort(this.port);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.host.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'host' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.host, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _size.addBytes(2);
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Endpoint)) {
                return false;
            }
            Endpoint other = (Endpoint)obj;
            if (this.host == null ? other.host != null : !this.host.equals(other.host)) {
                return false;
            }
            if (this.port != other.port) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.host == null ? 0 : this.host.hashCode());
            hashCode = 31 * hashCode + this.port;
            return hashCode;
        }

        public Endpoint duplicate() {
            Endpoint _duplicate = new Endpoint();
            _duplicate.host = this.host;
            _duplicate.port = this.port;
            return _duplicate;
        }

        public String toString() {
            return "Endpoint(host=" + (String)(this.host == null ? "null" : "'" + this.host.toString() + "'") + ", port=" + this.port + ")";
        }

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public Endpoint setHost(String v) {
            this.host = v;
            return this;
        }

        public Endpoint setPort(int v) {
            if (v < 0 || v > 65535) {
                throw new RuntimeException("Invalid value " + v + " for unsigned short field.");
            }
            this.port = v;
            return this;
        }
    }

    public static class KeyValue
    implements Message {
        String key;
        String value;
        private List<RawTaggedField> _unknownTaggedFields;
        public static final Schema SCHEMA_0 = new Schema(new Field[]{new Field("key", (Type)Type.COMPACT_STRING, "The key of the config."), new Field("value", (Type)Type.COMPACT_STRING, "the value of the config."), Field.TaggedFieldsSection.of((Object[])new Object[0])});
        public static final Schema[] SCHEMAS = new Schema[]{SCHEMA_0};
        public static final short LOWEST_SUPPORTED_VERSION = 0;
        public static final short HIGHEST_SUPPORTED_VERSION = 0;

        public KeyValue(Readable _readable, short _version, MessageContext _context) {
            this.read(_readable, _version, _context);
        }

        public KeyValue() {
            this.key = "";
            this.value = "";
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return Short.MAX_VALUE;
        }

        public final void read(Readable _readable, short _version, MessageContext _context) {
            int length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field key was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field key had invalid length " + length);
            }
            this.key = _readable.readString(length);
            length = _readable.readUnsignedVarint() - 1;
            if (length < 0) {
                throw new RuntimeException("non-nullable field value was serialized as null");
            }
            if (length > Short.MAX_VALUE) {
                throw new RuntimeException("string field value had invalid length " + length);
            }
            this.value = _readable.readString(length);
            this._unknownTaggedFields = null;
            int _numTaggedFields = _readable.readUnsignedVarint();
            for (int _i = 0; _i < _numTaggedFields; ++_i) {
                int _tag = _readable.readUnsignedVarint();
                int _size = _readable.readUnsignedVarint();
                switch (_tag) {
                    default: 
                }
                this._unknownTaggedFields = _readable.readUnknownTaggedField(this._unknownTaggedFields, _tag, _size);
            }
        }

        public void write(Writable _writable, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = _cache.getSerializedValue((Object)this.key);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            _stringBytes = _cache.getSerializedValue((Object)this.value);
            _writable.writeUnsignedVarint(_stringBytes.length + 1);
            _writable.writeByteArray(_stringBytes);
            RawTaggedFieldWriter _rawWriter = RawTaggedFieldWriter.forFields(this._unknownTaggedFields);
            _writable.writeUnsignedVarint(_numTaggedFields += _rawWriter.numFields());
            _rawWriter.writeRawTags(_writable, Integer.MAX_VALUE);
        }

        public void addSize(MessageSizeAccumulator _size, ObjectSerializationCache _cache, short _version, MessageContext _context) {
            int _numTaggedFields = 0;
            byte[] _stringBytes = this.key.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'key' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.key, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            _stringBytes = this.value.getBytes(StandardCharsets.UTF_8);
            if (_stringBytes.length > Short.MAX_VALUE) {
                throw new RuntimeException("'value' field is too long to be serialized");
            }
            _cache.cacheSerializedValue((Object)this.value, _stringBytes);
            _size.addBytes(_stringBytes.length + ByteUtils.sizeOfUnsignedVarint((int)(_stringBytes.length + 1)));
            if (this._unknownTaggedFields != null) {
                _numTaggedFields += this._unknownTaggedFields.size();
                for (RawTaggedField _field : this._unknownTaggedFields) {
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.tag()));
                    _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_field.size()));
                    _size.addBytes(_field.size());
                }
            }
            _size.addBytes(ByteUtils.sizeOfUnsignedVarint((int)_numTaggedFields));
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof KeyValue)) {
                return false;
            }
            KeyValue other = (KeyValue)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return MessageUtil.compareRawTaggedFields(this._unknownTaggedFields, other._unknownTaggedFields);
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.key == null ? 0 : this.key.hashCode());
            hashCode = 31 * hashCode + (this.value == null ? 0 : this.value.hashCode());
            return hashCode;
        }

        public KeyValue duplicate() {
            KeyValue _duplicate = new KeyValue();
            _duplicate.key = this.key;
            _duplicate.value = this.value;
            return _duplicate;
        }

        public String toString() {
            return "KeyValue(key=" + (String)(this.key == null ? "null" : "'" + this.key.toString() + "'") + ", value=" + (String)(this.value == null ? "null" : "'" + this.value.toString() + "'") + ")";
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public List<RawTaggedField> unknownTaggedFields() {
            if (this._unknownTaggedFields == null) {
                this._unknownTaggedFields = new ArrayList<RawTaggedField>(0);
            }
            return this._unknownTaggedFields;
        }

        public KeyValue setKey(String v) {
            this.key = v;
            return this;
        }

        public KeyValue setValue(String v) {
            this.value = v;
            return this;
        }
    }
}

