/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.metrics;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.coordinator.common.runtime.CoordinatorMetricsShard;
import org.apache.kafka.coordinator.group.classic.ClassicGroupState;
import org.apache.kafka.coordinator.group.modern.consumer.ConsumerGroup;
import org.apache.kafka.coordinator.group.modern.share.ShareGroup;
import org.apache.kafka.coordinator.group.streams.StreamsGroup;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupCoordinatorMetricsShard
implements CoordinatorMetricsShard {
    private static final Logger log = LoggerFactory.getLogger(GroupCoordinatorMetricsShard.class);
    private volatile Map<ClassicGroupState, Long> classicGroupGauges;
    private volatile Map<ConsumerGroup.ConsumerGroupState, Long> consumerGroupGauges;
    private volatile Map<ConsumerGroup.ConsumerGroupState, Long> mixedGroupGauges;
    private volatile Long numClassicGroupMembers;
    private volatile Long numConsumerGroupMembers;
    private volatile Map<ShareGroup.ShareGroupState, Long> shareGroupGauges;
    private volatile Map<StreamsGroup.StreamsGroupState, Long> streamsGroupGauges;
    private final Map<String, Sensor> globalSensors;
    private final TimelineGaugeCounter numOffsetsTimelineGaugeCounter;
    private final TimelineGaugeCounter numClassicGroupsTimelineCounter;
    private final TopicPartition topicPartition;
    private volatile Long classicGroupMinRebalanceStartTimestamps;
    private volatile Long consumerGroupMinRebalanceStartTimestamps;
    private volatile Long mixedGroupMinRebalanceStartTimestamps;

    public GroupCoordinatorMetricsShard(SnapshotRegistry snapshotRegistry, Map<String, Sensor> globalSensors, TopicPartition topicPartition) {
        Objects.requireNonNull(snapshotRegistry);
        this.numOffsetsTimelineGaugeCounter = new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L));
        this.numClassicGroupsTimelineCounter = new TimelineGaugeCounter(new TimelineLong(snapshotRegistry), new AtomicLong(0L));
        this.classicGroupMinRebalanceStartTimestamps = Long.MAX_VALUE;
        this.consumerGroupMinRebalanceStartTimestamps = Long.MAX_VALUE;
        this.mixedGroupMinRebalanceStartTimestamps = Long.MAX_VALUE;
        this.classicGroupGauges = Map.of();
        this.consumerGroupGauges = Map.of();
        this.mixedGroupGauges = Map.of();
        this.streamsGroupGauges = Map.of();
        this.numClassicGroupMembers = 0L;
        this.numConsumerGroupMembers = 0L;
        this.shareGroupGauges = Map.of();
        this.globalSensors = Objects.requireNonNull(globalSensors);
        this.topicPartition = Objects.requireNonNull(topicPartition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrementNumOffsets() {
        TimelineLong timelineLong = this.numOffsetsTimelineGaugeCounter.timelineLong;
        synchronized (timelineLong) {
            this.numOffsetsTimelineGaugeCounter.timelineLong.increment();
        }
    }

    public void setConsumerGroupGauges(Map<ConsumerGroup.ConsumerGroupState, Long> consumerGroupGauges) {
        this.consumerGroupGauges = consumerGroupGauges;
    }

    public void setMixedGroupGauges(Map<ConsumerGroup.ConsumerGroupState, Long> mixedGroupGauges) {
        this.mixedGroupGauges = mixedGroupGauges;
    }

    public void setShareGroupGauges(Map<ShareGroup.ShareGroupState, Long> shareGroupGauges) {
        this.shareGroupGauges = shareGroupGauges;
    }

    public void setStreamsGroupGauges(Map<StreamsGroup.StreamsGroupState, Long> streamsGroupGauges) {
        this.streamsGroupGauges = streamsGroupGauges;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decrementNumOffsets() {
        TimelineLong timelineLong = this.numOffsetsTimelineGaugeCounter.timelineLong;
        synchronized (timelineLong) {
            this.numOffsetsTimelineGaugeCounter.timelineLong.decrement();
        }
    }

    public long numOffsets() {
        return this.numOffsetsTimelineGaugeCounter.atomicLong.get();
    }

    public long numClassicGroups(ClassicGroupState state) {
        Long counter = this.classicGroupGauges.get((Object)state);
        if (counter != null) {
            return counter;
        }
        return 0L;
    }

    public long numClassicGroups() {
        return this.classicGroupGauges.values().stream().mapToLong(Long::longValue).sum();
    }

    public long numConsumerGroups(ConsumerGroup.ConsumerGroupState state) {
        Long counter = this.consumerGroupGauges.get((Object)state);
        if (counter != null) {
            return counter;
        }
        return 0L;
    }

    public long numConsumerGroups() {
        return this.consumerGroupGauges.values().stream().mapToLong(Long::longValue).sum();
    }

    public long numStreamsGroups(StreamsGroup.StreamsGroupState state) {
        Long counter = this.streamsGroupGauges.get((Object)state);
        if (counter != null) {
            return counter;
        }
        return 0L;
    }

    public long numMixedGroups(ConsumerGroup.ConsumerGroupState state) {
        Long counter = this.mixedGroupGauges.get((Object)state);
        if (counter != null) {
            return counter;
        }
        return 0L;
    }

    public long numMixedGroups() {
        return this.mixedGroupGauges.values().stream().mapToLong(Long::longValue).sum();
    }

    public long numClassicGroupMembers() {
        return this.numClassicGroupMembers;
    }

    public long numConsumerGroupMembers() {
        return this.numConsumerGroupMembers;
    }

    public long classicGroupMinRebalanceStartTimestampMs() {
        return this.classicGroupMinRebalanceStartTimestamps;
    }

    public long consumerGroupMinRebalanceStartTimestampMs() {
        return this.consumerGroupMinRebalanceStartTimestamps;
    }

    public long mixedGroupMinRebalanceStartTimestampMs() {
        return this.mixedGroupMinRebalanceStartTimestamps;
    }

    public long minRebalanceStartTimestampMs() {
        return Math.min(this.classicGroupMinRebalanceStartTimestamps, Math.min(this.consumerGroupMinRebalanceStartTimestamps, this.mixedGroupMinRebalanceStartTimestamps));
    }

    public long numShareGroups(ShareGroup.ShareGroupState state) {
        Long counter = this.shareGroupGauges.get((Object)state);
        if (counter != null) {
            return counter;
        }
        return 0L;
    }

    public long numShareGroups() {
        return this.shareGroupGauges.values().stream().mapToLong(Long::longValue).sum();
    }

    public long numStreamsGroups() {
        return this.streamsGroupGauges.values().stream().mapToLong(Long::longValue).sum();
    }

    public void record(String sensorName) {
        Sensor sensor = this.globalSensors.get(sensorName);
        if (sensor != null) {
            sensor.record();
        }
    }

    public void record(String sensorName, double val) {
        Sensor sensor = this.globalSensors.get(sensorName);
        if (sensor != null) {
            sensor.record(val);
        }
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitUpTo(long offset) {
        long value;
        TimelineLong timelineLong = this.numClassicGroupsTimelineCounter.timelineLong;
        synchronized (timelineLong) {
            value = this.numClassicGroupsTimelineCounter.timelineLong.get(offset);
            this.numClassicGroupsTimelineCounter.atomicLong.set(value);
        }
        timelineLong = this.numOffsetsTimelineGaugeCounter.timelineLong;
        synchronized (timelineLong) {
            value = this.numOffsetsTimelineGaugeCounter.timelineLong.get(offset);
            this.numOffsetsTimelineGaugeCounter.atomicLong.set(value);
        }
    }

    public void setClassicGroupGauges(Map<ClassicGroupState, Long> classicGroupGauges) {
        this.classicGroupGauges = classicGroupGauges;
    }

    public void setNumClassicGroupMembers(Long numClassicGroupMembers) {
        this.numClassicGroupMembers = numClassicGroupMembers;
    }

    public void setNumConsumerGroupMembers(Long numConsumerGroupMembers) {
        this.numConsumerGroupMembers = numConsumerGroupMembers;
    }

    public void setClassicGroupMinRebalanceStartTimestamps(Long classicGroupMinRebalanceStartTimestamps) {
        this.classicGroupMinRebalanceStartTimestamps = classicGroupMinRebalanceStartTimestamps;
    }

    public void setConsumerGroupMinRebalanceStartTimestamps(Long consumerGroupMinRebalanceStartTimestamps) {
        this.consumerGroupMinRebalanceStartTimestamps = consumerGroupMinRebalanceStartTimestamps;
    }

    public void setMixedGroupMinRebalanceStartTimestamps(Long mixedGroupMinRebalanceStartTimestamps) {
        this.mixedGroupMinRebalanceStartTimestamps = mixedGroupMinRebalanceStartTimestamps;
    }

    private static class TimelineGaugeCounter {
        final TimelineLong timelineLong;
        final AtomicLong atomicLong;

        public TimelineGaugeCounter(TimelineLong timelineLong, AtomicLong atomicLong) {
            this.timelineLong = timelineLong;
            this.atomicLong = atomicLong;
        }
    }
}

