/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.client.rest.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.google.crypto.tink.Aead;
import io.confluent.kafka.schemaregistry.encryption.tink.AeadWrapper;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="Kek")
public class Kek {
    private final String name;
    private final String kmsType;
    private final String kmsKeyId;
    @JsonPropertyOrder(alphabetic=true)
    private final SortedMap<String, String> kmsProps;
    private final String doc;
    private final boolean shared;
    private final Long timestamp;
    private final Boolean deleted;

    @JsonCreator
    public Kek(@JsonProperty(value="name") String name, @JsonProperty(value="kmsType") String kmsType, @JsonProperty(value="kmsKeyId") String kmsKeyId, @JsonProperty(value="kmsProps") Map<String, String> kmsProps, @JsonProperty(value="doc") String doc, @JsonProperty(value="shared") boolean shared, @JsonProperty(value="ts") Long timestamp, @JsonProperty(value="deleted") Boolean deleted) {
        this.name = name;
        this.kmsType = kmsType;
        this.kmsKeyId = kmsKeyId;
        TreeMap<String, String> sortedKmsProps = kmsProps != null ? new TreeMap<String, String>(kmsProps) : Collections.emptySortedMap();
        this.kmsProps = Collections.unmodifiableSortedMap(sortedKmsProps);
        this.doc = doc;
        this.shared = shared;
        this.timestamp = timestamp;
        this.deleted = deleted;
    }

    @Schema(description="Name of the kek")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @Schema(description="KMS type of the kek")
    @JsonProperty(value="kmsType")
    public String getKmsType() {
        return this.kmsType;
    }

    @Schema(description="KMS key ID of the kek")
    @JsonProperty(value="kmsKeyId")
    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    @Schema(description="Properties of the kek")
    @JsonProperty(value="kmsProps")
    public SortedMap<String, String> getKmsProps() {
        return this.kmsProps;
    }

    @Schema(description="Description of the kek")
    @JsonProperty(value="doc")
    public String getDoc() {
        return this.doc;
    }

    @Schema(description="Whether the kek is shared")
    @JsonProperty(value="shared")
    public boolean isShared() {
        return this.shared;
    }

    @Schema(description="Timestamp of the kek")
    @JsonProperty(value="ts")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Schema(description="Whether the kek is deleted")
    @JsonProperty(value="deleted")
    public Boolean getDeleted() {
        return this.deleted;
    }

    @JsonIgnore
    public boolean isDeleted() {
        return Boolean.TRUE.equals(this.deleted);
    }

    @JsonIgnore
    public Aead toAead(Map<String, ?> configs) throws GeneralSecurityException {
        HashMap<String, String> props = new HashMap<String, String>(this.getKmsProps());
        if (configs.containsKey("test.client")) {
            props.put("test.client", (String)configs.get("test.client"));
        }
        return new AeadWrapper(props, this.getKmsType(), this.getKmsKeyId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Kek kek = (Kek)o;
        return this.shared == kek.shared && Objects.equals(this.name, kek.name) && Objects.equals(this.kmsType, kek.kmsType) && Objects.equals(this.kmsKeyId, kek.kmsKeyId) && Objects.equals(this.kmsProps, kek.kmsProps) && Objects.equals(this.doc, kek.doc);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.kmsType, this.kmsKeyId, this.kmsProps, this.doc, this.shared);
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toJson() throws IOException {
        return JacksonMapper.INSTANCE.writeValueAsString((Object)this);
    }
}

