/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest;

import com.google.common.annotations.VisibleForTesting;
import io.confluent.rest.FileWatcher;
import io.confluent.rest.SslConfig;
import io.confluent.rest.SslFactoryPemHelper;
import io.spiffe.provider.SpiffeSslContextFactory;
import io.spiffe.workloadapi.X509Source;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import org.apache.kafka.common.config.types.Password;
import org.conscrypt.OpenSSLProvider;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SslFactory {
    private static final Logger log = LoggerFactory.getLogger(SslFactory.class);
    private static AtomicReference<Exception> watcherExecException = new AtomicReference<Object>(null);

    @VisibleForTesting
    public static Optional<Exception> lastLoadFailure() {
        return Optional.ofNullable(watcherExecException.get());
    }

    private SslFactory() {
    }

    private static void setSecurityStoreProps(SslConfig sslConfig, SslContextFactory.Server sslContextFactory, boolean isKeyStore, boolean setPathOnly) {
        boolean isPem = SslFactoryPemHelper.isPemSecurityStore(isKeyStore ? sslConfig.getKeyStoreType() : sslConfig.getTrustStoreType());
        if (isPem) {
            log.info("PEM security store detected! Converting to {} - isKeyStore {}", (Object)SslFactoryPemHelper.getKeyStoreType(sslConfig.getProvider()), (Object)isKeyStore);
            if (isKeyStore) {
                sslContextFactory.setKeyStore(SslFactoryPemHelper.getKeyStoreFromPem(sslConfig.getKeyStorePath(), sslConfig.getKeyStoreType(), new Password(sslConfig.getKeyManagerPassword()), sslConfig.getProvider(), isKeyStore));
            } else {
                sslContextFactory.setTrustStore(SslFactoryPemHelper.getKeyStoreFromPem(sslConfig.getTrustStorePath(), sslConfig.getTrustStoreType(), new Password(sslConfig.getKeyManagerPassword()), sslConfig.getProvider(), isKeyStore));
            }
        } else if (isKeyStore) {
            sslContextFactory.setKeyStorePath(sslConfig.getKeyStorePath());
            if (!setPathOnly) {
                sslContextFactory.setKeyStorePassword(sslConfig.getKeyStorePassword());
                sslContextFactory.setKeyStoreType(sslConfig.getKeyStoreType());
            }
        } else {
            sslContextFactory.setTrustStorePath(sslConfig.getTrustStorePath());
            if (!setPathOnly) {
                sslContextFactory.setTrustStorePassword(sslConfig.getTrustStorePassword());
                sslContextFactory.setTrustStoreType(sslConfig.getTrustStoreType());
            }
        }
    }

    private static FileWatcher.Callback onFileChangeCallback(SslConfig sslConfig, SslContextFactory.Server sslContextFactory) {
        return () -> {
            try {
                SslFactory.setSecurityStoreProps(sslConfig, sslContextFactory, true, true);
                sslContextFactory.reload(scf -> log.info("SSL cert auto reload begun: " + scf.getKeyStorePath()));
                log.info("SSL cert auto reload complete");
                watcherExecException.set(null);
            }
            catch (Exception e) {
                watcherExecException.set(e);
                throw e;
            }
        };
    }

    public static SslContextFactory createSslContextFactory(SslConfig sslConfig) {
        return SslFactory.createSslContextFactory(sslConfig, null);
    }

    public static SslContextFactory createSslContextFactory(SslConfig sslConfig, X509Source x509Source) {
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        if (sslConfig.getIsSpireEnabled().booleanValue()) {
            SslFactory.configureSpiffeSslContext(sslContextFactory, x509Source);
        }
        if (!sslConfig.getKeyStorePath().isEmpty()) {
            SslFactory.configureKeyStore(sslContextFactory, sslConfig);
        }
        SslFactory.configureClientAuth(sslContextFactory, sslConfig);
        if (!sslConfig.getIncludeProtocols().isEmpty()) {
            sslContextFactory.setIncludeProtocols(sslConfig.getIncludeProtocols().toArray(new String[0]));
        }
        if (!sslConfig.getIncludeCipherSuites().isEmpty()) {
            sslContextFactory.setIncludeCipherSuites(sslConfig.getIncludeCipherSuites().toArray(new String[0]));
        }
        sslContextFactory.setEndpointIdentificationAlgorithm(sslConfig.getEndpointIdentificationAlgorithm());
        if (!sslConfig.getTrustStorePath().isEmpty()) {
            SslFactory.setSecurityStoreProps(sslConfig, sslContextFactory, false, false);
            if (!sslConfig.getTrustManagerFactoryAlgorithm().isEmpty()) {
                sslContextFactory.setTrustManagerFactoryAlgorithm(sslConfig.getTrustManagerFactoryAlgorithm());
            }
        }
        sslContextFactory.setProtocol(sslConfig.getProtocol());
        if (!sslConfig.getProvider().isEmpty()) {
            SslFactory.configureSecurityProvider(sslContextFactory, sslConfig);
        }
        sslContextFactory.setRenegotiationAllowed(false);
        return sslContextFactory;
    }

    private static void configureSpiffeSslContext(SslContextFactory.Server sslContextFactory, X509Source x509Source) {
        SpiffeSslContextFactory.SslContextOptions options = SpiffeSslContextFactory.SslContextOptions.builder().x509Source(x509Source).acceptAnySpiffeId().build();
        try {
            SSLContext sslContext = SpiffeSslContextFactory.getSslContext((SpiffeSslContextFactory.SslContextOptions)options);
            sslContextFactory.setSslContext(sslContext);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void configureClientAuth(SslContextFactory.Server sslContextFactory, SslConfig config) {
        switch (config.getClientAuth()) {
            case NEED: {
                sslContextFactory.setNeedClientAuth(true);
                break;
            }
            case WANT: {
                sslContextFactory.setWantClientAuth(true);
                break;
            }
        }
    }

    private static void configureSecurityProvider(SslContextFactory.Server sslContextFactory, SslConfig sslConfig) {
        sslContextFactory.setProvider(sslConfig.getProvider());
        if ("Conscrypt".equalsIgnoreCase(sslConfig.getProvider())) {
            Security.addProvider((Provider)new OpenSSLProvider());
        }
    }

    private static void configureKeyStore(SslContextFactory.Server sslContextFactory, SslConfig sslConfig) {
        SslFactory.setSecurityStoreProps(sslConfig, sslContextFactory, true, false);
        sslContextFactory.setKeyManagerPassword(sslConfig.getKeyManagerPassword());
        if (!sslConfig.getKeyManagerFactoryAlgorithm().isEmpty()) {
            sslContextFactory.setKeyManagerFactoryAlgorithm(sslConfig.getKeyManagerFactoryAlgorithm());
        }
        if (sslConfig.getReloadOnKeyStoreChange()) {
            SslFactory.configureKeyStoreReload(sslContextFactory, sslConfig);
        }
    }

    private static void configureKeyStoreReload(SslContextFactory.Server sslContextFactory, SslConfig sslConfig) {
        Path watchLocation = Paths.get(sslConfig.getReloadOnKeyStoreChangePath(), new String[0]);
        try {
            FileWatcher.onFileChange(watchLocation, SslFactory.onFileChangeCallback(sslConfig, sslContextFactory));
            log.info("Enabled SSL cert auto reload for: " + String.valueOf(watchLocation));
        }
        catch (IOException e) {
            log.error("Cannot enable SSL cert auto reload", (Throwable)e);
        }
    }
}

