/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.exceptions;

import io.confluent.rest.RestConfig;
import io.confluent.rest.exceptions.DebuggableExceptionMapper;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericExceptionMapper
extends DebuggableExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(GenericExceptionMapper.class);

    public GenericExceptionMapper(RestConfig restConfig) {
        super(restConfig);
    }

    public Response toResponse(Throwable exc) {
        log.error("Unhandled exception resulting in internal server error response", exc);
        try {
            if (this.restConfig.getReturn429InsteadOf500ForJettyResponseErrors() && exc instanceof IllegalStateException && exc.getMessage() != null && exc.getMessage().contains("Response does not exist (likely recycled)")) {
                return this.createResponse(exc, Response.Status.TOO_MANY_REQUESTS.getStatusCode(), (Response.StatusType)Response.Status.TOO_MANY_REQUESTS, Response.Status.TOO_MANY_REQUESTS.getReasonPhrase()).build();
            }
        }
        catch (Exception e) {
            log.error("Failed to create response for exception", (Throwable)e);
        }
        return this.createResponse(exc, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (Response.StatusType)Response.Status.INTERNAL_SERVER_ERROR, Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase()).build();
    }
}

