/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.exceptions;

import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import io.confluent.rest.RestConfig;
import io.confluent.rest.entities.ErrorMessage;
import io.confluent.rest.exceptions.GenericExceptionMapper;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.BrokerNotAvailableException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidReplicationFactorException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.SecurityDisabledException;
import org.apache.kafka.common.errors.ThrottlingQuotaExceededException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicDeletionDisabledException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.errors.UnknownServerException;
import org.apache.kafka.common.errors.UnknownTopicIdException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaExceptionMapper
extends GenericExceptionMapper {
    private static final Logger log = LoggerFactory.getLogger(KafkaExceptionMapper.class);
    public static final int KAFKA_BAD_REQUEST_ERROR_CODE = 40002;
    public static final int KAFKA_AUTHENTICATION_ERROR_CODE = 40101;
    public static final int KAFKA_AUTHORIZATION_ERROR_CODE = 40301;
    public static final int TOPIC_NOT_FOUND_ERROR_CODE = 40401;
    public static final int PARTITION_NOT_FOUND_ERROR_CODE = 40402;
    public static final int KAFKA_UNKNOWN_TOPIC_PARTITION_CODE = 40403;
    public static final int KAFKA_ERROR_ERROR_CODE = 50002;
    public static final int KAFKA_RETRIABLE_ERROR_ERROR_CODE = 50003;
    public static final int BROKER_NOT_AVAILABLE_ERROR_CODE = 50302;
    public static final int TOO_MANY_REQUESTS_ERROR_CODE = 42901;
    private static final String TOPIC_NOT_PRESENT_MESSAGE_PATTERN = "not present in metadata";
    private static final Map<Class<? extends ApiException>, ResponsePair> HANDLED = KafkaExceptionMapper.errorMap();

    public KafkaExceptionMapper(RestConfig restConfig) {
        super(restConfig);
    }

    private static Map<Class<? extends ApiException>, ResponsePair> errorMap() {
        HashMap<Class<? extends ApiException>, ResponsePair> errorMap = new HashMap<Class<? extends ApiException>, ResponsePair>();
        errorMap.put(BrokerNotAvailableException.class, new ResponsePair(Response.Status.SERVICE_UNAVAILABLE, 50302));
        errorMap.put(InvalidReplicationFactorException.class, new ResponsePair(Response.Status.BAD_REQUEST, 40002));
        errorMap.put(RecordTooLargeException.class, new ResponsePair(Response.Status.REQUEST_ENTITY_TOO_LARGE, Response.Status.REQUEST_ENTITY_TOO_LARGE.getStatusCode()));
        errorMap.put(SecurityDisabledException.class, new ResponsePair(Response.Status.BAD_REQUEST, 40002));
        errorMap.put(UnsupportedVersionException.class, new ResponsePair(Response.Status.BAD_REQUEST, 40002));
        errorMap.put(InvalidPartitionsException.class, new ResponsePair(Response.Status.BAD_REQUEST, 40002));
        errorMap.put(InvalidRequestException.class, new ResponsePair(Response.Status.BAD_REQUEST, 40002));
        errorMap.put(UnknownServerException.class, new ResponsePair(Response.Status.BAD_REQUEST, 40002));
        errorMap.put(UnknownTopicOrPartitionException.class, new ResponsePair(Response.Status.NOT_FOUND, 40403));
        errorMap.put(UnknownTopicIdException.class, new ResponsePair(Response.Status.NOT_FOUND, 40403));
        errorMap.put(PolicyViolationException.class, new ResponsePair(Response.Status.BAD_REQUEST, 40002));
        errorMap.put(TopicExistsException.class, new ResponsePair(Response.Status.BAD_REQUEST, 40002));
        errorMap.put(InvalidConfigurationException.class, new ResponsePair(Response.Status.BAD_REQUEST, 40002));
        errorMap.put(TopicDeletionDisabledException.class, new ResponsePair(Response.Status.BAD_REQUEST, 40002));
        errorMap.put(ThrottlingQuotaExceededException.class, new ResponsePair(Response.Status.TOO_MANY_REQUESTS, 42901));
        return errorMap;
    }

    @Override
    public Response toResponse(Throwable exception) {
        if (exception instanceof ExecutionException) {
            return this.handleException(exception.getCause());
        }
        if (exception instanceof CompletionException) {
            return this.handleException(exception.getCause());
        }
        return this.handleException(exception);
    }

    private Response handleException(Throwable exception) {
        if (exception instanceof AuthenticationException) {
            return this.getResponse(exception, Response.Status.UNAUTHORIZED, 40101);
        }
        if (exception instanceof AuthorizationException) {
            return this.getResponse(exception, Response.Status.FORBIDDEN, 40301);
        }
        if (HANDLED.containsKey(exception.getClass())) {
            return this.getResponse(exception);
        }
        if (exception instanceof RetriableException) {
            log.debug("Kafka retriable exception", exception);
            if (exception instanceof TimeoutException && exception.getMessage().toLowerCase().contains(TOPIC_NOT_PRESENT_MESSAGE_PATTERN)) {
                log.debug("Topic not present in metadata exception");
                return this.getResponse(exception, Response.Status.NOT_FOUND, 40401);
            }
            log.error("Internal Server Error returned to REST client after TimeoutException", exception);
            return this.getResponse(exception, Response.Status.INTERNAL_SERVER_ERROR, 50003);
        }
        if (exception instanceof InvalidTopicException) {
            return this.getResponse(exception, Response.Status.BAD_REQUEST, 40002);
        }
        if (exception instanceof KafkaException) {
            log.error("Kafka exception", exception);
            return this.getResponse(exception, Response.Status.INTERNAL_SERVER_ERROR, 50002);
        }
        if (exception instanceof InvalidFormatException) {
            return this.getResponse(exception, Response.Status.BAD_REQUEST, 40002);
        }
        log.error("Unhandled exception", exception);
        return super.toResponse(exception);
    }

    private Response getResponse(Throwable exception, Response.Status status, int errorCode) {
        ErrorMessage errorMessage = new ErrorMessage(errorCode, exception.getMessage());
        return Response.status((Response.Status)status).entity((Object)errorMessage).build();
    }

    private Response getResponse(Throwable cause) {
        ResponsePair responsePair = HANDLED.get(cause.getClass());
        ErrorMessage errorMessage = new ErrorMessage(responsePair.errorCode, cause.getMessage());
        return Response.status((Response.Status)responsePair.status).entity((Object)errorMessage).build();
    }

    private static class ResponsePair {
        private final Response.Status status;
        private final int errorCode;

        ResponsePair(Response.Status status, int errorCode) {
            this.status = status;
            this.errorCode = errorCode;
        }
    }
}

