/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.rest.metrics;

import io.confluent.rest.metrics.MetricNameUtil;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.WindowedCount;

public class JettyRequestMetricsFilter
implements Filter {
    private static final long SENSOR_EXPIRY_SECONDS = TimeUnit.HOURS.toSeconds(1L);
    private static final String GROUP_NAME = "jetty-metrics";
    private Sensor sensor = null;

    public JettyRequestMetricsFilter(Metrics metrics, Map<String, String> metricTags, String jmxPrefix) {
        if (metrics != null) {
            String sensorNamePrefix = jmxPrefix + ":jetty-metrics";
            TreeMap<String, String> instanceMetricsTags = new TreeMap<String, String>(metricTags);
            String sensorTags = instanceMetricsTags.keySet().stream().map(key -> ":" + (String)instanceMetricsTags.get(key)).collect(Collectors.joining());
            String sensorName = sensorNamePrefix + ":jetty-request" + sensorTags;
            this.sensor = metrics.sensor(sensorName, null, SENSOR_EXPIRY_SECONDS, Sensor.RecordingLevel.INFO, (Sensor[])null);
            this.sensor.add(MetricNameUtil.getMetricName(metrics, GROUP_NAME, "request-rate", "The average number of requests per second in Jetty layer", instanceMetricsTags), (MeasurableStat)new Rate());
            this.sensor.add(MetricNameUtil.getMetricName(metrics, GROUP_NAME, "request-count", "A windowed count of requests in Jetty layer", instanceMetricsTags), (MeasurableStat)new WindowedCount());
            this.sensor.add(MetricNameUtil.getMetricName(metrics, GROUP_NAME, "request-total", "A cumulative count of requests in Jetty layer", instanceMetricsTags), (MeasurableStat)new CumulativeCount());
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.sensor != null) {
            this.sensor.record();
        }
        chain.doFilter(request, response);
    }

    public void destroy() {
    }
}

