/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import kafka.raft.KafkaRaftManager;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.FaultHandlerFactory;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer;
import kafka.server.SharedServer;
import kafka.server.metadata.KRaftMetadataCache;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.test.JaasModule;
import org.apache.kafka.common.test.JaasUtils;
import org.apache.kafka.common.test.KafkaClusterThreadFactory;
import org.apache.kafka.common.test.MockFaultHandler;
import org.apache.kafka.common.test.PreboundSocketFactoryManager;
import org.apache.kafka.common.test.TestKitNode;
import org.apache.kafka.common.test.TestKitNodes;
import org.apache.kafka.common.test.TestUtils;
import org.apache.kafka.common.utils.ThreadUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.controller.Controller;
import org.apache.kafka.metadata.authorizer.StandardAuthorizer;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.storage.Formatter;
import org.apache.kafka.raft.DynamicVoters;
import org.apache.kafka.raft.QuorumConfig;
import org.apache.kafka.server.common.ApiMessageAndVersion;
import org.apache.kafka.server.fault.FaultHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;
import scala.Option;

public class KafkaClusterTestKit
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(KafkaClusterTestKit.class);
    private static final String KAFKA_CLUSTER_THREAD_PREFIX = "kafka-cluster-test-kit-";
    private final ExecutorService executorService;
    private final KafkaClusterThreadFactory threadFactory = new KafkaClusterThreadFactory("kafka-cluster-test-kit-");
    private final TestKitNodes nodes;
    private final Map<Integer, ControllerServer> controllers;
    private final Map<Integer, BrokerServer> brokers;
    private final File baseDirectory;
    private final SimpleFaultHandlerFactory faultHandlerFactory;
    private final PreboundSocketFactoryManager socketFactoryManager;
    private final String controllerListenerName;
    private final Option<CompletableFuture<Integer>> interBrokerPortFuture;
    private final Optional<File> jaasFile;
    private final boolean deleteOnClose;

    private KafkaClusterTestKit(TestKitNodes nodes, Map<Integer, ControllerServer> controllers, Map<Integer, BrokerServer> brokers, File baseDirectory, SimpleFaultHandlerFactory faultHandlerFactory, PreboundSocketFactoryManager socketFactoryManager, Option<CompletableFuture<Integer>> interBrokerPortFuture, Optional<File> jaasFile, boolean deleteOnClose) {
        int numOfExecutorThreads = (nodes.brokerNodes().size() + nodes.controllerNodes().size()) * 2;
        this.executorService = Executors.newFixedThreadPool(numOfExecutorThreads, this.threadFactory);
        this.nodes = nodes;
        this.controllers = controllers;
        this.brokers = brokers;
        this.baseDirectory = baseDirectory;
        this.faultHandlerFactory = faultHandlerFactory;
        this.socketFactoryManager = socketFactoryManager;
        this.controllerListenerName = nodes.controllerListenerName().value();
        this.interBrokerPortFuture = interBrokerPortFuture;
        this.jaasFile = jaasFile;
        this.deleteOnClose = deleteOnClose;
    }

    public void format() throws Exception {
        ArrayList futures = new ArrayList();
        try {
            for (ControllerServer controllerServer : this.controllers.values()) {
                futures.add(this.executorService.submit(() -> this.formatNode(controller.sharedServer().metaPropsEnsemble(), true)));
            }
            for (Map.Entry entry : this.brokers.entrySet()) {
                BrokerServer brokerServer = (BrokerServer)entry.getValue();
                futures.add(this.executorService.submit(() -> this.formatNode(broker.sharedServer().metaPropsEnsemble(), !this.nodes.isCombined(((TestKitNode)this.nodes().brokerNodes().get(entry.getKey())).id()))));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            for (Future future : futures) {
                future.cancel(true);
            }
            throw e;
        }
    }

    private void formatNode(MetaPropertiesEnsemble ensemble, boolean writeMetadataDirectory) {
        try {
            Formatter formatter = new Formatter();
            formatter.setNodeId(ensemble.nodeId().getAsInt());
            formatter.setClusterId((String)ensemble.clusterId().get());
            if (writeMetadataDirectory) {
                formatter.setDirectories(ensemble.logDirProps().keySet());
            } else {
                formatter.setDirectories((Collection)ensemble.logDirProps().keySet().stream().filter(d -> !((String)ensemble.metadataLogDir().get()).equals(d)).collect(Collectors.toSet()));
            }
            if (formatter.directories().isEmpty()) {
                return;
            }
            formatter.setReleaseVersion(this.nodes.bootstrapMetadata().metadataVersion());
            formatter.setFeatureLevel("kraft.version", Short.valueOf(this.nodes.bootstrapMetadata().featureLevel("kraft.version")));
            formatter.setUnstableFeatureVersionsEnabled(true);
            formatter.setIgnoreFormatted(false);
            formatter.setControllerListenerName(this.controllerListenerName);
            if (writeMetadataDirectory) {
                formatter.setMetadataLogDirectory((String)ensemble.metadataLogDir().get());
            } else {
                formatter.setMetadataLogDirectory(Optional.empty());
            }
            if (this.nodes.bootstrapMetadata().featureLevel("kraft.version") > 0) {
                StringBuilder dynamicVotersBuilder = new StringBuilder();
                String prefix = "";
                for (TestKitNode controllerNode : this.nodes.controllerNodes().values()) {
                    int port = this.socketFactoryManager.getOrCreatePortForListener(controllerNode.id(), this.controllerListenerName);
                    dynamicVotersBuilder.append(prefix);
                    prefix = ",";
                    dynamicVotersBuilder.append(String.format("%d@localhost:%d:%s", controllerNode.id(), port, controllerNode.metadataDirectoryId()));
                }
                formatter.setInitialControllers(DynamicVoters.parse((String)dynamicVotersBuilder.toString()));
            }
            formatter.run();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to format node " + String.valueOf(ensemble.nodeId()), e);
        }
    }

    public void startup() throws ExecutionException, InterruptedException {
        ArrayList futures = new ArrayList();
        try {
            for (ControllerServer controllerServer : this.controllers.values()) {
                futures.add(this.executorService.submit(() -> ((ControllerServer)controllerServer).startup()));
            }
            for (BrokerServer brokerServer : this.brokers.values()) {
                futures.add(this.executorService.submit(() -> ((BrokerServer)brokerServer).startup()));
            }
            for (Future future : futures) {
                future.get();
            }
        }
        catch (Exception e) {
            for (Future future : futures) {
                future.cancel(true);
            }
            throw e;
        }
    }

    public void waitForReadyBrokers() throws ExecutionException, InterruptedException {
        ControllerServer controllerServer = this.controllers.values().iterator().next();
        Controller controller = controllerServer.controller();
        controller.waitForReadyBrokers(this.brokers.size()).get();
        TestUtils.waitForCondition(() -> this.brokers.values().stream().map(BrokerServer::metadataCache).allMatch(cache -> this.brokers.values().stream().map(b -> b.config().brokerId()).allMatch(arg_0 -> ((KRaftMetadataCache)cache).hasAliveBroker(arg_0))), "Failed to wait for publisher to publish the metadata update to each broker.");
    }

    public ClientPropertiesBuilder newClientPropertiesBuilder(Properties properties) {
        return new ClientPropertiesBuilder(properties);
    }

    public ClientPropertiesBuilder newClientPropertiesBuilder() {
        return new ClientPropertiesBuilder();
    }

    public Properties clientProperties() {
        return new ClientPropertiesBuilder().build();
    }

    public String bootstrapServers() {
        StringBuilder bld = new StringBuilder();
        String prefix = "";
        for (Map.Entry<Integer, BrokerServer> entry : this.brokers.entrySet()) {
            ListenerName listenerName;
            int brokerId = entry.getKey();
            BrokerServer broker = entry.getValue();
            int port = broker.boundPort(listenerName = this.nodes.brokerListenerName());
            if (port <= 0) {
                throw new RuntimeException("Broker " + brokerId + " does not yet have a bound port for " + String.valueOf(listenerName) + ".  Did you start the cluster yet?");
            }
            bld.append(prefix).append("localhost:").append(port);
            prefix = ",";
        }
        return bld.toString();
    }

    public String bootstrapControllers() {
        StringBuilder bld = new StringBuilder();
        String prefix = "";
        for (Map.Entry<Integer, ControllerServer> entry : this.controllers.entrySet()) {
            int id = entry.getKey();
            ControllerServer controller = entry.getValue();
            ListenerName listenerName = this.nodes.controllerListenerName();
            int port = controller.socketServer().boundPort(listenerName);
            if (port <= 0) {
                throw new RuntimeException("Controller " + id + " does not yet have a bound port for " + String.valueOf(listenerName) + ".  Did you start the cluster yet?");
            }
            bld.append(prefix).append("localhost:").append(port);
            prefix = ",";
        }
        return bld.toString();
    }

    public Map<Integer, ControllerServer> controllers() {
        return this.controllers;
    }

    public Option<CompletableFuture<Integer>> interBrokerPortFuture() {
        return this.interBrokerPortFuture;
    }

    public Controller waitForActiveController() throws InterruptedException {
        AtomicReference<Object> active = new AtomicReference<Object>(null);
        TestUtils.waitForCondition(() -> {
            for (ControllerServer controllerServer : this.controllers.values()) {
                if (!controllerServer.controller().isActive()) continue;
                active.set(controllerServer.controller());
            }
            return active.get() != null;
        }, 60000L, "Controller not active");
        return active.get();
    }

    public Map<Integer, BrokerServer> brokers() {
        return this.brokers;
    }

    public Map<Integer, KafkaRaftManager<ApiMessageAndVersion>> raftManagers() {
        HashMap<Integer, KafkaRaftManager<ApiMessageAndVersion>> results = new HashMap<Integer, KafkaRaftManager<ApiMessageAndVersion>>();
        for (BrokerServer brokerServer : this.brokers().values()) {
            results.put(brokerServer.config().brokerId(), (KafkaRaftManager<ApiMessageAndVersion>)brokerServer.sharedServer().raftManager());
        }
        for (ControllerServer controllerServer : this.controllers().values()) {
            if (results.containsKey(controllerServer.config().nodeId())) continue;
            results.put(controllerServer.config().nodeId(), (KafkaRaftManager<ApiMessageAndVersion>)controllerServer.sharedServer().raftManager());
        }
        return results;
    }

    public TestKitNodes nodes() {
        return this.nodes;
    }

    public MockFaultHandler fatalFaultHandler() {
        return this.faultHandlerFactory.fatalFaultHandler();
    }

    public MockFaultHandler nonFatalFaultHandler() {
        return this.faultHandlerFactory.nonFatalFaultHandler();
    }

    public void shutdownAll() throws Exception {
        ArrayList futureEntries = new ArrayList();
        try {
            for (Map.Entry<Integer, BrokerServer> entry : this.brokers.entrySet()) {
                int n = entry.getKey();
                BrokerServer broker = entry.getValue();
                futureEntries.add(new AbstractMap.SimpleImmutableEntry((CallSite)((Object)("broker" + n)), this.executorService.submit(() -> ((BrokerServer)broker).shutdown())));
            }
            this.waitForAllFutures(futureEntries);
            futureEntries.clear();
            for (Map.Entry<Integer, BrokerServer> entry : this.controllers.entrySet()) {
                int n = entry.getKey();
                ControllerServer controller = (ControllerServer)entry.getValue();
                futureEntries.add(new AbstractMap.SimpleImmutableEntry((CallSite)((Object)("controller" + n)), this.executorService.submit(() -> ((ControllerServer)controller).shutdown())));
            }
            this.waitForAllFutures(futureEntries);
            futureEntries.clear();
            if (this.deleteOnClose && this.jaasFile.isPresent()) {
                Utils.delete((File)this.jaasFile.get());
            }
        }
        catch (Exception e) {
            for (Map.Entry entry : futureEntries) {
                ((Future)entry.getValue()).cancel(true);
            }
            throw e;
        }
    }

    @Override
    public void close() throws Exception {
        try {
            this.shutdownAll();
            if (this.deleteOnClose) {
                Utils.delete((File)this.baseDirectory);
            }
        }
        finally {
            ThreadUtils.shutdownExecutorServiceQuietly((ExecutorService)this.executorService, (long)5L, (TimeUnit)TimeUnit.MINUTES);
            this.socketFactoryManager.close();
        }
        this.waitForAllThreads();
        this.faultHandlerFactory.fatalFaultHandler().maybeRethrowFirstException();
        this.faultHandlerFactory.nonFatalFaultHandler().maybeRethrowFirstException();
    }

    private void waitForAllFutures(List<Map.Entry<String, Future<?>>> futureEntries) throws Exception {
        for (Map.Entry<String, Future<?>> entry : futureEntries) {
            log.debug("waiting for {} to shut down.", (Object)entry.getKey());
            entry.getValue().get();
            log.debug("{} successfully shut down.", (Object)entry.getKey());
        }
    }

    public String clusterId() {
        return this.nodes.clusterId().toString();
    }

    private void waitForAllThreads() throws InterruptedException {
        TestUtils.waitForCondition(() -> Thread.getAllStackTraces().keySet().stream().noneMatch(t -> this.threadFactory.getThreadIds().contains(t.getId())), "Failed to wait for all threads to shut down.");
    }

    static class SimpleFaultHandlerFactory
    implements FaultHandlerFactory {
        private final MockFaultHandler fatalFaultHandler = new MockFaultHandler("fatalFaultHandler");
        private final MockFaultHandler nonFatalFaultHandler = new MockFaultHandler("nonFatalFaultHandler");

        SimpleFaultHandlerFactory() {
        }

        MockFaultHandler fatalFaultHandler() {
            return this.fatalFaultHandler;
        }

        MockFaultHandler nonFatalFaultHandler() {
            return this.nonFatalFaultHandler;
        }

        public FaultHandler build(String name, boolean fatal, Runnable action) {
            if (fatal) {
                return this.fatalFaultHandler;
            }
            return this.nonFatalFaultHandler;
        }
    }

    public class ClientPropertiesBuilder {
        private final Properties properties;
        private boolean usingBootstrapControllers = false;

        public ClientPropertiesBuilder() {
            this.properties = new Properties();
        }

        public ClientPropertiesBuilder(Properties properties) {
            this.properties = properties;
        }

        public ClientPropertiesBuilder setUsingBootstrapControllers(boolean usingBootstrapControllers) {
            this.usingBootstrapControllers = usingBootstrapControllers;
            return this;
        }

        public Properties build() {
            if (this.usingBootstrapControllers) {
                this.properties.setProperty("bootstrap.controllers", KafkaClusterTestKit.this.bootstrapControllers());
                this.properties.remove("bootstrap.servers");
            } else {
                this.properties.setProperty("bootstrap.servers", KafkaClusterTestKit.this.bootstrapServers());
                this.properties.remove("bootstrap.controllers");
            }
            return this.properties;
        }
    }

    public static class Builder {
        private final TestKitNodes nodes;
        private final Map<String, Object> configProps = new HashMap<String, Object>();
        private final SimpleFaultHandlerFactory faultHandlerFactory = new SimpleFaultHandlerFactory();
        private final PreboundSocketFactoryManager socketFactoryManager = new PreboundSocketFactoryManager();
        private final String brokerListenerName;
        private final String controllerListenerName;
        private final String brokerSecurityProtocol;
        private final String controllerSecurityProtocol;
        private boolean deleteOnClose;

        public Builder(TestKitNodes nodes) {
            this.nodes = nodes;
            this.brokerListenerName = nodes.brokerListenerName().value();
            this.controllerListenerName = nodes.controllerListenerName().value();
            this.brokerSecurityProtocol = nodes.brokerListenerProtocol().name;
            this.controllerSecurityProtocol = nodes.controllerListenerProtocol().name;
            this.deleteOnClose = true;
        }

        public Builder setConfigProp(String key, Object value) {
            this.configProps.put(key, value);
            return this;
        }

        private KafkaConfig createNodeConfig(TestKitNode node) throws IOException {
            TestKitNode brokerNode = (TestKitNode)this.nodes.brokerNodes().get(node.id());
            TestKitNode controllerNode = (TestKitNode)this.nodes.controllerNodes().get(node.id());
            HashMap<String, Object> props = new HashMap<String, Object>(this.configProps);
            props.put("server.max.startup.time.ms", Long.toString(TimeUnit.MINUTES.toMillis(10L)));
            props.put("process.roles", this.roles(node.id()));
            props.put("node.id", Integer.toString(node.id()));
            if (controllerNode != null) {
                props.put("metadata.log.dir", controllerNode.metadataDirectory());
                this.setSecurityProtocolProps(props, this.controllerSecurityProtocol);
            } else {
                props.put("metadata.log.dir", node.metadataDirectory());
            }
            if (brokerNode != null) {
                props.put("log.dirs", String.join((CharSequence)",", brokerNode.logDataDirectories()));
                this.setSecurityProtocolProps(props, this.brokerSecurityProtocol);
            } else {
                props.put("log.dirs", controllerNode.metadataDirectory());
            }
            props.putIfAbsent("listener.security.protocol.map", String.format("%s:%s,%s:%s", this.brokerListenerName, this.brokerSecurityProtocol, this.controllerListenerName, this.controllerSecurityProtocol));
            props.putIfAbsent("listeners", this.listeners(node.id()));
            props.putIfAbsent("inter.broker.listener.name", this.brokerListenerName);
            props.putIfAbsent("controller.listener.names", this.controllerListenerName);
            props.put("controller.quorum.voters", this.getQuorumVotersConfig());
            props.putIfAbsent("log.cleaner.dedupe.buffer.size", "2097152");
            props.putIfAbsent("confluent.broker.type.topic.enabled", "false");
            if (brokerNode != null) {
                props.putAll(brokerNode.propertyOverrides());
            }
            if (controllerNode != null) {
                props.putAll(controllerNode.propertyOverrides());
            }
            props.putIfAbsent("unstable.feature.versions.enable", "true");
            props.putIfAbsent("unstable.api.versions.enable", "true");
            return new KafkaConfig(props, false);
        }

        public String getQuorumVotersConfig() throws IOException {
            StringBuilder quorumVoterStringBuilder = new StringBuilder();
            String prefix = "";
            for (int nodeId : this.nodes.controllerNodes().keySet()) {
                quorumVoterStringBuilder.append(prefix).append(nodeId).append("@").append("localhost").append(":").append(this.socketFactoryManager.getOrCreatePortForListener(nodeId, this.controllerListenerName));
                prefix = ",";
            }
            return quorumVoterStringBuilder.toString();
        }

        private void setSecurityProtocolProps(Map<String, Object> props, String securityProtocol) {
            if (securityProtocol.equals(SecurityProtocol.SASL_PLAINTEXT.name)) {
                props.putIfAbsent("sasl.enabled.mechanisms", "PLAIN");
                props.putIfAbsent("sasl.mechanism.inter.broker.protocol", "PLAIN");
                props.putIfAbsent("sasl.mechanism.controller.protocol", "PLAIN");
                props.putIfAbsent("authorizer.class.name", StandardAuthorizer.class.getName());
                props.putIfAbsent("allow.everyone.if.no.acl.found", "false");
                props.putIfAbsent("super.users", "User:plain-admin");
            }
        }

        private Optional<File> maybeSetupJaasFile() throws Exception {
            if (this.brokerSecurityProtocol.equals(SecurityProtocol.SASL_PLAINTEXT.name)) {
                File file = JaasUtils.writeJaasContextsToFile(Set.of(new JaasUtils.JaasSection("KafkaServer", List.of(JaasModule.plainLoginModule("plain-admin", "plain-admin-secret", true, Map.of("plain-user1", "plain-user1-secret", "plain-admin", "plain-admin-secret"))))));
                JaasUtils.refreshJavaLoginConfigParam(file);
                return Optional.of(file);
            }
            return Optional.empty();
        }

        public Builder setDeleteOnClose(boolean deleteOnClose) {
            this.deleteOnClose = deleteOnClose;
            return this;
        }

        public KafkaClusterTestKit build() throws Exception {
            Option interBrokerPortFuture;
            HashMap<Integer, ControllerServer> controllers = new HashMap<Integer, ControllerServer>();
            HashMap<Integer, BrokerServer> brokers = new HashMap<Integer, BrokerServer>();
            HashMap<Integer, SharedServer> jointServers = new HashMap<Integer, SharedServer>();
            File baseDirectory = null;
            Optional<File> jaasFile = this.maybeSetupJaasFile();
            try {
                baseDirectory = new File(this.nodes.baseDirectory());
                interBrokerPortFuture = this.nodes.brokerNodes().isEmpty() ? Option.empty() : Option.apply(new CompletableFuture());
                for (TestKitNode node : this.nodes.controllerNodes().values()) {
                    this.socketFactoryManager.getOrCreatePortForListener(node.id(), this.controllerListenerName);
                }
                if (!this.configProps.containsKey("metrics.context.region")) {
                    for (TestKitNode node : this.nodes.brokerNodes().values()) {
                        this.socketFactoryManager.getOrCreatePortForListener(node.id(), this.brokerListenerName);
                    }
                }
                for (TestKitNode node : this.nodes.controllerNodes().values()) {
                    Builder.setupNodeDirectories(baseDirectory, node.metadataDirectory(), List.of());
                    KafkaConfig config = this.createNodeConfig(node);
                    SharedServer sharedServer = new SharedServer(config, node.initialMetaPropertiesEnsemble(), Time.SYSTEM, new Metrics(), CompletableFuture.completedFuture(QuorumConfig.parseVoterConnections((List)config.quorumConfig().voters())), List.of(), (FaultHandlerFactory)this.faultHandlerFactory, this.socketFactoryManager.getOrCreateSocketFactory(node.id()), Option.empty(), KafkaRaftServer.configSchema(), interBrokerPortFuture);
                    ControllerServer controller = null;
                    try {
                        controller = new ControllerServer(sharedServer, KafkaRaftServer.configSchema(), this.nodes.bootstrapMetadata());
                    }
                    catch (Throwable e) {
                        log.error("Error creating controller {}", (Object)node.id(), (Object)e);
                        Utils.swallow((Logger)log, (Level)Level.WARN, (String)"sharedServer.stopForController error", () -> ((SharedServer)sharedServer).stopForController());
                        throw e;
                    }
                    controllers.put(node.id(), controller);
                    jointServers.put(node.id(), sharedServer);
                }
                for (TestKitNode node : this.nodes.brokerNodes().values()) {
                    SharedServer sharedServer = (SharedServer)jointServers.get(node.id());
                    if (sharedServer == null) {
                        KafkaConfig config = this.createNodeConfig(node);
                        sharedServer = new SharedServer(config, node.initialMetaPropertiesEnsemble(), Time.SYSTEM, new Metrics(), CompletableFuture.completedFuture(QuorumConfig.parseVoterConnections((List)config.quorumConfig().voters())), List.of(), (FaultHandlerFactory)this.faultHandlerFactory, this.socketFactoryManager.getOrCreateSocketFactory(node.id()), Option.empty(), KafkaRaftServer.configSchema(), interBrokerPortFuture);
                        jointServers.put(node.id(), sharedServer);
                    }
                    BrokerServer broker = null;
                    try {
                        broker = new BrokerServer(sharedServer, Optional.empty());
                    }
                    catch (Throwable e) {
                        log.error("Error creating broker {}", (Object)node.id(), (Object)e);
                        Utils.swallow((Logger)log, (Level)Level.WARN, (String)"sharedServer.stopForBroker error", () -> ((SharedServer)sharedServer).stopForBroker());
                        throw e;
                    }
                    brokers.put(node.id(), broker);
                }
            }
            catch (Exception e) {
                for (BrokerServer brokerServer : brokers.values()) {
                    brokerServer.shutdown();
                }
                for (ControllerServer controller : controllers.values()) {
                    controller.shutdown();
                }
                if (baseDirectory != null) {
                    Utils.delete((File)baseDirectory);
                }
                this.socketFactoryManager.close();
                throw e;
            }
            return new KafkaClusterTestKit(this.nodes, controllers, brokers, baseDirectory, this.faultHandlerFactory, this.socketFactoryManager, (Option<CompletableFuture<Integer>>)interBrokerPortFuture, jaasFile, this.deleteOnClose);
        }

        private static void disableUnsupportedConfigsEnabledByDefault(Map<String, String> props) {
            List configsThatMustNotBeEnabled = List.of();
            String requiredValue = Boolean.FALSE.toString();
            configsThatMustNotBeEnabled.stream().forEach(key -> {
                String value = props.getOrDefault(key, requiredValue);
                if (!value.equals(requiredValue)) {
                    throw new IllegalStateException(String.format("KRaft does not yet support a value other than %s for %s: %s", requiredValue, key, value));
                }
                props.put((String)key, requiredValue);
            });
        }

        private String listeners(int node) {
            if (this.nodes.isCombined(node)) {
                return String.format("%s://localhost:0,%s://localhost:0", this.brokerListenerName, this.controllerListenerName);
            }
            if (this.nodes.controllerNodes().containsKey(node)) {
                return String.format("%s://localhost:0", this.controllerListenerName);
            }
            return String.format("%s://localhost:0", this.brokerListenerName);
        }

        private String roles(int node) {
            if (this.nodes.isCombined(node)) {
                return "broker,controller";
            }
            if (this.nodes.controllerNodes().containsKey(node)) {
                return "controller";
            }
            return "broker";
        }

        private static void setupNodeDirectories(File baseDirectory, String metadataDirectory, Collection<String> logDataDirectories) throws Exception {
            Files.createDirectories(new File(baseDirectory, "local").toPath(), new FileAttribute[0]);
            Files.createDirectories(Paths.get(metadataDirectory, new String[0]), new FileAttribute[0]);
            for (String logDataDirectory : logDataDirectories) {
                Files.createDirectories(Paths.get(logDataDirectory, new String[0]), new FileAttribute[0]);
            }
        }
    }
}

