/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.test;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.test.TestKitNode;
import org.apache.kafka.common.test.TestUtils;
import org.apache.kafka.common.test.api.TestKitDefaults;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;
import org.apache.kafka.server.common.Feature;
import org.apache.kafka.server.common.MetadataVersion;

public class TestKitNodes {
    private final String baseDirectory;
    private final String clusterId;
    private final BootstrapMetadata bootstrapMetadata;
    private final SortedMap<Integer, TestKitNode> controllerNodes;
    private final SortedMap<Integer, TestKitNode> brokerNodes;
    private final ListenerName brokerListenerName;
    private final ListenerName controllerListenerName;
    private final SecurityProtocol brokerSecurityProtocol;
    private final SecurityProtocol controllerSecurityProtocol;

    private TestKitNodes(String baseDirectory, String clusterId, BootstrapMetadata bootstrapMetadata, SortedMap<Integer, TestKitNode> controllerNodes, SortedMap<Integer, TestKitNode> brokerNodes, ListenerName brokerListenerName, SecurityProtocol brokerSecurityProtocol, ListenerName controllerListenerName, SecurityProtocol controllerSecurityProtocol) {
        this.baseDirectory = Objects.requireNonNull(baseDirectory);
        this.clusterId = Objects.requireNonNull(clusterId);
        this.bootstrapMetadata = Objects.requireNonNull(bootstrapMetadata);
        this.controllerNodes = Collections.unmodifiableSortedMap(new TreeMap<Integer, TestKitNode>(Objects.requireNonNull(controllerNodes)));
        this.brokerNodes = Collections.unmodifiableSortedMap(new TreeMap<Integer, TestKitNode>(Objects.requireNonNull(brokerNodes)));
        this.brokerListenerName = Objects.requireNonNull(brokerListenerName);
        this.controllerListenerName = Objects.requireNonNull(controllerListenerName);
        this.brokerSecurityProtocol = Objects.requireNonNull(brokerSecurityProtocol);
        this.controllerSecurityProtocol = Objects.requireNonNull(controllerSecurityProtocol);
    }

    public boolean isCombined(int node) {
        return this.controllerNodes.containsKey(node) && this.brokerNodes.containsKey(node);
    }

    public String baseDirectory() {
        return this.baseDirectory;
    }

    public String clusterId() {
        return this.clusterId;
    }

    public SortedMap<Integer, TestKitNode> controllerNodes() {
        return this.controllerNodes;
    }

    public BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    public SortedMap<Integer, TestKitNode> brokerNodes() {
        return this.brokerNodes;
    }

    public ListenerName brokerListenerName() {
        return this.brokerListenerName;
    }

    public SecurityProtocol brokerListenerProtocol() {
        return this.brokerSecurityProtocol;
    }

    public ListenerName controllerListenerName() {
        return this.controllerListenerName;
    }

    public SecurityProtocol controllerListenerProtocol() {
        return this.controllerSecurityProtocol;
    }

    private static TestKitNode buildBrokerNode(int id, String baseDirectory, String clusterId, boolean combined, final Map<String, String> propertyOverrides, int numDisksPerBroker) {
        List<String> logDataDirectories = IntStream.range(0, numDisksPerBroker).mapToObj(i -> {
            if (combined) {
                return String.format("combined_%d_%d", id, i);
            }
            return String.format("broker_%d_data%d", id, i);
        }).map(logDir -> {
            if (Paths.get(logDir, new String[0]).isAbsolute()) {
                return logDir;
            }
            return new File(baseDirectory, (String)logDir).getAbsolutePath();
        }).toList();
        final MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(MetaPropertiesEnsemble.EMPTY);
        copier.setMetaLogDir(Optional.of(logDataDirectories.get(0)));
        for (String logDir2 : logDataDirectories) {
            copier.setLogDirProps(logDir2, new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(id).setDirectoryId(copier.generateValidDirectoryId()).build());
        }
        return new TestKitNode(){
            private final MetaPropertiesEnsemble ensemble;
            {
                this.ensemble = copier.copy();
            }

            @Override
            public MetaPropertiesEnsemble initialMetaPropertiesEnsemble() {
                return this.ensemble;
            }

            @Override
            public Map<String, String> propertyOverrides() {
                return Collections.unmodifiableMap(propertyOverrides);
            }
        };
    }

    private static TestKitNode buildControllerNode(int id, String baseDirectory, String clusterId, boolean combined, final Map<String, String> propertyOverrides) {
        String metadataDirectory = new File(baseDirectory, combined ? String.format("combined_%d_0", id) : String.format("controller_%d", id)).getAbsolutePath();
        final MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(MetaPropertiesEnsemble.EMPTY);
        copier.setMetaLogDir(Optional.of(metadataDirectory));
        copier.setLogDirProps(metadataDirectory, new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId).setNodeId(id).setDirectoryId(copier.generateValidDirectoryId()).build());
        return new TestKitNode(){
            private final MetaPropertiesEnsemble ensemble;
            {
                this.ensemble = copier.copy();
            }

            @Override
            public MetaPropertiesEnsemble initialMetaPropertiesEnsemble() {
                return this.ensemble;
            }

            @Override
            public Map<String, String> propertyOverrides() {
                return Collections.unmodifiableMap(propertyOverrides);
            }
        };
    }

    public static class Builder {
        private boolean combined;
        private String clusterId;
        private Path baseDirectory;
        private int numControllerNodes;
        private int numBrokerNodes;
        private int numDisksPerBroker = 1;
        private Map<Integer, Map<String, String>> perServerProperties = Map.of();
        private BootstrapMetadata bootstrapMetadata;
        private ListenerName brokerListenerName = ListenerName.normalised((String)"EXTERNAL");
        private SecurityProtocol brokerSecurityProtocol = TestKitDefaults.DEFAULT_BROKER_SECURITY_PROTOCOL;
        private ListenerName controllerListenerName = ListenerName.normalised((String)"CONTROLLER");
        private SecurityProtocol controllerSecurityProtocol = TestKitDefaults.DEFAULT_CONTROLLER_SECURITY_PROTOCOL;

        public Builder() {
            this(BootstrapMetadata.fromVersions((MetadataVersion)MetadataVersion.latestTesting(), (Map)Feature.PRODUCTION_FEATURES.stream().collect(Collectors.toMap(Feature::featureName, feature -> feature.defaultLevel(MetadataVersion.latestTesting()), (existing, replacement) -> existing, TreeMap::new)), (String)"testkit"));
        }

        public Builder(BootstrapMetadata bootstrapMetadata) {
            this.bootstrapMetadata = bootstrapMetadata;
        }

        public Builder setClusterId(String clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public Builder setBootstrapMetadataVersion(MetadataVersion metadataVersion) {
            this.bootstrapMetadata = BootstrapMetadata.fromVersions((MetadataVersion)metadataVersion, (Map)Feature.PRODUCTION_FEATURES.stream().collect(Collectors.toMap(Feature::featureName, feature -> feature.defaultLevel(metadataVersion), (existing, replacement) -> existing, TreeMap::new)), (String)"testkit");
            return this;
        }

        public Builder setBootstrapMetadata(BootstrapMetadata bootstrapMetadata) {
            this.bootstrapMetadata = bootstrapMetadata;
            return this;
        }

        public Builder setFeature(String featureName, short level) {
            this.bootstrapMetadata = this.bootstrapMetadata.copyWithFeatureRecord(featureName, level);
            return this;
        }

        public Builder setCombined(boolean combined) {
            this.combined = combined;
            return this;
        }

        public Builder setNumControllerNodes(int numControllerNodes) {
            this.numControllerNodes = numControllerNodes;
            return this;
        }

        public Builder setNumBrokerNodes(int numBrokerNodes) {
            this.numBrokerNodes = numBrokerNodes;
            return this;
        }

        public Builder setNumDisksPerBroker(int numDisksPerBroker) {
            this.numDisksPerBroker = numDisksPerBroker;
            return this;
        }

        public Builder setPerServerProperties(Map<Integer, Map<String, String>> perServerProperties) {
            this.perServerProperties = Collections.unmodifiableMap(perServerProperties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Map.copyOf((Map)e.getValue()))));
            return this;
        }

        public Builder setBaseDirectory(Path baseDirectory) {
            this.baseDirectory = baseDirectory;
            return this;
        }

        public Builder setBrokerListenerName(ListenerName listenerName) {
            this.brokerListenerName = listenerName;
            return this;
        }

        public Builder setBrokerSecurityProtocol(SecurityProtocol securityProtocol) {
            this.brokerSecurityProtocol = securityProtocol;
            return this;
        }

        public Builder setControllerListenerName(ListenerName listenerName) {
            this.controllerListenerName = listenerName;
            return this;
        }

        public Builder setControllerSecurityProtocol(SecurityProtocol securityProtocol) {
            this.controllerSecurityProtocol = securityProtocol;
            return this;
        }

        public TestKitNodes build() {
            if (this.numControllerNodes < 0) {
                throw new IllegalArgumentException("Invalid negative value for numControllerNodes");
            }
            if (this.numBrokerNodes < 0) {
                throw new IllegalArgumentException("Invalid negative value for numBrokerNodes");
            }
            if (this.numDisksPerBroker <= 0) {
                throw new IllegalArgumentException("Invalid value for numDisksPerBroker");
            }
            if (this.brokerSecurityProtocol != SecurityProtocol.PLAINTEXT && this.brokerSecurityProtocol != SecurityProtocol.SASL_PLAINTEXT || this.controllerSecurityProtocol != SecurityProtocol.PLAINTEXT && this.controllerSecurityProtocol != SecurityProtocol.SASL_PLAINTEXT) {
                throw new IllegalArgumentException("Currently only support PLAINTEXT / SASL_PLAINTEXT security protocol");
            }
            if (this.baseDirectory == null) {
                this.baseDirectory = TestUtils.tempDirectory().toPath();
            }
            if (this.clusterId == null) {
                this.clusterId = Uuid.randomUuid().toString();
            }
            int controllerId = this.combined ? 0 : 3000;
            List<Integer> controllerNodeIds = IntStream.range(controllerId, controllerId + this.numControllerNodes).boxed().toList();
            List<Integer> brokerNodeIds = IntStream.range(0, 0 + this.numBrokerNodes).boxed().toList();
            String unknownIds = this.perServerProperties.keySet().stream().filter(id -> !controllerNodeIds.contains(id)).filter(id -> !brokerNodeIds.contains(id)).map(Object::toString).collect(Collectors.joining(", "));
            if (!unknownIds.isEmpty()) {
                throw new IllegalArgumentException(String.format("Unknown server id %s in perServerProperties, the existent server ids are %s", unknownIds, Stream.concat(brokerNodeIds.stream(), controllerNodeIds.stream()).map(Object::toString).collect(Collectors.joining(", "))));
            }
            TreeMap<Integer, TestKitNode> controllerNodes = new TreeMap<Integer, TestKitNode>();
            for (int id2 : controllerNodeIds) {
                TestKitNode controllerNode = TestKitNodes.buildControllerNode(id2, this.baseDirectory.toFile().getAbsolutePath(), this.clusterId, brokerNodeIds.contains(id2), this.perServerProperties.getOrDefault(id2, Map.of()));
                controllerNodes.put(id2, controllerNode);
            }
            TreeMap<Integer, TestKitNode> brokerNodes = new TreeMap<Integer, TestKitNode>();
            for (int id3 : brokerNodeIds) {
                TestKitNode brokerNode = TestKitNodes.buildBrokerNode(id3, this.baseDirectory.toFile().getAbsolutePath(), this.clusterId, controllerNodeIds.contains(id3), this.perServerProperties.getOrDefault(id3, Map.of()), this.numDisksPerBroker);
                brokerNodes.put(id3, brokerNode);
            }
            return new TestKitNodes(this.baseDirectory.toFile().getAbsolutePath(), this.clusterId, this.bootstrapMetadata, controllerNodes, brokerNodes, this.brokerListenerName, this.brokerSecurityProtocol, this.controllerListenerName, this.controllerSecurityProtocol);
        }
    }
}

