/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy;

import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.VersionInfo;
import io.kroxylicious.proxy.bootstrap.FilterChainFactory;
import io.kroxylicious.proxy.config.Configuration;
import io.kroxylicious.proxy.config.IllegalConfigurationException;
import io.kroxylicious.proxy.config.MicrometerDefinition;
import io.kroxylicious.proxy.config.PluginFactoryRegistry;
import io.kroxylicious.proxy.config.admin.ManagementConfiguration;
import io.kroxylicious.proxy.internal.ApiVersionsServiceImpl;
import io.kroxylicious.proxy.internal.KafkaProxyInitializer;
import io.kroxylicious.proxy.internal.MeterRegistries;
import io.kroxylicious.proxy.internal.PortConflictDetector;
import io.kroxylicious.proxy.internal.admin.ManagementInitializer;
import io.kroxylicious.proxy.internal.config.Features;
import io.kroxylicious.proxy.internal.net.DefaultNetworkBindingOperationProcessor;
import io.kroxylicious.proxy.internal.net.EndpointGateway;
import io.kroxylicious.proxy.internal.net.EndpointRegistry;
import io.kroxylicious.proxy.internal.net.NetworkBindingOperationProcessor;
import io.kroxylicious.proxy.internal.util.Metrics;
import io.kroxylicious.proxy.model.VirtualClusterModel;
import io.kroxylicious.proxy.service.HostPort;
import io.micrometer.core.instrument.Tag;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.incubator.channel.uring.IOUring;
import io.netty.incubator.channel.uring.IOUringEventLoopGroup;
import io.netty.incubator.channel.uring.IOUringServerSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.kafka.common.protocol.ApiKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaProxy
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaProxy.class);
    private static final Logger STARTUP_SHUTDOWN_LOGGER = LoggerFactory.getLogger((String)"io.kroxylicious.proxy.StartupShutdownLogger");
    private final Configuration config;
    @Nullable
    private final ManagementConfiguration managementConfiguration;
    private final List<MicrometerDefinition> micrometerConfig;
    private final List<VirtualClusterModel> virtualClusterModels;
    private final AtomicBoolean running = new AtomicBoolean();
    private final CompletableFuture<Void> shutdown = new CompletableFuture();
    private final NetworkBindingOperationProcessor bindingOperationProcessor = new DefaultNetworkBindingOperationProcessor();
    private final EndpointRegistry endpointRegistry = new EndpointRegistry(this.bindingOperationProcessor);
    private final PluginFactoryRegistry pfr;
    @Nullable
    private MeterRegistries meterRegistries;
    @Nullable
    private FilterChainFactory filterChainFactory;
    @Nullable
    private EventGroupConfig managementEventGroup;
    @Nullable
    private EventGroupConfig serverEventGroup;

    public KafkaProxy(PluginFactoryRegistry pfr, Configuration config, Features features) {
        this.pfr = Objects.requireNonNull(pfr);
        this.config = KafkaProxy.validate(Objects.requireNonNull(config), Objects.requireNonNull(features));
        this.virtualClusterModels = config.virtualClusterModel(pfr);
        this.managementConfiguration = config.management();
        this.micrometerConfig = config.getMicrometer();
    }

    static Configuration validate(Configuration config, Features features) {
        List<String> errorMessages = features.supports(config);
        if (!errorMessages.isEmpty()) {
            String message = "invalid configuration: " + String.join((CharSequence)",", errorMessages);
            LOGGER.error(message);
            throw new IllegalConfigurationException(message);
        }
        return config;
    }

    public KafkaProxy startup() {
        if (this.running.getAndSet(true)) {
            throw new IllegalStateException("This proxy is already running");
        }
        try {
            STARTUP_SHUTDOWN_LOGGER.info("Kroxylicious is starting");
            this.meterRegistries = new MeterRegistries(this.pfr, this.micrometerConfig);
            this.initVersionInfoMetric();
            PortConflictDetector portConflictDefector = new PortConflictDetector();
            Optional<HostPort> managementHostPort = Optional.ofNullable(this.managementConfiguration).map(c -> new HostPort(c.getEffectiveBindAddress(), c.getEffectivePort()));
            portConflictDefector.validate(this.virtualClusterModels, managementHostPort);
            int availableCores = Runtime.getRuntime().availableProcessors();
            this.managementEventGroup = this.buildNettyEventGroups("management", availableCores, this.config.isUseIoUring());
            this.serverEventGroup = this.buildNettyEventGroups("server", availableCores, this.config.isUseIoUring());
            CompletableFuture<Void> managementFuture = this.maybeStartManagementListener(this.managementEventGroup, this.meterRegistries);
            Map<ApiKeys, Short> overrideMap = this.getApiKeyMaxVersionOverride(this.config);
            ApiVersionsServiceImpl apiVersionsService = new ApiVersionsServiceImpl(overrideMap);
            this.filterChainFactory = new FilterChainFactory(this.pfr, this.config.filterDefinitions());
            ServerBootstrap tlsServerBootstrap = this.buildServerBootstrap(this.serverEventGroup, new KafkaProxyInitializer(this.filterChainFactory, this.pfr, true, this.endpointRegistry, this.endpointRegistry, false, Map.of(), apiVersionsService));
            ServerBootstrap plainServerBootstrap = this.buildServerBootstrap(this.serverEventGroup, new KafkaProxyInitializer(this.filterChainFactory, this.pfr, false, this.endpointRegistry, this.endpointRegistry, false, Map.of(), apiVersionsService));
            this.bindingOperationProcessor.start(plainServerBootstrap, tlsServerBootstrap);
            CompletableFuture.allOf((CompletableFuture[])Stream.concat(Stream.of(managementFuture), this.virtualClusterModels.stream().flatMap(vc -> vc.gateways().values().stream()).map(vcl -> this.endpointRegistry.registerVirtualCluster((EndpointGateway)vcl).toCompletableFuture())).toArray(CompletableFuture[]::new)).join();
            this.initDeprecatedMessageMetrics();
            STARTUP_SHUTDOWN_LOGGER.info("Kroxylicious is started");
            return this;
        }
        catch (RuntimeException e) {
            this.shutdown();
            throw e;
        }
    }

    private void initVersionInfoMetric() {
        Metrics.versionInfoMetric(VersionInfo.VERSION_INFO);
    }

    private void initDeprecatedMessageMetrics() {
        this.virtualClusterModels.forEach(virtualClusterModel -> {
            List<Tag> tags = Metrics.tags("flowing", "downstream", "virtualCluster", virtualClusterModel.getClusterName());
            Metrics.taggedCounter("kroxylicious_inbound_downstream_messages", tags);
            Metrics.taggedCounter("kroxylicious_inbound_downstream_decoded_messages", tags);
        });
    }

    private Map<ApiKeys, Short> getApiKeyMaxVersionOverride(Configuration config) {
        Map apiKeyIdMaxVersion = config.development().map(m -> m.get("apiKeyIdMaxVersionOverride")).filter(Map.class::isInstance).map(Map.class::cast).orElse(Map.of());
        return apiKeyIdMaxVersion.entrySet().stream().collect(Collectors.toMap(e -> ApiKeys.valueOf((String)((String)e.getKey())), e -> ((Number)e.getValue()).shortValue()));
    }

    private ServerBootstrap buildServerBootstrap(EventGroupConfig virtualHostEventGroup, KafkaProxyInitializer kafkaProxyInitializer) {
        return ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(virtualHostEventGroup.bossGroup(), virtualHostEventGroup.workerGroup()).channel(virtualHostEventGroup.clazz())).option(ChannelOption.SO_REUSEADDR, (Object)true)).childHandler((ChannelHandler)kafkaProxyInitializer).childOption(ChannelOption.TCP_NODELAY, (Object)true);
    }

    private EventGroupConfig buildNettyEventGroups(String name, int availableCores, boolean useIoUring) {
        Class<IOUringServerSocketChannel> channelClass;
        IOUringEventLoopGroup workerGroup;
        IOUringEventLoopGroup bossGroup;
        if (useIoUring) {
            if (!IOUring.isAvailable()) {
                throw new IllegalStateException("io_uring not available due to: " + String.valueOf(IOUring.unavailabilityCause()));
            }
            bossGroup = new IOUringEventLoopGroup(1);
            workerGroup = new IOUringEventLoopGroup(availableCores);
            channelClass = IOUringServerSocketChannel.class;
        } else if (Epoll.isAvailable()) {
            bossGroup = new EpollEventLoopGroup(1);
            workerGroup = new EpollEventLoopGroup(availableCores);
            channelClass = EpollServerSocketChannel.class;
        } else if (KQueue.isAvailable()) {
            bossGroup = new KQueueEventLoopGroup(1);
            workerGroup = new KQueueEventLoopGroup(availableCores);
            channelClass = KQueueServerSocketChannel.class;
        } else {
            bossGroup = new NioEventLoopGroup(1);
            workerGroup = new NioEventLoopGroup(availableCores);
            channelClass = NioServerSocketChannel.class;
        }
        return new EventGroupConfig(name, (EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup, channelClass);
    }

    private CompletableFuture<Void> maybeStartManagementListener(EventGroupConfig eventGroupConfig, MeterRegistries meterRegistries) {
        return Optional.ofNullable(this.managementConfiguration).map(mc -> {
            ServerBootstrap metricsBootstrap = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(eventGroupConfig.bossGroup(), eventGroupConfig.workerGroup()).option(ChannelOption.SO_REUSEADDR, (Object)true)).channel(eventGroupConfig.clazz())).childHandler((ChannelHandler)new ManagementInitializer(meterRegistries, (ManagementConfiguration)mc));
            LOGGER.info("Binding management endpoint: {}:{}", (Object)mc.getEffectiveBindAddress(), (Object)mc.getEffectivePort());
            CompletableFuture future = new CompletableFuture();
            metricsBootstrap.bind(this.managementConfiguration.getEffectiveBindAddress(), this.managementConfiguration.getEffectivePort()).addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> ForkJoinPool.commonPool().execute(() -> {
                if (channelFuture.cause() != null) {
                    future.completeExceptionally(channelFuture.cause());
                } else {
                    future.complete(null);
                }
            })));
            return future;
        }).orElseGet(() -> CompletableFuture.completedFuture(null));
    }

    public void block() {
        if (!this.running.get()) {
            throw new IllegalStateException("This proxy is not running");
        }
        this.shutdown.join();
    }

    public void shutdown() {
        if (!this.running.getAndSet(false)) {
            throw new IllegalStateException("This proxy is not running");
        }
        try {
            STARTUP_SHUTDOWN_LOGGER.info("Shutting down");
            this.endpointRegistry.shutdown().handle((u, t) -> {
                this.bindingOperationProcessor.close();
                ArrayList<Object> closeFutures = new ArrayList<Object>();
                if (this.serverEventGroup != null) {
                    closeFutures.addAll(this.serverEventGroup.shutdownGracefully());
                }
                if (this.managementEventGroup != null) {
                    closeFutures.addAll(this.managementEventGroup.shutdownGracefully());
                }
                closeFutures.forEach((Consumer<Object>)((Consumer<Future>)Future::syncUninterruptibly));
                if (this.filterChainFactory != null) {
                    this.filterChainFactory.close();
                }
                if (t != null) {
                    if (t instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)t;
                        throw re;
                    }
                    throw new RuntimeException((Throwable)t);
                }
                return null;
            }).toCompletableFuture().join();
            if (this.meterRegistries != null) {
                this.meterRegistries.close();
            }
        }
        finally {
            this.managementEventGroup = null;
            this.serverEventGroup = null;
            this.meterRegistries = null;
            this.filterChainFactory = null;
            this.shutdown.complete(null);
            LOGGER.info("Shut down completed.");
        }
    }

    @Override
    public void close() throws Exception {
        if (this.running.get()) {
            this.shutdown();
        }
    }

    private record EventGroupConfig(String name, EventLoopGroup bossGroup, EventLoopGroup workerGroup, Class<? extends ServerChannel> clazz) {
        public List<Future<?>> shutdownGracefully() {
            return List.of(this.bossGroup.shutdownGracefully(), this.workerGroup.shutdownGracefully());
        }
    }
}

