/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class BrokerAddressPatternUtils {
    static final String LITERAL_NODE_ID = "$(nodeId)";
    static final String LITERAL_VIRTUAL_CLUSTER_NAME = "$(virtualClusterName)";
    private static final Pattern LITERAL_NODE_ID_PATTERN = Pattern.compile(Pattern.quote("$(nodeId)"));
    private static final Pattern PORT_SPECIFIER_RE = Pattern.compile("^(.*):([1-9]\\d*)$");
    private static final Pattern TOKEN_RE = Pattern.compile("(\\$\\([^)]+\\))");

    private BrokerAddressPatternUtils() {
    }

    private static Set<String> extractTokens(String stringWithTokens) {
        Matcher tokenMatcher = TOKEN_RE.matcher(stringWithTokens);
        TreeSet<String> tokens = new TreeSet<String>();
        while (tokenMatcher.find()) {
            String token = tokenMatcher.group(1);
            tokens.add(token);
        }
        return tokens;
    }

    static void validateStringContainsOnlyExpectedTokens(String stringWithPossibleTokens, Set<String> allowedTokens, Consumer<String> disallowedTokenConsumer) {
        Objects.requireNonNull(stringWithPossibleTokens);
        Objects.requireNonNull(allowedTokens);
        Objects.requireNonNull(disallowedTokenConsumer);
        Set<String> tokens = BrokerAddressPatternUtils.extractTokens(stringWithPossibleTokens);
        tokens.removeAll(allowedTokens);
        tokens.forEach(disallowedTokenConsumer);
    }

    static void validateStringContainsRequiredTokens(String stringWithTokens, Set<String> requiredTokens, Consumer<String> requiredTokenAbsentConsumer) {
        Objects.requireNonNull(stringWithTokens);
        Objects.requireNonNull(requiredTokens);
        Objects.requireNonNull(requiredTokenAbsentConsumer);
        Set<String> tokens = BrokerAddressPatternUtils.extractTokens(stringWithTokens);
        TreeSet<String> requiredTokensCopy = new TreeSet<String>(requiredTokens);
        requiredTokensCopy.removeAll(tokens);
        if (!requiredTokensCopy.isEmpty()) {
            requiredTokensCopy.forEach(requiredTokenAbsentConsumer);
        }
    }

    static void validatePortSpecifier(String address, Consumer<String> portNumber) {
        Matcher portMatcher = PORT_SPECIFIER_RE.matcher(address);
        if (portMatcher.matches()) {
            portNumber.accept(portMatcher.group(2));
        }
    }

    static PatternAndPort parse(String address) {
        Objects.requireNonNull(address);
        Matcher portMatcher = PORT_SPECIFIER_RE.matcher(address);
        if (portMatcher.matches()) {
            return new PatternAndPort(portMatcher.group(1), Optional.of(Integer.parseInt(portMatcher.group(2))));
        }
        return new PatternAndPort(address, Optional.empty());
    }

    static String replaceVirtualClusterName(String toReplace, String clusterName) {
        return toReplace.replaceAll(Pattern.quote(LITERAL_VIRTUAL_CLUSTER_NAME), Matcher.quoteReplacement(clusterName));
    }

    static String replaceLiteralNodeId(String brokerAddressPattern, int nodeId) {
        return LITERAL_NODE_ID_PATTERN.matcher(brokerAddressPattern).replaceAll(Integer.toString(nodeId));
    }

    static String createNodeIdCapturingRegexPattern(String brokerAddressPattern, String virtualClusterName) {
        String clusterReplaced = BrokerAddressPatternUtils.replaceVirtualClusterName(brokerAddressPattern, virtualClusterName);
        Stream<String> partsQuoted = Arrays.stream(clusterReplaced.split(Pattern.quote(LITERAL_NODE_ID), -1)).map(Pattern::quote);
        return partsQuoted.collect(Collectors.joining("(\\d+)"));
    }

    record PatternAndPort(String addressPattern, Optional<Integer> port) {
        PatternAndPort {
            Objects.requireNonNull(addressPattern);
            Objects.requireNonNull(port);
            if (addressPattern.isEmpty()) {
                throw new IllegalArgumentException("pattern is empty");
            }
        }
    }
}

