/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.config.BrokerAddressPatternUtils;
import io.kroxylicious.proxy.config.NamedRange;
import io.kroxylicious.proxy.config.NodeIdentificationStrategyFactory;
import io.kroxylicious.proxy.config.Range;
import io.kroxylicious.proxy.service.HostPort;
import io.kroxylicious.proxy.service.NodeIdentificationStrategy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PortIdentifiesNodeIdentificationStrategy
implements NodeIdentificationStrategyFactory {
    private static final Set<String> ALLOWED_TOKEN_SET = Set.of("$(nodeId)");
    static final NamedRange DEFAULT_RANGE = new NamedRange("default", 0, 2);
    @JsonProperty(required=true)
    private final HostPort bootstrapAddress;
    @Nullable
    private final String advertisedBrokerAddressPattern;
    @JsonIgnore
    private final String computedAdvertisedBrokerAddressPattern;
    @Nullable
    private final Integer nodeStartPort;
    @JsonIgnore
    private final Integer computedNodeStartPort;
    @Nullable
    private final List<NamedRange> nodeIdRanges;
    @JsonIgnore
    private final List<NamedRange> computedNodeIdRanges;
    @JsonIgnore
    private final Map<Integer, Integer> nodeIdToPort;
    @JsonIgnore
    private final Set<Integer> exclusivePorts;

    @JsonCreator
    public PortIdentifiesNodeIdentificationStrategy(@JsonProperty(required=true, value="bootstrapAddress") HostPort bootstrapAddress, @JsonProperty(required=false, value="advertisedBrokerAddressPattern") @Nullable String advertisedBrokerAddressPattern, @JsonProperty(required=false, value="nodeStartPort") @Nullable Integer nodeStartPort, @JsonProperty(required=false, value="nodeIdRanges") @Nullable List<NamedRange> nodeIdRanges) {
        Objects.requireNonNull(bootstrapAddress, "bootstrapAddress cannot be null");
        this.bootstrapAddress = bootstrapAddress;
        this.advertisedBrokerAddressPattern = advertisedBrokerAddressPattern;
        this.computedAdvertisedBrokerAddressPattern = advertisedBrokerAddressPattern != null ? advertisedBrokerAddressPattern : bootstrapAddress.host();
        PortIdentifiesNodeIdentificationStrategy.verifyNodeAddressPattern(this.computedAdvertisedBrokerAddressPattern);
        this.nodeStartPort = nodeStartPort;
        this.computedNodeStartPort = nodeStartPort != null ? nodeStartPort : bootstrapAddress.port() + 1;
        if (this.computedNodeStartPort < 1) {
            throw new IllegalArgumentException("nodeStartPort cannot be less than 1");
        }
        this.nodeIdRanges = nodeIdRanges;
        List<NamedRange> namedRanges = Optional.ofNullable(nodeIdRanges).filter(Predicate.not(List::isEmpty)).orElse(List.of(DEFAULT_RANGE));
        PortIdentifiesNodeIdentificationStrategy.verifyRangeNamesAreUnique(namedRanges);
        PortIdentifiesNodeIdentificationStrategy.verifyRangesAreDistinct(namedRanges);
        this.nodeIdToPort = PortIdentifiesNodeIdentificationStrategy.mapNodeIdToPort(namedRanges, this.computedNodeStartPort);
        int numberOfNodePorts = this.nodeIdToPort.size();
        if (this.computedNodeStartPort + numberOfNodePorts - 1 > 65535) {
            throw new IllegalArgumentException("The maximum port mapped exceeded 65535");
        }
        PortIdentifiesNodeIdentificationStrategy.verifyNoRangeContainsBootstrapPort(bootstrapAddress, namedRanges, this.computedNodeStartPort, this.nodeIdToPort);
        this.computedNodeIdRanges = namedRanges;
        HashSet<Integer> allExclusivePorts = new HashSet<Integer>(this.nodeIdToPort.values());
        allExclusivePorts.add(bootstrapAddress.port());
        this.exclusivePorts = Collections.unmodifiableSet(allExclusivePorts);
    }

    private static void verifyNodeAddressPattern(String advertisedBrokerAddressPattern) {
        if (advertisedBrokerAddressPattern.isBlank()) {
            throw new IllegalArgumentException("nodeAddressPattern cannot be blank");
        }
        BrokerAddressPatternUtils.validatePortSpecifier(advertisedBrokerAddressPattern, s -> {
            throw new IllegalArgumentException("nodeAddressPattern cannot have port specifier.  Found port : " + s + " within " + advertisedBrokerAddressPattern);
        });
        BrokerAddressPatternUtils.validateStringContainsOnlyExpectedTokens(advertisedBrokerAddressPattern, ALLOWED_TOKEN_SET, token -> {
            throw new IllegalArgumentException("nodeAddressPattern contains an unexpected replacement token '" + token + "'");
        });
    }

    private static void verifyRangeNamesAreUnique(List<NamedRange> namedRanges) {
        Map<String, List<NamedRange>> collect = namedRanges.stream().collect(Collectors.groupingBy(NamedRange::name));
        List<String> nonUniqueNames = collect.entrySet().stream().filter(stringListEntry -> ((List)stringListEntry.getValue()).size() > 1).map(Map.Entry::getKey).toList();
        if (!nonUniqueNames.isEmpty()) {
            throw new IllegalArgumentException("non-unique nodeIdRange names discovered: " + String.valueOf(nonUniqueNames));
        }
    }

    private static void verifyRangesAreDistinct(List<NamedRange> ranges) {
        ArrayList<RangeCollision> collisions = new ArrayList<RangeCollision>();
        for (int i = 0; i < ranges.size(); ++i) {
            for (int j = 0; j < ranges.size(); ++j) {
                NamedRange rangeB;
                NamedRange rangeA;
                if (j <= i || (rangeA = ranges.get(i)).isDistinctFrom(rangeB = ranges.get(j))) continue;
                collisions.add(new RangeCollision(rangeA, rangeB));
            }
        }
        if (!collisions.isEmpty()) {
            throw new IllegalArgumentException("some nodeIdRanges collided (one or more node ids are duplicated in the following ranges): " + collisions.stream().map(RangeCollision::toString).collect(Collectors.joining(", ")));
        }
    }

    private static void verifyNoRangeContainsBootstrapPort(HostPort bootstrapAddress, List<NamedRange> namedRanges, Integer nodeStartPort1, Map<Integer, Integer> nodeIdToPort) {
        for (NamedRange namedRange : namedRanges) {
            namedRange.values().forEach(value -> {
                if (Objects.equals(nodeIdToPort.get(value), bootstrapAddress.port())) {
                    int endExclusive = namedRange.end() + nodeStartPort1 + 1;
                    Range portRange = new Range(namedRange.start() + nodeStartPort1, endExclusive);
                    throw new IllegalArgumentException("the port used by the bootstrap address (%d) collides with the node id range: %s mapped to ports %s".formatted(bootstrapAddress.port(), namedRange.name() + ":" + namedRange.toIntervalNotationString(), portRange));
                }
            });
        }
    }

    private static Map<Integer, Integer> mapNodeIdToPort(List<NamedRange> ranges, Integer nodeStartPort) {
        IntStream unsortedNodeIds = ranges.stream().flatMapToInt(NamedRange::values);
        List<Integer> ascendingNodeIds = unsortedNodeIds.distinct().sorted().boxed().toList();
        HashMap<Integer, Integer> nodeIdToPort = new HashMap<Integer, Integer>();
        for (int offset = 0; offset < ascendingNodeIds.size(); ++offset) {
            nodeIdToPort.put(ascendingNodeIds.get(offset), nodeStartPort + offset);
        }
        return nodeIdToPort;
    }

    @JsonProperty
    @Nullable
    public Integer getNodeStartPort() {
        return this.nodeStartPort;
    }

    @JsonProperty
    @Nullable
    public List<NamedRange> getNodeIdRanges() {
        return this.nodeIdRanges;
    }

    @JsonProperty
    @Nullable
    public String getAdvertisedBrokerAddressPattern() {
        return this.advertisedBrokerAddressPattern;
    }

    @JsonProperty(required=true)
    public HostPort getBootstrapAddress() {
        return this.bootstrapAddress;
    }

    @Override
    public NodeIdentificationStrategy buildStrategy(String clusterName) {
        return new Strategy();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PortIdentifiesNodeIdentificationStrategy that = (PortIdentifiesNodeIdentificationStrategy)obj;
        return Objects.equals(this.bootstrapAddress, that.bootstrapAddress) && Objects.equals(this.computedAdvertisedBrokerAddressPattern, that.computedAdvertisedBrokerAddressPattern) && Objects.equals(this.computedNodeStartPort, that.computedNodeStartPort) && Objects.equals(this.computedNodeIdRanges, that.computedNodeIdRanges);
    }

    public int hashCode() {
        return Objects.hash(this.bootstrapAddress, this.computedAdvertisedBrokerAddressPattern, this.computedNodeStartPort, this.computedNodeIdRanges);
    }

    public String toString() {
        return "PortIdentifiesNodeIdentificationStrategy[bootstrapAddress=" + String.valueOf(this.bootstrapAddress) + ", advertisedBrokerAddressPattern=" + this.computedAdvertisedBrokerAddressPattern + ", nodeStartPort=" + this.computedNodeStartPort + ", nodeIdRanges=" + String.valueOf(this.computedNodeIdRanges) + "]";
    }

    private record RangeCollision(NamedRange a, NamedRange b) {
        @Override
        public String toString() {
            return "'" + this.a.name() + ":" + this.a.toIntervalNotationString() + "' collides with '" + this.b.name() + ":" + this.b.toIntervalNotationString() + "'";
        }
    }

    private class Strategy
    implements NodeIdentificationStrategy {
        private Strategy() {
        }

        @Override
        public HostPort getClusterBootstrapAddress() {
            return PortIdentifiesNodeIdentificationStrategy.this.bootstrapAddress;
        }

        @Override
        public HostPort getBrokerAddress(int nodeId) throws IllegalArgumentException {
            if (!PortIdentifiesNodeIdentificationStrategy.this.nodeIdToPort.containsKey(nodeId)) {
                throw new IllegalArgumentException("Cannot generate node address for node id %d as it is not contained in the ranges defined for provider with downstream bootstrap %s".formatted(nodeId, PortIdentifiesNodeIdentificationStrategy.this.bootstrapAddress));
            }
            int port = PortIdentifiesNodeIdentificationStrategy.this.nodeIdToPort.get(nodeId);
            return new HostPort(BrokerAddressPatternUtils.replaceLiteralNodeId(PortIdentifiesNodeIdentificationStrategy.this.computedAdvertisedBrokerAddressPattern, nodeId), port);
        }

        @Override
        public Set<Integer> getExclusivePorts() {
            return PortIdentifiesNodeIdentificationStrategy.this.exclusivePorts;
        }

        @Override
        public Map<Integer, HostPort> discoveryAddressMap() {
            return PortIdentifiesNodeIdentificationStrategy.this.nodeIdToPort.keySet().stream().collect(Collectors.toMap(Function.identity(), this::getBrokerAddress));
        }
    }
}

