/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.config.IllegalConfigurationException;
import io.kroxylicious.proxy.config.TargetCluster;
import io.kroxylicious.proxy.config.VirtualClusterGateway;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public record VirtualCluster(@JsonProperty(required=true) String name, @JsonProperty(required=true) TargetCluster targetCluster, @JsonProperty(required=true) List<VirtualClusterGateway> gateways, boolean logNetwork, boolean logFrames, @Nullable List<String> filters) {
    private static final Pattern DNS_LABEL_PATTERN = Pattern.compile("^[a-z0-9]([-a-z0-9]*[a-z0-9])?$", 2);

    public VirtualCluster(@JsonProperty(required=true) String name, @JsonProperty(required=true) TargetCluster targetCluster, @JsonProperty(required=true) List<VirtualClusterGateway> gateways, boolean logNetwork, boolean logFrames, @Nullable List<String> filters) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(targetCluster);
        if (!this.isDnsLabel(name)) {
            throw new IllegalConfigurationException("Virtual cluster name '" + name + "' is invalid. It must be less than 64 characters long and match pattern " + DNS_LABEL_PATTERN.pattern() + " (case insensitive)");
        }
        if (gateways == null || gateways.isEmpty()) {
            throw new IllegalConfigurationException("no gateways configured for virtual cluster '" + name + "'");
        }
        if (gateways.stream().anyMatch(Objects::isNull)) {
            throw new IllegalConfigurationException("one or more gateways were null for virtual cluster '" + name + "'");
        }
        this.validateNoDuplicatedGatewayNames(gateways);
        this.name = name;
        this.targetCluster = targetCluster;
        this.gateways = gateways;
        this.logNetwork = logNetwork;
        this.logFrames = logFrames;
        this.filters = filters;
    }

    boolean isDnsLabel(String name) {
        if (name.length() > 63) {
            return false;
        }
        return DNS_LABEL_PATTERN.matcher(name).matches();
    }

    private void validateNoDuplicatedGatewayNames(List<VirtualClusterGateway> gateways) {
        List<String> names = gateways.stream().map(VirtualClusterGateway::name).toList();
        Set duplicates = names.stream().filter(i -> Collections.frequency(names, i) > 1).collect(Collectors.toSet());
        if (!duplicates.isEmpty()) {
            throw new IllegalConfigurationException("Gateway names for a virtual cluster must be unique. The following gateway names are duplicated: [%s]".formatted(String.join((CharSequence)", ", duplicates)));
        }
    }
}

