/*
 * Decompiled with CFR 0.152.
 */
package io.kroxylicious.proxy.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.Nullable;
import io.kroxylicious.proxy.config.IllegalConfigurationException;
import io.kroxylicious.proxy.config.PortIdentifiesNodeIdentificationStrategy;
import io.kroxylicious.proxy.config.SniHostIdentifiesNodeIdentificationStrategy;
import io.kroxylicious.proxy.config.tls.Tls;
import io.kroxylicious.proxy.service.NodeIdentificationStrategy;
import java.util.Objects;
import java.util.Optional;

public record VirtualClusterGateway(@JsonProperty(required=true) String name, @JsonProperty(required=false) @Nullable PortIdentifiesNodeIdentificationStrategy portIdentifiesNode, @JsonProperty(required=false) @Nullable SniHostIdentifiesNodeIdentificationStrategy sniHostIdentifiesNode, Optional<Tls> tls) {
    public VirtualClusterGateway {
        Objects.requireNonNull(name);
        Objects.requireNonNull(tls);
        if (portIdentifiesNode == null == (sniHostIdentifiesNode == null)) {
            throw new IllegalConfigurationException("Must specify either portIdentifiesNode or sniHostIdentifiesNode (virtual cluster listener %s)".formatted(name));
        }
        if (sniHostIdentifiesNode != null && tls.isEmpty()) {
            throw new IllegalConfigurationException("When using 'sniHostIdentifiesNode', 'tls' must be provided (virtual cluster listener %s)".formatted(name));
        }
    }

    public NodeIdentificationStrategy buildNodeIdentificationStrategy(String clusterName) {
        if (this.portIdentifiesNode() != null) {
            return this.portIdentifiesNode().buildStrategy(clusterName);
        }
        if (this.sniHostIdentifiesNode() != null) {
            return this.sniHostIdentifiesNode().buildStrategy(clusterName);
        }
        throw new IllegalStateException("Failed to create provider for " + String.valueOf(this));
    }

    @Override
    public String toString() {
        return "VirtualClusterListener{name='" + this.name + "', portIdentifiesNode=" + String.valueOf(this.portIdentifiesNode) + ", sniHostIdentifiesNode=" + String.valueOf(this.sniHostIdentifiesNode) + ", tls=" + String.valueOf(this.tls) + "}";
    }
}

